# shared.py.in
#
# Copyright 2023-2024 kramo
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

"""Shared data across the application."""

from pathlib import Path
import platform

from gi.repository import Gio, GLib

APP_ID = "org.gnome.Showtime"
VERSION = "47.0"
PREFIX = "/org/gnome/Showtime"
PROFILE = "release"

system = platform.system()

app = None

schema = Gio.Settings.new(APP_ID)
state_schema = Gio.Settings.new(APP_ID + ".State")

cache_path = Path(GLib.get_user_cache_dir()) / "showtime"
log_files = []

end_timestamp_type = state_schema.get_enum("end-timestamp-type")

# For large enough monitors, occupy 40% of the screen area when opening a window with a video
DEFAULT_OCCUPY_SCREEN = 0.4

# Screens with this resolution or smaller are handled as small
SMALL_SCREEN_AREA = 1280 * 1024

# For small monitors, occupy 80% of the screen area
SMALL_OCCUPY_SCREEN = 0.8

MAX_UINT16 = 65535
