/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class ExportDialog {
    private static final String LAST_CHOOSEN_EXPORT_FILE_FILTER = "lastChoosenExportFileFilter";
    public static final String EXPORT_MAP_TITLE = "ExportAction.text";
    public static final String EXPORT_BRANCHES_TITLE = "ExportBranchesAction.text";
    private final JFileChooser fileChooser = UITools.newFileChooser(null);
    private final Map<FileFilter, IExportEngine> exportEngines;

    ExportDialog(List<FileFilter> fileFilters, Map<FileFilter, IExportEngine> exportEngines, String dialogTitle) {
        this.exportEngines = exportEngines;
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setDialogTitle(TextUtils.getText((String)dialogTitle));
        this.fileChooser.setToolTipText(TextUtils.getText((String)"select_file_export_to"));
        for (FileFilter filter : fileFilters) {
            this.fileChooser.addChoosableFileFilter(filter);
        }
        this.preselectFileFilter();
    }

    private void preselectFileFilter() {
        FileFilter[] choosableFileFilters;
        String lastChoosenExportFileFilter = ResourceController.getResourceController().getProperty(LAST_CHOOSEN_EXPORT_FILE_FILTER, null);
        for (FileFilter f : choosableFileFilters = this.fileChooser.getChoosableFileFilters()) {
            if (!f.getDescription().equals(lastChoosenExportFileFilter)) continue;
            this.fileChooser.setFileFilter(f);
            return;
        }
        FileFilter fileFilter = choosableFileFilters[0];
        this.fileChooser.setFileFilter(fileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export(Component parentframe, List<NodeModel> branches) {
        if (this.exportEngines.isEmpty()) {
            JOptionPane.showMessageDialog(parentframe, TextUtils.getText((String)"xslt_export_not_possible"));
            return;
        }
        MapModel map = branches.get(0).getMap();
        File xmlSourceFile = map.getFile();
        final String absolutePathWithoutExtension = xmlSourceFile != null ? FileUtils.removeExtension((String)xmlSourceFile.getAbsolutePath()) : null;
        PropertyChangeListener filterChangeListener = new PropertyChangeListener(){
            private final File selectedFile;
            {
                this.selectedFile = absolutePathWithoutExtension == null ? null : new File(absolutePathWithoutExtension);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    FileFilter filter = ExportDialog.this.fileChooser.getFileFilter();
                    if (!(filter instanceof CaseSensitiveFileNameExtensionFilter)) {
                        return;
                    }
                    final File acceptableFile = ExportDialog.this.getAcceptableFile(this.selectedFile, (CaseSensitiveFileNameExtensionFilter)filter);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExportDialog.this.fileChooser.setSelectedFile(acceptableFile);
                        }
                    });
                    return;
                }
                if (this.selectedFile != null && evt.getPropertyName().equals("directoryChanged")) {
                    FileFilter filter = ExportDialog.this.fileChooser.getFileFilter();
                    if (!(filter instanceof CaseSensitiveFileNameExtensionFilter)) {
                        return;
                    }
                    File acceptableFile = ExportDialog.this.getAcceptableFile(this.selectedFile, (CaseSensitiveFileNameExtensionFilter)filter);
                    File currentDirectory = ExportDialog.this.fileChooser.getCurrentDirectory();
                    if (currentDirectory != null) {
                        File file = new File(currentDirectory, acceptableFile.getName());
                        ExportDialog.this.fileChooser.setSelectedFile(file);
                    } else {
                        ExportDialog.this.fileChooser.setSelectedFile(acceptableFile);
                    }
                    return;
                }
            }
        };
        filterChangeListener.propertyChange(new PropertyChangeEvent(this.fileChooser, "fileFilterChanged", null, this.fileChooser.getFileFilter()));
        try {
            this.fileChooser.addPropertyChangeListener(filterChangeListener);
            int returnVal = this.fileChooser.showSaveDialog(parentframe);
            FileFilter currentfileFilter = this.fileChooser.getFileFilter();
            String lastFileFilterDescription = currentfileFilter.getDescription();
            if (currentfileFilter instanceof CaseSensitiveFileNameExtensionFilter) {
                ResourceController.getResourceController().setProperty(LAST_CHOOSEN_EXPORT_FILE_FILTER, lastFileFilterDescription);
            }
            if (returnVal == 0) {
                if (!(currentfileFilter instanceof CaseSensitiveFileNameExtensionFilter)) {
                    UITools.errorMessage((Object)TextUtils.getText((String)"invalid_export_file"));
                    return;
                }
                CaseSensitiveFileNameExtensionFilter fileFilter = (CaseSensitiveFileNameExtensionFilter)currentfileFilter;
                File selectedFile = this.getAcceptableFile(this.fileChooser.getSelectedFile(), fileFilter);
                if (selectedFile == null) {
                    return;
                }
                if (selectedFile.isDirectory()) {
                    return;
                }
                if (selectedFile.exists()) {
                    String overwriteText = MessageFormat.format(TextUtils.getText((String)"file_already_exists"), selectedFile.toString());
                    int overwriteMap = JOptionPane.showConfirmDialog(UITools.getCurrentRootComponent(), overwriteText, overwriteText, 0);
                    if (overwriteMap != 0) {
                        return;
                    }
                }
                IExportEngine exportEngine = this.exportEngines.get(fileFilter);
                exportEngine.export(branches, selectedFile);
            }
        }
        finally {
            this.fileChooser.removePropertyChangeListener(filterChangeListener);
        }
    }

    private File getAcceptableFile(File selectedFile, CaseSensitiveFileNameExtensionFilter fileFilter) {
        if (selectedFile == null) {
            return null;
        }
        if (!fileFilter.accept(selectedFile)) {
            selectedFile = new File(selectedFile.getAbsolutePath() + '.' + fileFilter.getExtensionProposal());
        }
        return selectedFile;
    }
}

