/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeConditionController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeNotExistsCondition
extends ASelectableCondition {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_not_exists_condition";
    private final Object attribute;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeNotExistsCondition(AttributeConditionController.toAttributeObject(element.getAttribute(ATTRIBUTE, null)));
    }

    public AttributeNotExistsCondition(Object attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_does_not_exist");
        return ConditionFactory.createDescription(this.attribute.toString(), simpleCondition, null);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.attribute instanceof String) {
            child.setAttribute(ATTRIBUTE, (String)this.attribute);
        }
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

