
use builtin;
use str;

set edit:completion:arg-completer[uv] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'uv'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'uv'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
            cand run 'Run a command or script'
            cand init 'Create a new project'
            cand add 'Add dependencies to the project'
            cand remove 'Remove dependencies from the project'
            cand sync 'Update the project''s environment'
            cand lock 'Update the project''s lockfile'
            cand export 'Export the project''s lockfile to an alternate format'
            cand tree 'Display the project''s dependency tree'
            cand tool 'Run and install commands provided by Python packages'
            cand python 'Manage Python versions and installations'
            cand pip 'Manage Python packages with a pip-compatible interface'
            cand venv 'Create a virtual environment'
            cand build 'Build Python packages into source distributions and wheels'
            cand publish 'Upload distributions to an index'
            cand build-backend 'The implementation of the build backend'
            cand cache 'Manage uv''s cache'
            cand self 'Manage the uv executable'
            cand clean 'Clear the cache, removing all entries or those linked to specific packages'
            cand version 'Display uv''s version'
            cand generate-shell-completion 'Generate shell completion'
            cand help 'Display documentation for a command'
        }
        &'uv;run'= {
            cand --extra 'Include optional dependencies from the specified extra name'
            cand --no-extra 'Exclude the specified optional dependencies, if `--all-extras` is supplied'
            cand --group 'Include dependencies from the specified dependency group'
            cand --no-group 'Disable the specified dependency group'
            cand --only-group 'Only include dependencies from the specified dependency group'
            cand --env-file 'Load environment variables from a `.env` file'
            cand --with 'Run with the given packages installed'
            cand --with-editable 'Run with the given packages installed in editable mode'
            cand --with-requirements 'Run with all packages listed in the given `requirements.txt` files'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --package 'Run the command in a specific package in the workspace'
            cand -p 'The Python interpreter to use for the run environment.'
            cand --python 'The Python interpreter to use for the run environment.'
            cand --max-recursion-depth 'Number of times that `uv run` will allow recursive invocations'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies'
            cand --no-all-extras 'no-all-extras'
            cand --dev 'Include the development dependency group'
            cand --no-dev 'Disable the development dependency group'
            cand --no-default-groups 'Ignore the default dependency groups'
            cand --all-groups 'Include dependencies from all dependency groups'
            cand -m 'Run a Python module'
            cand --module 'Run a Python module'
            cand --only-dev 'Only include the development dependency group'
            cand --no-editable 'Install any editable dependencies, including the project and any workspace members, as non-editable'
            cand --inexact 'Do not remove extraneous packages present in the environment'
            cand --exact 'Perform an exact sync, removing extraneous packages'
            cand --no-env-file 'Avoid reading environment variables from a `.env` file'
            cand --isolated 'Run the command in an isolated virtual environment'
            cand --active 'Prefer the active virtual environment over the project''s virtual environment'
            cand --no-active 'Prefer project''s virtual environment over an active environment'
            cand --no-sync 'Avoid syncing the virtual environment'
            cand --locked 'Assert that the `uv.lock` will remain unchanged'
            cand --frozen 'Run without updating the `uv.lock` file'
            cand -s 'Run the given path as a Python script'
            cand --script 'Run the given path as a Python script'
            cand --gui-script 'Run the given path as a Python GUI script'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --all-packages 'Run the command with all workspace members installed'
            cand --no-project 'Avoid discovering the project or workspace'
            cand --show-resolution 'Whether to show resolver and installer output from any environment modifications'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;init'= {
            cand --name 'The name of the project'
            cand --description 'Set the project description'
            cand --vcs 'Initialize a version control system for the project'
            cand --build-backend 'Initialize a build-backend of choice for the project'
            cand --author-from 'Fill in the `authors` field in the `pyproject.toml`'
            cand -p 'The Python interpreter to use to determine the minimum supported Python version.'
            cand --python 'The Python interpreter to use to determine the minimum supported Python version.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --bare 'Only create a `pyproject.toml`'
            cand --virtual 'Create a virtual project, rather than a package'
            cand --package 'Set up the project to be built as a Python package'
            cand --no-package 'Do not set up the project to be built as a Python package'
            cand --app 'Create a project for an application'
            cand --lib 'Create a project for a library'
            cand --script 'Create a script'
            cand --no-description 'Disable the description for the project'
            cand --backend 'Invalid option name for build backend'
            cand --no-readme 'Do not create a `README.md` file'
            cand --no-pin-python 'Do not create a `.python-version` file for the project'
            cand --pin-python 'Create a `.python-version` file for the project'
            cand --no-workspace 'Avoid discovering a workspace and create a standalone project'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;add'= {
            cand -r 'Add all packages listed in the given `requirements.txt` files'
            cand --requirements 'Add all packages listed in the given `requirements.txt` files'
            cand --optional 'Add the requirements to the package''s optional dependencies for the specified extra'
            cand --group 'Add the requirements to the specified dependency group'
            cand --rev 'Commit to use when adding a dependency from Git'
            cand --tag 'Tag to use when adding a dependency from Git'
            cand --branch 'Branch to use when adding a dependency from Git'
            cand --extra 'Extras to enable for the dependency'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --package 'Add the dependency to a specific package in the workspace'
            cand --script 'Add the dependency to the specified Python script, rather than to a project'
            cand -p 'The Python interpreter to use for resolving and syncing.'
            cand --python 'The Python interpreter to use for resolving and syncing.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --dev 'Add the requirements to the development dependency group'
            cand --editable 'Add the requirements as editable'
            cand --no-editable 'no-editable'
            cand --raw-sources 'Add source requirements to `project.dependencies`, rather than `tool.uv.sources`'
            cand --no-sync 'Avoid syncing the virtual environment'
            cand --locked 'Assert that the `uv.lock` will remain unchanged'
            cand --frozen 'Add dependencies without re-locking the project'
            cand --active 'Prefer the active virtual environment over the project''s virtual environment'
            cand --no-active 'Prefer project''s virtual environment over an active environment'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;remove'= {
            cand --optional 'Remove the packages from the project''s optional dependencies for the specified extra'
            cand --group 'Remove the packages from the specified dependency group'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --package 'Remove the dependencies from a specific package in the workspace'
            cand --script 'Remove the dependency from the specified Python script, rather than from a project'
            cand -p 'The Python interpreter to use for resolving and syncing.'
            cand --python 'The Python interpreter to use for resolving and syncing.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --dev 'Remove the packages from the development dependency group'
            cand --no-sync 'Avoid syncing the virtual environment after re-locking the project'
            cand --active 'Prefer the active virtual environment over the project''s virtual environment'
            cand --no-active 'Prefer project''s virtual environment over an active environment'
            cand --locked 'Assert that the `uv.lock` will remain unchanged'
            cand --frozen 'Remove dependencies without re-locking the project'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;sync'= {
            cand --extra 'Include optional dependencies from the specified extra name'
            cand --no-extra 'Exclude the specified optional dependencies, if `--all-extras` is supplied'
            cand --group 'Include dependencies from the specified dependency group'
            cand --no-group 'Disable the specified dependency group'
            cand --only-group 'Only include dependencies from the specified dependency group'
            cand --no-install-package 'Do not install the given package(s)'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --package 'Sync for a specific package in the workspace'
            cand --script 'Sync the environment for a Python script, rather than the current project'
            cand -p 'The Python interpreter to use for the project environment.'
            cand --python 'The Python interpreter to use for the project environment.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies'
            cand --no-all-extras 'no-all-extras'
            cand --dev 'Include the development dependency group'
            cand --no-dev 'Disable the development dependency group'
            cand --only-dev 'Only include the development dependency group'
            cand --no-default-groups 'Ignore the default dependency groups'
            cand --all-groups 'Include dependencies from all dependency groups'
            cand --no-editable 'Install any editable dependencies, including the project and any workspace members, as non-editable'
            cand --inexact 'Do not remove extraneous packages present in the environment'
            cand --exact 'Perform an exact sync, removing extraneous packages'
            cand --active 'Sync dependencies to the active virtual environment'
            cand --no-active 'Prefer project''s virtual environment over an active environment'
            cand --no-install-project 'Do not install the current project'
            cand --no-install-workspace 'Do not install any workspace members, including the root project'
            cand --locked 'Assert that the `uv.lock` will remain unchanged'
            cand --frozen 'Sync without updating the `uv.lock` file'
            cand --dry-run 'Perform a dry run, without writing the lockfile or modifying the project environment'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --all-packages 'Sync all packages in the workspace'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;lock'= {
            cand --script 'Lock the specified Python script, rather than the current project'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use during resolution.'
            cand --python 'The Python interpreter to use during resolution.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --check 'Check if the lockfile is up-to-date'
            cand --check-exists 'Assert that a `uv.lock` exists without checking if it is up-to-date'
            cand --dry-run 'Perform a dry run, without writing the lockfile'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;export'= {
            cand --format 'The format to which `uv.lock` should be exported'
            cand --package 'Export the dependencies for a specific package in the workspace'
            cand --prune 'Prune the given package from the dependency tree'
            cand --extra 'Include optional dependencies from the specified extra name'
            cand --no-extra 'Exclude the specified optional dependencies, if `--all-extras` is supplied'
            cand --group 'Include dependencies from the specified dependency group'
            cand --no-group 'Disable the specified dependency group'
            cand --only-group 'Only include dependencies from the specified dependency group'
            cand -o 'Write the exported requirements to the given file'
            cand --output-file 'Write the exported requirements to the given file'
            cand --no-emit-package 'Do not emit the given package(s)'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --script 'Export the dependencies for the specified PEP 723 Python script, rather than the current project'
            cand -p 'The Python interpreter to use during resolution.'
            cand --python 'The Python interpreter to use during resolution.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-packages 'Export the entire workspace'
            cand --all-extras 'Include all optional dependencies'
            cand --no-all-extras 'no-all-extras'
            cand --dev 'Include the development dependency group'
            cand --no-dev 'Disable the development dependency group'
            cand --only-dev 'Only include the development dependency group'
            cand --no-default-groups 'Ignore the default dependency groups'
            cand --all-groups 'Include dependencies from all dependency groups'
            cand --no-header 'Exclude the comment header at the top of the generated output file'
            cand --header 'header'
            cand --no-editable 'Install any editable dependencies, including the project and any workspace members, as non-editable'
            cand --hashes 'Include hashes for all dependencies'
            cand --no-hashes 'Omit hashes in the generated output'
            cand --no-emit-project 'Do not emit the current project'
            cand --no-emit-workspace 'Do not emit any workspace members, including the root project'
            cand --locked 'Assert that the `uv.lock` will remain unchanged'
            cand --frozen 'Do not update the `uv.lock` before exporting'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tree'= {
            cand -d 'Maximum display depth of the dependency tree'
            cand --depth 'Maximum display depth of the dependency tree'
            cand --prune 'Prune the given package from the display of the dependency tree'
            cand --package 'Display only the specified packages'
            cand --group 'Include dependencies from the specified dependency group'
            cand --no-group 'Disable the specified dependency group'
            cand --only-group 'Only include dependencies from the specified dependency group'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --script 'Show the dependency tree the specified PEP 723 Python script, rather than the current project'
            cand --python-version 'The Python version to use when filtering the tree'
            cand --python-platform 'The platform to use when filtering the tree'
            cand -p 'The Python interpreter to use for locking and filtering.'
            cand --python 'The Python interpreter to use for locking and filtering.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --universal 'Show a platform-independent dependency tree'
            cand --no-dedupe 'Do not de-duplicate repeated dependencies. Usually, when a package has already displayed its dependencies, further occurrences will not re-display its dependencies, and will include a (*) to indicate it has already been shown. This flag will cause those duplicates to be repeated'
            cand --invert 'Show the reverse dependencies for the given package. This flag will invert the tree and display the packages that depend on the given package'
            cand --outdated 'Show the latest available version of each package in the tree'
            cand --dev 'Include the development dependency group'
            cand --only-dev 'Only include the development dependency group'
            cand --no-dev 'Disable the development dependency group'
            cand --no-default-groups 'Ignore the default dependency groups'
            cand --all-groups 'Include dependencies from all dependency groups'
            cand --locked 'Assert that the `uv.lock` will remain unchanged'
            cand --frozen 'Display the requirements without locking the project'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
            cand run 'Run a command provided by a Python package'
            cand uvx 'Run a command provided by a Python package.'
            cand install 'Install commands provided by a Python package'
            cand upgrade 'Upgrade installed tools'
            cand list 'List installed tools'
            cand uninstall 'Uninstall a tool'
            cand update-shell 'Ensure that the tool executable directory is on the `PATH`'
            cand dir 'Show the path to the uv tools directory'
        }
        &'uv;tool;run'= {
            cand --from 'Use the given package to provide the command'
            cand --with 'Run with the given packages installed'
            cand --with-editable 'Run with the given packages installed in editable mode'
            cand --with-requirements 'Run with all packages listed in the given `requirements.txt` files'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use to build the run environment.'
            cand --python 'The Python interpreter to use to build the run environment.'
            cand --generate-shell-completion 'generate-shell-completion'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --isolated 'Run the tool in an isolated virtual environment, ignoring any already-installed tools'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --show-resolution 'Whether to show resolver and installer output from any environment modifications'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool;uvx'= {
            cand --from 'Use the given package to provide the command'
            cand --with 'Run with the given packages installed'
            cand --with-editable 'Run with the given packages installed in editable mode'
            cand --with-requirements 'Run with all packages listed in the given `requirements.txt` files'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use to build the run environment.'
            cand --python 'The Python interpreter to use to build the run environment.'
            cand --generate-shell-completion 'generate-shell-completion'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --isolated 'Run the tool in an isolated virtual environment, ignoring any already-installed tools'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --show-resolution 'Whether to show resolver and installer output from any environment modifications'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool;install'= {
            cand --from 'The package to install commands from'
            cand --with 'Include the following extra requirements'
            cand --with-requirements 'Run all requirements listed in the given `requirements.txt` files'
            cand --with-editable 'Include the given packages in editable mode'
            cand -c 'Constrain versions using the given requirements files'
            cand --constraints 'Constrain versions using the given requirements files'
            cand --overrides 'Override versions using the given requirements files'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use to build the tool environment.'
            cand --python 'The Python interpreter to use to build the tool environment.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -e 'Install the target package in editable mode, such that changes in the package''s source directory are reflected without reinstallation'
            cand --editable 'Install the target package in editable mode, such that changes in the package''s source directory are reflected without reinstallation'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --force 'Force installation of the tool'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool;upgrade'= {
            cand -p 'Upgrade a tool, and specify it to use the given Python interpreter to build its environment. Use with `--all` to apply to all tools.'
            cand --python 'Upgrade a tool, and specify it to use the given Python interpreter to build its environment. Use with `--all` to apply to all tools.'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all 'Upgrade all tools'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool;list'= {
            cand --python-preference 'python-preference'
            cand --cache-dir 'Path to the cache directory'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --show-paths 'Whether to display the path to each tool environment and installed executable'
            cand --show-version-specifiers 'Whether to display the version specifier(s) used to install each tool'
            cand --no-python-downloads 'no-python-downloads'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool;uninstall'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all 'Uninstall all tools'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool;update-shell'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;tool;dir'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --bin 'Show the directory into which `uv tool` will install executables.'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;python'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
            cand list 'List the available Python installations'
            cand install 'Download and install Python versions'
            cand find 'Search for a Python installation'
            cand pin 'Pin to a specific Python version'
            cand dir 'Show the uv Python installation directory'
            cand uninstall 'Uninstall Python versions'
        }
        &'uv;python;list'= {
            cand --output-format 'Select the output format'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-versions 'List all Python versions, including old patch versions'
            cand --all-platforms 'List Python downloads for all platforms'
            cand --all-arches 'List Python downloads for all architectures'
            cand --only-installed 'Only show installed Python versions, exclude available downloads'
            cand --only-downloads 'Only show Python downloads, exclude installed distributions'
            cand --show-urls 'Show the URLs of available Python downloads'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;python;install'= {
            cand -i 'The directory to store the Python installation in'
            cand --install-dir 'The directory to store the Python installation in'
            cand --mirror 'Set the URL to use as the source for downloading Python installations'
            cand --pypy-mirror 'Set the URL to use as the source for downloading PyPy installations'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -r 'Reinstall the requested Python version, if it''s already installed'
            cand --reinstall 'Reinstall the requested Python version, if it''s already installed'
            cand -f 'Replace existing Python executables during installation'
            cand --force 'Replace existing Python executables during installation'
            cand --default 'Use as the default Python version'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;python;find'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-project 'Avoid discovering a project or workspace'
            cand --system 'Only find system Python interpreters'
            cand --no-system 'no-system'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;python;pin'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --resolved 'Write the resolved Python interpreter path instead of the request'
            cand --no-resolved 'no-resolved'
            cand --no-project 'Avoid validating the Python pin is compatible with the project or workspace'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;python;dir'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --bin 'Show the directory into which `uv python` will install Python executables.'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;python;uninstall'= {
            cand -i 'The directory where the Python was installed'
            cand --install-dir 'The directory where the Python was installed'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all 'Uninstall all managed Python versions'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
            cand compile 'Compile a `requirements.in` file to a `requirements.txt` file'
            cand sync 'Sync an environment with a `requirements.txt` file'
            cand install 'Install packages into an environment'
            cand uninstall 'Uninstall packages from an environment'
            cand freeze 'List, in requirements format, packages installed in an environment'
            cand list 'List, in tabular format, packages installed in an environment'
            cand show 'Show information about one or more installed packages'
            cand tree 'Display the dependency tree for an environment'
            cand check 'Verify installed packages have compatible dependencies'
        }
        &'uv;pip;compile'= {
            cand -c 'Constrain versions using the given requirements files'
            cand --constraints 'Constrain versions using the given requirements files'
            cand --overrides 'Override versions using the given requirements files'
            cand -b 'Constrain build dependencies using the given requirements files when building source distributions'
            cand --build-constraints 'Constrain build dependencies using the given requirements files when building source distributions'
            cand --extra 'Include optional dependencies from the specified extra name; may be provided more than once'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -o 'Write the compiled requirements to the given `requirements.txt` file'
            cand --output-file 'Write the compiled requirements to the given `requirements.txt` file'
            cand --annotation-style 'The style of the annotation comments included in the output file, used to indicate the source of each package'
            cand --custom-compile-command 'The header comment to include at the top of the output file generated by `uv pip compile`'
            cand -p 'The Python interpreter to use during resolution.'
            cand --python 'The Python interpreter to use during resolution.'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand --python-version 'The Python version to use for resolution'
            cand --python-platform 'The platform for which requirements should be resolved'
            cand --no-emit-package 'Specify a package to omit from the output resolution. Its dependencies will still be included in the resolution. Equivalent to pip-compile''s `--unsafe-package` option'
            cand --resolver 'resolver'
            cand --max-rounds 'max-rounds'
            cand --cert 'cert'
            cand --client-cert 'client-cert'
            cand --config 'config'
            cand --pip-args 'pip-args'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies'
            cand --no-all-extras 'no-all-extras'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --no-deps 'Ignore package dependencies, instead only add those packages explicitly listed on the command line to the resulting requirements file'
            cand --deps 'deps'
            cand --no-strip-extras 'Include extras in the output file'
            cand --strip-extras 'strip-extras'
            cand --no-strip-markers 'Include environment markers in the output file'
            cand --strip-markers 'strip-markers'
            cand --no-annotate 'Exclude comment annotations indicating the source of each package'
            cand --annotate 'annotate'
            cand --no-header 'Exclude the comment header at the top of the generated output file'
            cand --header 'header'
            cand --system 'Install packages into the system Python environment'
            cand --no-system 'no-system'
            cand --generate-hashes 'Include distribution hashes in the output file'
            cand --no-generate-hashes 'no-generate-hashes'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --universal 'Perform a universal resolution, attempting to generate a single `requirements.txt` output file that is compatible with all operating systems, architectures, and Python implementations'
            cand --no-universal 'no-universal'
            cand --emit-index-url 'Include `--index-url` and `--extra-index-url` entries in the generated output file'
            cand --no-emit-index-url 'no-emit-index-url'
            cand --emit-find-links 'Include `--find-links` entries in the generated output file'
            cand --no-emit-find-links 'no-emit-find-links'
            cand --emit-build-options 'Include `--no-binary` and `--only-binary` entries in the generated output file'
            cand --no-emit-build-options 'no-emit-build-options'
            cand --emit-marker-expression 'Whether to emit a marker string indicating when it is known that the resulting set of pinned dependencies is valid'
            cand --no-emit-marker-expression 'no-emit-marker-expression'
            cand --emit-index-annotation 'Include comment annotations indicating the index used to resolve each package (e.g., `# from https://pypi.org/simple`)'
            cand --no-emit-index-annotation 'no-emit-index-annotation'
            cand --allow-unsafe 'allow-unsafe'
            cand --no-allow-unsafe 'no-allow-unsafe'
            cand --reuse-hashes 'reuse-hashes'
            cand --no-reuse-hashes 'no-reuse-hashes'
            cand --emit-trusted-host 'emit-trusted-host'
            cand --no-emit-trusted-host 'no-emit-trusted-host'
            cand --no-config 'no-config'
            cand --emit-options 'emit-options'
            cand --no-emit-options 'no-emit-options'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;sync'= {
            cand -c 'Constrain versions using the given requirements files'
            cand --constraints 'Constrain versions using the given requirements files'
            cand -b 'Constrain build dependencies using the given requirements files when building source distributions'
            cand --build-constraints 'Constrain build dependencies using the given requirements files when building source distributions'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --target 'Install packages into the specified directory, rather than into the virtual or system Python environment. The packages will be installed at the top-level of the directory'
            cand --prefix 'Install packages into `lib`, `bin`, and other top-level folders under the specified directory, as if a virtual environment were present at that location'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand --python-version 'The minimum Python version that should be supported by the requirements (e.g., `3.7` or `3.7.9`)'
            cand --python-platform 'The platform for which requirements should be installed'
            cand --python-executable 'python-executable'
            cand --cert 'cert'
            cand --client-cert 'client-cert'
            cand --config 'config'
            cand --pip-args 'pip-args'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --require-hashes 'Require a matching hash for each requirement'
            cand --no-require-hashes 'no-require-hashes'
            cand --verify-hashes 'verify-hashes'
            cand --no-verify-hashes 'Disable validation of hashes in the requirements file'
            cand --system 'Install packages into the system Python environment'
            cand --no-system 'no-system'
            cand --break-system-packages 'Allow uv to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --no-break-system-packages 'no-break-system-packages'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --allow-empty-requirements 'Allow sync of empty requirements, which will clear the environment of all packages'
            cand --no-allow-empty-requirements 'no-allow-empty-requirements'
            cand --strict 'Validate the Python environment after completing the installation, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --dry-run 'Perform a dry run, i.e., don''t actually install anything but resolve the dependencies and print the resulting plan'
            cand -a 'a'
            cand --ask 'ask'
            cand --user 'user'
            cand --no-config 'no-config'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;install'= {
            cand -r 'Install all packages listed in the given `requirements.txt` files'
            cand --requirements 'Install all packages listed in the given `requirements.txt` files'
            cand -e 'Install the editable package based on the provided local file path'
            cand --editable 'Install the editable package based on the provided local file path'
            cand -c 'Constrain versions using the given requirements files'
            cand --constraints 'Constrain versions using the given requirements files'
            cand --overrides 'Override versions using the given requirements files'
            cand -b 'Constrain build dependencies using the given requirements files when building source distributions'
            cand --build-constraints 'Constrain build dependencies using the given requirements files when building source distributions'
            cand --extra 'Include optional dependencies from the specified extra name; may be provided more than once'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --target 'Install packages into the specified directory, rather than into the virtual or system Python environment. The packages will be installed at the top-level of the directory'
            cand --prefix 'Install packages into `lib`, `bin`, and other top-level folders under the specified directory, as if a virtual environment were present at that location'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand --python-version 'The minimum Python version that should be supported by the requirements (e.g., `3.7` or `3.7.9`)'
            cand --python-platform 'The platform for which requirements should be installed'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies'
            cand --no-all-extras 'no-all-extras'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed. Implies `--refresh`'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --compile-bytecode 'Compile Python files to bytecode after installation'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --no-deps 'Ignore package dependencies, instead only installing those packages explicitly listed on the command line or in the requirements files'
            cand --deps 'deps'
            cand --require-hashes 'Require a matching hash for each requirement'
            cand --no-require-hashes 'no-require-hashes'
            cand --verify-hashes 'verify-hashes'
            cand --no-verify-hashes 'Disable validation of hashes in the requirements file'
            cand --system 'Install packages into the system Python environment'
            cand --no-system 'no-system'
            cand --break-system-packages 'Allow uv to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --no-break-system-packages 'no-break-system-packages'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --inexact 'Do not remove extraneous packages present in the environment'
            cand --exact 'Perform an exact sync, removing extraneous packages'
            cand --strict 'Validate the Python environment after completing the installation, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --dry-run 'Perform a dry run, i.e., don''t actually install anything but resolve the dependencies and print the resulting plan'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand --user 'user'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;uninstall'= {
            cand -r 'Uninstall all packages listed in the given requirements files'
            cand --requirements 'Uninstall all packages listed in the given requirements files'
            cand -p 'The Python interpreter from which packages should be uninstalled.'
            cand --python 'The Python interpreter from which packages should be uninstalled.'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for remote requirements files'
            cand --target 'Uninstall packages from the specified `--target` directory'
            cand --prefix 'Uninstall packages from the specified `--prefix` directory'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --system 'Use the system Python to uninstall packages'
            cand --no-system 'no-system'
            cand --break-system-packages 'Allow uv to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --no-break-system-packages 'no-break-system-packages'
            cand --dry-run 'Perform a dry run, i.e., don''t actually uninstall anything but print the resulting plan'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;freeze'= {
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --path 'Restrict to the specified installation path for listing packages (can be used multiple times)'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --exclude-editable 'Exclude any editable packages from output'
            cand --strict 'Validate the Python environment, to detect packages with missing dependencies and other issues'
            cand --no-strict 'no-strict'
            cand --system 'List packages in the system Python environment'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;list'= {
            cand --exclude 'Exclude the specified package(s) from the output'
            cand --format 'Select the output format'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -e 'Only include editable projects'
            cand --editable 'Only include editable projects'
            cand --exclude-editable 'Exclude any editable packages from output'
            cand --outdated 'List outdated packages'
            cand --no-outdated 'no-outdated'
            cand --strict 'Validate the Python environment, to detect packages with missing dependencies and other issues'
            cand --no-strict 'no-strict'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand --system 'List packages in the system Python environment'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;show'= {
            cand -p 'The Python interpreter to find the package in.'
            cand --python 'The Python interpreter to find the package in.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --strict 'Validate the Python environment, to detect packages with missing dependencies and other issues'
            cand --no-strict 'no-strict'
            cand -f 'Show the full list of installed files for each package'
            cand --files 'Show the full list of installed files for each package'
            cand --system 'Show a package in the system Python environment'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;tree'= {
            cand -d 'Maximum display depth of the dependency tree'
            cand --depth 'Maximum display depth of the dependency tree'
            cand --prune 'Prune the given package from the display of the dependency tree'
            cand --package 'Display only the specified packages'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --show-version-specifiers 'Show the version constraint(s) imposed on each package'
            cand --no-dedupe 'Do not de-duplicate repeated dependencies. Usually, when a package has already displayed its dependencies, further occurrences will not re-display its dependencies, and will include a (*) to indicate it has already been shown. This flag will cause those duplicates to be repeated'
            cand --invert 'Show the reverse dependencies for the given package. This flag will invert the tree and display the packages that depend on the given package'
            cand --outdated 'Show the latest available version of each package in the tree'
            cand --strict 'Validate the Python environment, to detect packages with missing dependencies and other issues'
            cand --no-strict 'no-strict'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand --system 'List packages in the system Python environment'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;pip;check'= {
            cand -p 'The Python interpreter for which packages should be checked.'
            cand --python 'The Python interpreter for which packages should be checked.'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --system 'Check packages in the system Python environment'
            cand --no-system 'no-system'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;venv'= {
            cand -p 'The Python interpreter to use for the virtual environment.'
            cand --python 'The Python interpreter to use for the virtual environment.'
            cand --prompt 'Provide an alternative prompt prefix for the virtual environment.'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --system 'Ignore virtual environments when searching for the Python interpreter'
            cand --no-system 'This flag is included for compatibility only, it has no effect'
            cand --no-project 'Avoid discovering a project or workspace'
            cand --seed 'Install seed packages (one or more of: `pip`, `setuptools`, and `wheel`) into the virtual environment'
            cand --allow-existing 'Preserve any existing files or directories at the target path'
            cand --system-site-packages 'Give the virtual environment access to the system site packages directory'
            cand --relocatable 'Make the virtual environment relocatable'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --clear 'clear'
            cand --no-seed 'no-seed'
            cand --no-pip 'no-pip'
            cand --no-setuptools 'no-setuptools'
            cand --no-wheel 'no-wheel'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build'= {
            cand --package 'Build a specific package in the workspace'
            cand -o 'The output directory to which distributions should be written'
            cand --out-dir 'The output directory to which distributions should be written'
            cand -b 'Constrain build dependencies using the given requirements files when building distributions'
            cand --build-constraints 'Constrain build dependencies using the given requirements files when building distributions'
            cand -p 'The Python interpreter to use for the build environment.'
            cand --python 'The Python interpreter to use for the build environment.'
            cand --index 'The URLs to use when resolving dependencies, in addition to the default index'
            cand --default-index 'The URL of the default package index (by default: <https://pypi.org/simple>)'
            cand -i '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url '(Deprecated: use `--default-index` instead) The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url '(Deprecated: use `--index` instead) Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand --find-links 'Locations to search for candidate distributions, in addition to those found in the registry indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file. Implies `--refresh-package`'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand --fork-strategy 'The strategy to use when selecting multiple versions of a given package across Python versions and platforms'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --no-build-isolation-package 'Disable isolation when building source distributions for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-packages 'Builds all packages in the workspace'
            cand --sdist 'Build a source distribution ("sdist") from the given directory'
            cand --wheel 'Build a binary distribution ("wheel") from the given directory'
            cand --list 'When using the uv build backend, list the files that would be included when building'
            cand --build-logs 'build-logs'
            cand --no-build-logs 'Hide logs from the build backend'
            cand --force-pep517 'Always build through PEP 517, don''t use the fast path for the uv build backend'
            cand --require-hashes 'Require a matching hash for each requirement'
            cand --no-require-hashes 'no-require-hashes'
            cand --verify-hashes 'verify-hashes'
            cand --no-verify-hashes 'Disable validation of hashes in the requirements file'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those provided via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file. Implies `--refresh`'
            cand --no-upgrade 'no-upgrade'
            cand --pre 'pre'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-sources 'Ignore the `tool.uv.sources` table when resolving dependencies. Used to lock against the standards-compliant, publishable package metadata, as opposed to using any workspace, Git, URL, or local path sources'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;publish'= {
            cand --index 'The name of an index in the configuration to use for publishing'
            cand -u 'The username for the upload'
            cand --username 'The username for the upload'
            cand -p 'The password for the upload'
            cand --password 'The password for the upload'
            cand -t 'The token for the upload'
            cand --token 'The token for the upload'
            cand --trusted-publishing 'Configure using trusted publishing through GitHub Actions'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for remote requirements files'
            cand --publish-url 'The URL of the upload endpoint (not the index URL)'
            cand --check-url 'Check an index URL for existing files to skip duplicate uploads'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --skip-existing 'skip-existing'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
            cand build-sdist 'PEP 517 hook `build_sdist`'
            cand build-wheel 'PEP 517 hook `build_wheel`'
            cand build-editable 'PEP 660 hook `build_editable`'
            cand get-requires-for-build-sdist 'PEP 517 hook `get_requires_for_build_sdist`'
            cand get-requires-for-build-wheel 'PEP 517 hook `get_requires_for_build_wheel`'
            cand prepare-metadata-for-build-wheel 'PEP 517 hook `prepare_metadata_for_build_wheel`'
            cand get-requires-for-build-editable 'PEP 660 hook `get_requires_for_build_editable`'
            cand prepare-metadata-for-build-editable 'PEP 660 hook `prepare_metadata_for_build_editable`'
        }
        &'uv;build-backend;build-sdist'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend;build-wheel'= {
            cand --metadata-directory 'metadata-directory'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend;build-editable'= {
            cand --metadata-directory 'metadata-directory'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend;get-requires-for-build-sdist'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend;get-requires-for-build-wheel'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend;prepare-metadata-for-build-wheel'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend;get-requires-for-build-editable'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;build-backend;prepare-metadata-for-build-editable'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;cache'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
            cand clean 'Clear the cache, removing all entries or those linked to specific packages'
            cand prune 'Prune all unreachable objects from the cache'
            cand dir 'Show the cache directory'
        }
        &'uv;cache;clean'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;cache;prune'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --ci 'Optimize the cache for persistence in a continuous integration environment, like GitHub Actions'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;cache;dir'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;self'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
            cand update 'Update uv'
        }
        &'uv;self;update'= {
            cand --token 'A GitHub token for authentication. A token is not required but can be used to reduce the chance of encountering rate limits'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;clean'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;version'= {
            cand --output-format 'output-format'
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
        &'uv;generate-shell-completion'= {
            cand --cache-dir 'cache-dir'
            cand --python-preference 'python-preference'
            cand --color 'color'
            cand --config-file 'config-file'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand -n 'n'
            cand --no-cache 'no-cache'
            cand --no-python-downloads 'no-python-downloads'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -v 'v'
            cand --verbose 'verbose'
            cand --native-tls 'native-tls'
            cand --offline 'offline'
            cand --no-progress 'no-progress'
            cand --no-config 'no-config'
            cand -h 'h'
            cand --help 'help'
            cand -V 'V'
            cand --version 'version'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-color 'Disable colors'
            cand --no-native-tls 'no-native-tls'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
        }
        &'uv;help'= {
            cand --cache-dir 'Path to the cache directory'
            cand --python-preference 'Whether to prefer uv-managed or system Python installations'
            cand --python-fetch 'Deprecated version of [`Self::python_downloads`]'
            cand --color 'Control the use of color in output'
            cand --allow-insecure-host 'Allow insecure connections to a host'
            cand --directory 'Change to the given directory prior to running the command'
            cand --project 'Run the command within the given project directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-pager 'Disable pager when printing help'
            cand -n 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --no-cache 'Avoid reading from or writing to the cache, instead using a temporary directory for the duration of the operation'
            cand --allow-python-downloads 'Allow automatically downloading Python when required. [env: "UV_PYTHON_DOWNLOADS=auto"]'
            cand --no-python-downloads 'Disable automatic downloads of Python. [env: "UV_PYTHON_DOWNLOADS=never"]'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file'
            cand --show-settings 'Show the resolved settings for the current command'
            cand --no-progress 'Hide all progress outputs'
            cand --no-installer-metadata 'Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories'
            cand --no-config 'Avoid discovering configuration files (`pyproject.toml`, `uv.toml`)'
            cand -h 'Display the concise help for this command'
            cand --help 'Display the concise help for this command'
            cand -V 'Display the uv version'
            cand --version 'Display the uv version'
        }
    ]
    $completions[$command]
}
