/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.data.Track;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.save.BaseImageConfigDialog;
import tim.prune.save.BaseImageConsumer;
import tim.prune.save.MapGrouter;
import tim.prune.threedee.ImageDefinition;

public class BaseImageDefinitionPanel
extends JPanel
implements BaseImageConsumer {
    private final BaseImageConsumer _parent;
    private final JLabel _baseImageLabel;
    private final JButton _editButton;
    private final BaseImageConfigDialog _baseImageConfig;

    public BaseImageDefinitionPanel(BaseImageConsumer baseImageConsumer, JDialog jDialog, Track track) {
        this._parent = baseImageConsumer;
        this._baseImageConfig = new BaseImageConfigDialog(this, jDialog, track);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 4));
        jPanel.add((Component)new JLabel(String.valueOf(I18nManager.getText("dialog.exportpov.baseimage")) + ": "), "West");
        this._baseImageLabel = new JLabel("Typical sourcename");
        jPanel.add((Component)this._baseImageLabel, "Center");
        this._editButton = new JButton(I18nManager.getText("button.edit"));
        this._editButton.addActionListener(actionEvent -> this.changeBaseImage());
        jPanel.add((Component)this._editButton, "East");
        this.add((Component)jPanel, "North");
    }

    public void initImageParameters(ImageDefinition imageDefinition) {
        this._baseImageConfig.setImageDefinition(imageDefinition);
    }

    private void changeBaseImage() {
        if (BaseImageConfigDialog.isImagePossible()) {
            this._baseImageConfig.begin();
        }
    }

    @Override
    public void baseImageChanged() {
        this.updateBaseImageDetails();
        if (this._parent != null) {
            this._parent.baseImageChanged();
        }
    }

    public void updateBaseImageDetails() {
        MapSource mapSource;
        String string = null;
        ImageDefinition imageDefinition = this._baseImageConfig.getImageDefinition();
        if (imageDefinition.getUseImage() && !this._baseImageConfig.isSelectedZoomValid()) {
            imageDefinition.setUseImage(false, imageDefinition.getSourceIndex(), 5);
        }
        if (imageDefinition.getUseImage() && (mapSource = MapSourceLibrary.getSource(imageDefinition.getSourceIndex())) != null) {
            string = String.valueOf(mapSource.getName()) + " (" + imageDefinition.getZoom() + ")";
        }
        if (string == null) {
            string = I18nManager.getText("dialog.about.no");
        }
        this._baseImageLabel.setText(string);
        this._editButton.setEnabled(BaseImageConfigDialog.isImagePossible());
    }

    public MapGrouter getGrouter() {
        return this._baseImageConfig.getGrouter();
    }

    public ImageDefinition getImageDefinition() {
        return this._baseImageConfig.getImageDefinition();
    }

    public boolean getFoundData() {
        return this._baseImageConfig.getFoundData();
    }
}

