/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetListEntry;
import org.openstreetmap.josm.gui.widgets.OrientationAction;
import org.openstreetmap.josm.tools.GBC;

public class MultiSelect
extends ComboMultiSelect {
    public short rows;
    protected final DefaultListModel<PresetListEntry> model = new DefaultListModel();
    protected final JList<PresetListEntry> list = new JList<PresetListEntry>(this.model);

    private void addEntry(PresetListEntry entry) {
        if (!this.seenValues.containsKey(entry.value)) {
            this.model.addElement(entry);
            this.seenValues.put(entry.value, entry);
        }
    }

    @Override
    protected boolean addToPanel(JPanel p, TaggingPresetItemGuiSupport support) {
        this.initializeLocaleText(null);
        this.usage = MultiSelect.determineTextUsage(support.getSelected(), this.key);
        this.seenValues.clear();
        this.initListEntries();
        this.model.clear();
        this.list.setEnabled(this.usage.hasUniqueValue() || this.usage.unused());
        String initialValue = this.getInitialValue(this.usage, support);
        this.presetListEntries.forEach(this::addEntry);
        this.usage = this.usage.splitValues(String.valueOf(this.delimiter));
        for (String value : this.usage.map.keySet()) {
            this.addEntry(new PresetListEntry(value, this));
        }
        if (!initialValue.isEmpty() && !DIFFERENT.equals(initialValue)) {
            for (String value : initialValue.split(String.valueOf(this.delimiter), -1)) {
                PresetListEntry e = new PresetListEntry(value, this);
                this.addEntry(e);
                int i = this.model.indexOf(e);
                this.list.addSelectionInterval(i, i);
            }
        }
        ComboMultiSelect.ComboMultiSelectListCellRenderer renderer = new ComboMultiSelect.ComboMultiSelectListCellRenderer(this.list, this.list.getCellRenderer(), 200, this.key);
        this.list.setCellRenderer(renderer);
        JLabel label = this.addLabel(p);
        label.setLabelFor(this.list);
        JScrollPane sp = new JScrollPane(this.list);
        if (this.rows > 0) {
            this.list.setVisibleRowCount(this.rows);
            Rectangle r = this.list.getCellBounds(0, Math.min(this.rows, this.model.size() - 1));
            if (r != null) {
                Insets insets = this.list.getInsets();
                r.width += insets.left + insets.right;
                r.height += insets.top + insets.bottom;
                insets = sp.getInsets();
                r.width += insets.left + insets.right;
                r.height += insets.top + insets.bottom;
                sp.setPreferredSize(new Dimension(r.width, r.height));
            }
        }
        p.add((Component)sp, GBC.eol().fill(2));
        this.list.addListSelectionListener(l -> {
            if (!l.getValueIsAdjusting()) {
                support.fireItemValueModified(this, this.key, this.getSelectedItem().value);
            }
        });
        this.list.setToolTipText(this.getKeyTooltipText());
        this.list.applyComponentOrientation(OrientationAction.getValueOrientation(this.key));
        return true;
    }

    @Override
    protected PresetListEntry getSelectedItem() {
        return new PresetListEntry(this.list.getSelectedValuesList().stream().map(e -> e.value).distinct().sorted().collect(Collectors.joining(String.valueOf(this.delimiter))), this);
    }
}

