/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.navigation;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.tv.service.Service;
import javax.tv.service.navigation.ServiceIterator;

public class ServiceIteratorImpl
implements ServiceIterator {
    private LinkedList services;
    private int index = 0;

    public ServiceIteratorImpl(LinkedList services) {
        this.services = services;
    }

    @Override
    public void toBeginning() {
        this.index = 0;
    }

    @Override
    public void toEnd() {
        this.index = this.services.size();
    }

    @Override
    public Service nextService() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("End of list reached");
        }
        return (Service)this.services.get(this.index++);
    }

    @Override
    public Service previousService() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Start of list reached");
        }
        return (Service)this.services.get(--this.index);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.services.size();
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }
}

