/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.abo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.daten.ListeAbo;
import mediathek.daten.abo.AboTags;
import mediathek.daten.abo.DatenAbo;
import mediathek.gui.abo.AboInformationController;
import mediathek.gui.abo.FXAboToolBar;
import mediathek.gui.actions.CreateNewAboAction;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.cellrenderer.CellRendererAbo;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelAbo;
import mediathek.tool.table.MVAbosTable;
import mediathek.tool.table.MVTable;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManageAboPanel
extends JPanel {
    private static final String ACTION_MAP_KEY_EDIT_ABO = "edit_abo";
    private static final String ACTION_MAP_KEY_DELETE_ABO = "delete_abo";
    private static final Logger logger = LogManager.getLogger();
    private final MVTable tabelle = new MVAbosTable();
    private final Daten daten;
    private final CreateNewAboAction createAboAction = new CreateNewAboAction(Daten.getInstance().getListeAbo());
    private final JFXPanel toolBarPanel = new JFXPanel();
    private final JFXPanel infoPanel = new JFXPanel();
    private FXAboToolBar toolBar;
    private JScrollPane jScrollPane1;
    private AboInformationController infoController;

    public ManageAboPanel() {
        this.daten = Daten.getInstance();
        this.initComponents();
        this.jScrollPane1.setViewportView(this.tabelle);
        this.setupToolBar();
        this.setupInfoPanel();
        MessageBus.getMessageBus().subscribe(this);
        this.initListeners();
        this.initializeTable();
    }

    public void addObjectData(TModelAbo model, String sender) {
        model.setRowCount(0);
        Object[] object = new Object[14];
        for (DatenAbo abo : this.daten.getListeAbo()) {
            if (!sender.isEmpty() && !sender.equals(abo.getSender())) continue;
            object[0] = null;
            object[1] = abo.isActive();
            object[2] = null;
            object[3] = null;
            object[4] = null;
            object[5] = null;
            object[6] = null;
            object[7] = null;
            object[8] = null;
            object[9] = null;
            object[10] = null;
            object[11] = null;
            object[12] = null;
            object[13] = abo;
            model.addRow(object);
        }
    }

    private void setupInfoPanel() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            try {
                URL url = this.getClass().getResource("/mediathek/res/programm/fxml/abo/abo_information_panel.fxml");
                FXMLLoader loader = new FXMLLoader();
                loader.setLocation(url);
                HBox infoPane = (HBox)loader.load();
                this.infoPanel.setScene(new Scene(infoPane));
                this.infoController = (AboInformationController)loader.getController();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void initializeTable() {
        this.tabelleLaden();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupToolBar() {
        CreateNewAboAction newAboAction = new CreateNewAboAction(Daten.getInstance().getListeAbo());
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.toolBar = new FXAboToolBar();
            this.toolBar.btnOn.setOnAction(e -> SwingUtilities.invokeLater(() -> this.changeAboActiveState(true)));
            this.toolBar.btnOff.setOnAction(e -> SwingUtilities.invokeLater(() -> this.changeAboActiveState(false)));
            this.toolBar.btnDelete.setOnAction(e -> SwingUtilities.invokeLater(this::aboLoeschen));
            this.toolBar.btnEdit.setOnAction(e -> SwingUtilities.invokeLater(this::editAbo));
            this.toolBar.btnNewAbo.setOnAction(e -> SwingUtilities.invokeLater(() -> newAboAction.actionPerformed(null)));
            this.toolBar.cbSender.setOnAction(e -> SwingUtilities.invokeLater(this::tabelleLaden));
            this.toolBarPanel.setScene(new Scene(this.toolBar));
        });
    }

    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.tabelleNachDatenSchreiben();
        }
    }

    @Handler
    private void handleAboListChanged(AboListChangedEvent e) {
        SwingUtilities.invokeLater(this::tabelleLaden);
    }

    private void setupKeyMap() {
        InputMap im = this.tabelle.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_EDIT_ABO);
        im.put(KeyStroke.getKeyStroke(127, 0), ACTION_MAP_KEY_DELETE_ABO);
        ActionMap am = this.tabelle.getActionMap();
        am.put(ACTION_MAP_KEY_EDIT_ABO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageAboPanel.this.editAbo();
            }
        });
        am.put(ACTION_MAP_KEY_DELETE_ABO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageAboPanel.this.aboLoeschen();
            }
        });
    }

    private JPopupMenu createContextMenu() {
        JMenuItem itemEinschalten = new JMenuItem("Abo einschalten");
        itemEinschalten.setIcon(IconFontSwing.buildIcon(FontAwesome.CHECK, 16.0f));
        itemEinschalten.addActionListener(e -> this.changeAboActiveState(true));
        JMenuItem itemDeaktivieren = new JMenuItem("Abo ausschalten");
        itemDeaktivieren.setIcon(IconFontSwing.buildIcon(FontAwesome.TIMES, 16.0f));
        itemDeaktivieren.addActionListener(e -> this.changeAboActiveState(false));
        JMenuItem itemLoeschen = new JMenuItem("Abo l\u00f6schen");
        itemLoeschen.setIcon(IconFontSwing.buildIcon(FontAwesome.MINUS, 16.0f));
        itemLoeschen.addActionListener(e -> this.aboLoeschen());
        JMenuItem itemAendern = new JMenuItem("Abo \u00e4ndern");
        itemAendern.setIcon(IconFontSwing.buildIcon(FontAwesome.PENCIL_SQUARE_O, 16.0f));
        itemAendern.addActionListener(e -> this.editAbo());
        JMenuItem itemNeu = new JMenuItem();
        itemNeu.setAction(this.createAboAction);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(itemEinschalten);
        jPopupMenu.add(itemDeaktivieren);
        jPopupMenu.addSeparator();
        jPopupMenu.add(itemNeu);
        jPopupMenu.add(itemLoeschen);
        jPopupMenu.add(itemAendern);
        return jPopupMenu;
    }

    private void initListeners() {
        this.tabelle.setComponentPopupMenu(this.createContextMenu());
        this.tabelle.setDefaultRenderer(Object.class, new CellRendererAbo());
        this.tabelle.setModel(new TModelAbo(new Object[0][]));
        this.tabelle.setLineBreak(false);
        this.tabelle.getTableHeader().addMouseListener(new BeobTableHeader(this.tabelle, DatenAbo.spaltenAnzeigen, new int[]{1, 13}, new int[0], true, null));
        this.setupKeyMap();
    }

    private void tabelleLaden() {
        this.tabelle.getSpalten();
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            String selectedItem = (String)this.toolBar.cbSender.getValue();
            if (selectedItem != null) {
                SwingUtilities.invokeLater(() -> {
                    this.addObjectData((TModelAbo)this.tabelle.getModel(), selectedItem);
                    this.tabelle.setSpalten();
                });
            }
        });
    }

    private void aboLoeschen() {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            String text;
            if (rows.length == 1) {
                int delRow = this.tabelle.convertRowIndexToModel(rows[0]);
                DatenAbo abo = (DatenAbo)this.tabelle.getModel().getValueAt(delRow, 13);
                text = "\"" + abo.getName() + "\" l\u00f6schen?";
            } else {
                text = "M\u00f6chten Sie wirklich " + rows.length + " Abos l\u00f6schen?";
            }
            int ret = JOptionPane.showConfirmDialog(this, text, "Abo l\u00f6schen", 0);
            if (ret == 0) {
                try {
                    ListeAbo listeAbo = this.daten.getListeAbo();
                    for (int row : rows) {
                        int modelRow = this.tabelle.convertRowIndexToModel(row);
                        DatenAbo abo = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
                        listeAbo.remove(abo);
                    }
                }
                catch (Exception e) {
                    logger.error("aboLoeschen", (Throwable)e);
                }
            }
            this.tabelleLaden();
            this.selectFirstRow();
            this.daten.getListeAbo().aenderungMelden();
        } else {
            NoSelectionErrorDialog.show();
        }
    }

    private void selectFirstRow() {
        if (this.tabelle.getRowCount() > 0 && this.tabelle.getSelectedRow() == -1) {
            this.tabelle.requestFocus();
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    public void editAbo() {
        if (this.tabelle.getSelectedRowCount() == 0) {
            NoSelectionErrorDialog.show();
            return;
        }
        int[] rows = this.tabelle.getSelectedRows();
        int modelRow = this.tabelle.convertRowIndexToModel(this.tabelle.getSelectedRow());
        DatenAbo editedAbo = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
        DialogEditAbo dialog = new DialogEditAbo(MediathekGui.ui(), editedAbo, this.tabelle.getSelectedRowCount() > 1);
        dialog.setTitle("Abo \u00e4ndern");
        dialog.setVisible(true);
        if (!dialog.successful()) {
            return;
        }
        if (this.tabelle.getSelectedRowCount() > 1) {
            for (int row : rows) {
                for (int b = 0; b < dialog.multiEditCbIndices.length; ++b) {
                    if (!dialog.multiEditCbIndices[b]) continue;
                    modelRow = this.tabelle.convertRowIndexToModel(row);
                    DatenAbo curSelAbo = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
                    AboTags.fromIndex(b).ifPresent(tag -> {
                        switch (tag) {
                            case EINGESCHALTET: {
                                curSelAbo.setActive(editedAbo.isActive());
                                break;
                            }
                            case MINDESTDAUER: {
                                curSelAbo.setMindestDauerMinuten(editedAbo.getMindestDauerMinuten());
                                break;
                            }
                            case MIN: {
                                curSelAbo.setFilmLengthState(editedAbo.getFilmLengthState());
                                break;
                            }
                            case ZIELPFAD: {
                                curSelAbo.setZielpfad(editedAbo.getZielpfad());
                                break;
                            }
                            case PSET: {
                                curSelAbo.setPsetName(editedAbo.getPsetName());
                                break;
                            }
                            default: {
                                logger.error("Unhandled tag called {}", tag);
                            }
                        }
                    });
                }
            }
        }
        this.tabelleLaden();
        this.daten.getListeAbo().aenderungMelden();
    }

    private void changeAboActiveState(boolean ein) {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                int modelRow = this.tabelle.convertRowIndexToModel(row);
                DatenAbo akt = (DatenAbo)this.tabelle.getModel().getValueAt(modelRow, 13);
                akt.setActive(ein);
            }
            this.tabelleLaden();
            this.tabelle.clearSelection();
            this.tabelle.requestFocus();
            for (int row : rows) {
                this.tabelle.addRowSelectionInterval(row, row);
            }
            this.daten.getListeAbo().aenderungMelden();
        } else {
            NoSelectionErrorDialog.show();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        JTable jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        jTable1.setAutoCreateRowSorter(true);
        jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(jTable1);
        this.add((Component)this.toolBarPanel, "North");
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.infoPanel, "South");
    }
}

