# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestRunFinished message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class TestRunFinished < Message
      ##
      # An informative message about the test run. Typically additional information about failure, but not necessarily.
      ##
      attr_reader :message

      ##
      # A test run is successful if all steps are either passed or skipped, all before/after hooks passed and no other exceptions where thrown.
      ##
      attr_reader :success

      ##
      # Timestamp when the TestRun is finished
      ##
      attr_reader :timestamp

      ##
      # Any exception thrown during the test run, if any. Does not include exceptions thrown while executing steps.
      ##
      attr_reader :exception

      def initialize(
        message: nil,
        success: false,
        timestamp: Timestamp.new,
        exception: nil
      )
        @message = message
        @success = success
        @timestamp = timestamp
        @exception = exception
        super()
      end

      ##
      # Returns a new TestRunFinished from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestRunFinished.from_h(some_hash) # => #<Cucumber::Messages::TestRunFinished:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          message: hash[:message],
          success: hash[:success],
          timestamp: Timestamp.from_h(hash[:timestamp]),
          exception: Exception.from_h(hash[:exception])
        )
      end
    end
  end
end
