import * as exposes from "./exposes";
import * as modernExtend from "./modernExtend";
import type { Fz, KeyValue, KeyValueAny, ModernExtend, Tz } from "./types";
export declare const knownEffects: {
    "0180": string;
    "0280": string;
    "0380": string;
    "0980": string;
    "0a80": string;
    "0b80": string;
    "0c80": string;
};
declare const philipsModernExtend: {
    light: (args?: modernExtend.LightArgs & {
        hueEffect?: boolean;
        gradient?: true | {
            extraEffects: string[];
        };
    }) => ModernExtend;
    onOff: (args?: modernExtend.OnOffArgs) => ModernExtend;
    twilightOnOff: () => ModernExtend;
};
export { philipsModernExtend as m };
declare const philipsTz: {
    gradient_scene: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    gradient: (opts?: {
        reverse: boolean;
    }) => {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    effect: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<Tz.ConvertSetResult>;
    };
    hue_power_on_behavior: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                hue_power_on_behavior: unknown;
            };
        }>;
    };
    hue_power_on_error: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    hue_motion_sensitivity: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                motion_sensitivity: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    hue_motion_led_indication: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                led_indication: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
};
export { philipsTz as tz };
export declare const gradientScenes: {
    blossom: string;
    crocus: string;
    precious: string;
    narcissa: string;
    beginnings: string;
    first_light: string;
    horizon: string;
    valley_dawn: string;
    sunflare: string;
    emerald_flutter: string;
    memento: string;
    resplendent: string;
    scarlet_dream: string;
    lovebirds: string;
    smitten: string;
    glitz_and_glam: string;
    promise: string;
    ruby_romance: string;
    city_of_love: string;
    honolulu: string;
    savanna_sunset: string;
    golden_pond: string;
    runy_glow: string;
    tropical_twilight: string;
    miami: string;
    cancun: string;
    rio: string;
    chinatown: string;
    ibiza: string;
    osaka: string;
    tokyo: string;
    motown: string;
    fairfax: string;
    galaxy: string;
    starlight: string;
    "blood moon": string;
    artic_aurora: string;
    moonlight: string;
    nebula: string;
    sundown: string;
    blue_lagoon: string;
    palm_beach: string;
    lake_placid: string;
    mountain_breeze: string;
    lake_mist: string;
    ocean_dawn: string;
    frosty_dawn: string;
    sunday_morning: string;
    emerald_isle: string;
    spring_blossom: string;
    midsummer_sun: string;
    autumn_gold: string;
    spring_lake: string;
    winter_mountain: string;
    midwinter: string;
    amber_bloom: string;
    lily: string;
    painted_sky: string;
    winter_beauty: string;
    orange_fields: string;
    forest_adventure: string;
    blue_planet: string;
    soho: string;
    vapor_wave: string;
    magneto: string;
    tyrell: string;
    disturbia: string;
    hal: string;
    golden_star: string;
    under_the_tree: string;
    silent_night: string;
    rosy_sparkle: string;
    festive_fun: string;
    colour_burst: string;
    crystalline: string;
};
export declare const hueEffects: {
    candle: string;
    fireplace: string;
    colorloop: string;
    sunrise: string;
    sparkle: string;
    opal: string;
    glisten: string;
    stop_hue_effect: string;
};
declare const philipsFz: {
    philips_contact: {
        cluster: string;
        type: string[];
        convert: (model: import("./types").Definition, msg: Fz.Message, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            contact: boolean;
        };
    };
    hue_tap_dial: {
        cluster: string;
        type: string;
        options: exposes.Composite[];
        convert: (model: import("./types").Definition, msg: Fz.Message, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValue;
    };
    gradient: {
        cluster: string;
        type: string[];
        convert: (model: import("./types").Definition, msg: Fz.Message, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            gradient: string[];
        } | {
            gradient?: undefined;
        };
    };
};
export { philipsFz as fz };
export declare function decodeGradientColors(input: string, opts: KeyValue): {
    color_mode: string;
    colors: string[];
    segments: number;
    offset: number;
    brightness: number;
    on: boolean;
    x?: undefined;
    y?: undefined;
    name?: undefined;
    color_temp?: undefined;
} | {
    color_mode: string;
    x: number;
    y: number;
    brightness: number;
    on: boolean;
    colors?: undefined;
    segments?: undefined;
    offset?: undefined;
    name?: undefined;
    color_temp?: undefined;
} | {
    color_mode: string;
    x: number;
    y: number;
    brightness: number;
    on: boolean;
    name: any;
    colors?: undefined;
    segments?: undefined;
    offset?: undefined;
    color_temp?: undefined;
} | {
    color_mode: string;
    color_temp: number;
    brightness: number;
    on: boolean;
    colors?: undefined;
    segments?: undefined;
    offset?: undefined;
    x?: undefined;
    y?: undefined;
    name?: undefined;
} | {
    brightness: number;
    on: boolean;
    color_mode?: undefined;
    colors?: undefined;
    segments?: undefined;
    offset?: undefined;
    x?: undefined;
    y?: undefined;
    name?: undefined;
    color_temp?: undefined;
} | {
    color_mode?: undefined;
    colors?: undefined;
    segments?: undefined;
    offset?: undefined;
    brightness?: undefined;
    on?: undefined;
    x?: undefined;
    y?: undefined;
    name?: undefined;
    color_temp?: undefined;
};
export declare function encodeGradientColors(value: string[], opts: KeyValueAny): string;
//# sourceMappingURL=philips.d.ts.map