"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Parser_instances, _Parser_resetState, _Parser_nextToken, _Parser_token, _Parser_getLinesFromFile, _Parser_parseGraph, _Parser_parseIdentifier, _Parser_registerIdentifier, _Parser_parseTextIdentifier, _Parser_parseQuotedTextIdentifierConcatenation, _Parser_parseQuotedTextIdentifier, _Parser_isQuotedStringFollowing, _Parser_parseHtmlIdentifier, _Parser_parseNumericIdentifier, _Parser_parseStatement, _Parser_parseAttributeStatement, _Parser_parseAttributeContainer, _Parser_isAssignmentStart, _Parser_parseIdEqualsIdStatement, _Parser_isIdEqualsIdStatement, _Parser_parseNodeStatement, _Parser_parseEdgeStatement, _Parser_parseEdgeRhs, _Parser_createMissingNode, _Parser_parseAssignment, _Parser_parseSubGraph, _Parser_parseNodeId, _Parser_parseCompassPortDeclaration, _Parser_parseNormalPortDeclaration, _Parser_parsePortDeclaration, _Parser_isCompassPort, _Parser_parseList, _Parser_getContextParseError, _Parser_isInSomeParsingContext, _Parser_abortListParsing, _Parser_isListElement, _Parser_isListTerminator, _Parser_createEmptyArray, _Parser_finishNode, _Parser_createNode, _Parser_createNodeArray, _Parser_parseTokenNode, _Parser_getLastError, _Parser_parseErrorAtPosition, _Parser_parseErrorAtCurrentToken, _Parser_scanError, _Parser_reportExpectedError, _Parser_parseExpectedOneOf, _Parser_parseExpectedTokenOneOf, _Parser_parseExpectedToken, _Parser_parseExpected, _Parser_parseOptionalToken, _Parser_parseOptional, _Parser_isEdgeOp, _Parser_isIdentifier, _Parser_isCompassPortKind, _Parser_speculationHelper, _Parser_lookAhead, _Parser_tryParse;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Parser = exports.ParsingContext = void 0;
exports.isIdentifier = isIdentifier;
exports.isIdentifierNode = isIdentifierNode;
const scanner_js_1 = require("./scanner.js");
const util_js_1 = require("./service/util.js");
const types_1 = require("./types");
var ParsingContext;
(function (ParsingContext) {
    ParsingContext[ParsingContext["None"] = 0] = "None";
    ParsingContext[ParsingContext["StatementList"] = 1] = "StatementList";
    ParsingContext[ParsingContext["AttributeContainerList"] = 2] = "AttributeContainerList";
    ParsingContext[ParsingContext["AssignmentList"] = 3] = "AssignmentList";
    ParsingContext[ParsingContext["EdgeRhsList"] = 4] = "EdgeRhsList";
    ParsingContext[ParsingContext["QuotedTextIdentifierConcatenation"] = 5] = "QuotedTextIdentifierConcatenation";
    ParsingContext[ParsingContext["Count"] = 6] = "Count";
})(ParsingContext || (exports.ParsingContext = ParsingContext = {}));
class Parser {
    constructor() {
        _Parser_instances.add(this);
        this.currentToken = types_1.SyntaxKind.Unknown;
        this.identifierCount = 0;
        this.scanner = new scanner_js_1.DefaultScanner();
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_resetState).call(this);
    }
    parse(sourceText) {
        this.sourceText = sourceText;
        this.scanner.setText(this.sourceText);
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
        let graph = undefined;
        if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) !== types_1.SyntaxKind.EndOfFileToken) {
            graph = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseGraph).call(this);
            if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) !== types_1.SyntaxKind.EndOfFileToken) {
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseErrorAtPosition).call(this, this.scanner.tokenPos, this.scanner.text.length - 1, "Content after the end of a graph declaration is invalid.", { source: 2, sub: 1 });
            }
        }
        const result = {
            content: this.sourceText,
            graph,
            identifiers: this.identifiers,
            diagnostics: this.diagnostics,
        };
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_resetState).call(this);
        return result;
    }
}
exports.Parser = Parser;
_Parser_instances = new WeakSet(), _Parser_resetState = function _Parser_resetState() {
    this.sourceText = "";
    this.scanner.setText(this.sourceText);
    this.scanner.setErrorCallback(__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_scanError).bind(this));
    this.identifierCount = 0;
    this.identifiers = new Set();
    this.nodeCount = 0;
    this.diagnostics = [];
    this.currentNodeHasError = false;
    this.currentContext = ParsingContext.None;
}, _Parser_nextToken = function _Parser_nextToken() {
    this.currentToken = this.scanner.scan(true);
    return this.currentToken;
}, _Parser_token = function _Parser_token() {
    return this.currentToken;
}, _Parser_getLinesFromFile = function _Parser_getLinesFromFile(sourceText) {
    return sourceText.split(/\r?\n/);
}, _Parser_parseGraph = function _Parser_parseGraph() {
    const strictToken = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.StrictKeyword);
    const keyword = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedTokenOneOf).call(this, types_1.SyntaxKind.DigraphKeyword, [
        types_1.SyntaxKind.DigraphKeyword,
        types_1.SyntaxKind.GraphKeyword,
    ]);
    const kind = keyword === undefined || keyword.kind === types_1.SyntaxKind.DigraphKeyword
        ? types_1.SyntaxKind.DirectedGraph
        : types_1.SyntaxKind.UndirectedGraph;
    const graphStart = strictToken ? strictToken.pos : keyword.pos;
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, kind, graphStart);
    node.strict = strictToken;
    node.keyword = keyword;
    node.id = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier).call(this) ? __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this) : undefined;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.OpenBraceToken);
    node.statements = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.StatementList, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseStatement).call(this));
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.CloseBraceToken);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseIdentifier = function _Parser_parseIdentifier() {
    let result;
    const escapedIdTexts = new Array();
    switch (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this)) {
        case types_1.SyntaxKind.TextIdentifier:
            result = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseTextIdentifier).call(this);
            escapedIdTexts.push(result.text);
            break;
        case types_1.SyntaxKind.StringLiteral:
            result = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseQuotedTextIdentifierConcatenation).call(this);
            escapedIdTexts.push(...result.values.map(v => v.text));
            break;
        case types_1.SyntaxKind.HtmlIdentifier:
            result = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseHtmlIdentifier).call(this);
            escapedIdTexts.push(result.htmlContent);
            break;
        case types_1.SyntaxKind.NumericIdentifier:
            result = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseNumericIdentifier).call(this);
            escapedIdTexts.push(result.text);
            break;
        default:
            __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_reportExpectedError).call(this, [types_1.SyntaxKind.TextIdentifier]);
            result = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createMissingNode).call(this, types_1.SyntaxKind.TextIdentifier);
            break;
    }
    for (const i of escapedIdTexts) {
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_registerIdentifier).call(this, i);
    }
    return result;
}, _Parser_registerIdentifier = function _Parser_registerIdentifier(id) {
    this.identifierCount++;
    const has = this.identifiers.has(id);
    if (!has)
        this.identifiers.add(id);
}, _Parser_parseTextIdentifier = function _Parser_parseTextIdentifier() {
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.TextIdentifier);
    const text = this.scanner.tokenValue;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    if (text === undefined)
        throw "Satisfy type checker";
    node.text = text;
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseQuotedTextIdentifierConcatenation = function _Parser_parseQuotedTextIdentifierConcatenation() {
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.QuotedTextIdentifier);
    node.values = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.QuotedTextIdentifierConcatenation, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseQuotedTextIdentifier).call(this), true);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseQuotedTextIdentifier = function _Parser_parseQuotedTextIdentifier() {
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.StringLiteral);
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.PlusToken)
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    const text = this.scanner.tokenValue;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    if (text === undefined)
        throw "Satisfy type checker";
    node.text = text;
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_isQuotedStringFollowing = function _Parser_isQuotedStringFollowing() {
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.StringLiteral;
}, _Parser_parseHtmlIdentifier = function _Parser_parseHtmlIdentifier() {
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.HtmlIdentifier);
    const text = this.scanner.tokenValue;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    if (text === undefined)
        throw "Satisfy type checker";
    node.htmlContent = text;
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseNumericIdentifier = function _Parser_parseNumericIdentifier() {
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.NumericIdentifier);
    const text = this.scanner.tokenValue;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    if (text === undefined)
        throw "Satisfy type checker";
    node.text = text;
    node.value = Number(text);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseStatement = function _Parser_parseStatement() {
    switch (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this)) {
        case types_1.SyntaxKind.GraphKeyword:
        case types_1.SyntaxKind.NodeKeyword:
        case types_1.SyntaxKind.EdgeKeyword:
            return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseAttributeStatement).call(this);
        case types_1.SyntaxKind.OpenBraceToken:
        case types_1.SyntaxKind.SubgraphKeyword: {
            const subgraph = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseSubGraph).call(this);
            if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.SemicolonToken) {
                const subgraphStatement = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.SubGraphStatement, subgraph.pos);
                subgraphStatement.subgraph = subgraph;
                subgraphStatement.terminator = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.SemicolonToken);
                return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, subgraphStatement);
            }
            if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isEdgeOp).call(this))
                return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseEdgeStatement).call(this, subgraph);
            const subgraphStatement = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.SubGraphStatement, subgraph.pos);
            subgraphStatement.subgraph = subgraph;
            return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, subgraphStatement);
        }
        default: {
            if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier))
                debugger;
            if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_lookAhead).call(this, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdEqualsIdStatement).call(this))) {
                return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdEqualsIdStatement).call(this);
            }
            const ns = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseNodeStatement).call(this);
            if (ns.terminator !== undefined || ns.attributes.length !== 0)
                return ns;
            if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isEdgeOp).call(this))
                return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseEdgeStatement).call(this, ns.id);
            return ns;
        }
    }
}, _Parser_parseAttributeStatement = function _Parser_parseAttributeStatement() {
    switch (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this)) {
        case types_1.SyntaxKind.GraphKeyword:
        case types_1.SyntaxKind.NodeKeyword:
        case types_1.SyntaxKind.EdgeKeyword: {
            const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.AttributeStatement);
            node.subject = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseTokenNode).call(this);
            if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.OpenBracketToken) {
                node.attributes = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.AttributeContainerList, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseAttributeContainer).call(this));
            }
            else {
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_reportExpectedError).call(this, [types_1.SyntaxKind.OpenBracketToken]);
                const missingStatement = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createMissingNode).call(this, types_1.SyntaxKind.AttributeStatement);
                missingStatement.attributes = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNodeArray).call(this, [__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createMissingNode).call(this, types_1.SyntaxKind.AttributeContainer)], this.scanner.tokenPos, this.scanner.tokenPos);
            }
            node.terminator = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.SemicolonToken);
            return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
        }
        default:
            throw "This should never happen";
    }
}, _Parser_parseAttributeContainer = function _Parser_parseAttributeContainer() {
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) !== types_1.SyntaxKind.OpenBracketToken)
        debugger;
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.AttributeContainer);
    node.openBracket = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.OpenBracketToken);
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier).call(this) && __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_lookAhead).call(this, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isAssignmentStart).call(this))) {
        node.assignments = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.AssignmentList, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseAssignment).call(this));
    }
    else {
        node.assignments = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createEmptyArray).call(this);
    }
    node.closeBracket = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.CloseBracketToken);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_isAssignmentStart = function _Parser_isAssignmentStart() {
    if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier))
        debugger;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.EqualsToken;
}, _Parser_parseIdEqualsIdStatement = function _Parser_parseIdEqualsIdStatement() {
    if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier))
        debugger;
    const leftIdentifier = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this);
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.IdEqualsIdStatement, leftIdentifier.pos);
    node.leftId = leftIdentifier;
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) !== types_1.SyntaxKind.EqualsToken)
        debugger;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.EqualsToken);
    node.rightId = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this);
    node.terminator = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.SemicolonToken);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_isIdEqualsIdStatement = function _Parser_isIdEqualsIdStatement() {
    if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier))
        debugger;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.EqualsToken;
}, _Parser_parseNodeStatement = function _Parser_parseNodeStatement() {
    if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier))
        debugger;
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.NodeStatement);
    node.id = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseNodeId).call(this);
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.OpenBracketToken) {
        node.attributes = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.AttributeContainerList, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseAttributeContainer).call(this));
    }
    else {
        node.attributes = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createEmptyArray).call(this);
    }
    node.terminator = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.SemicolonToken);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseEdgeStatement = function _Parser_parseEdgeStatement(precedingItem) {
    console.assert(precedingItem.kind === types_1.SyntaxKind.SubGraph || precedingItem.kind === types_1.SyntaxKind.NodeId);
    console.assert(precedingItem.pos !== undefined);
    if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isEdgeOp).call(this))
        debugger;
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.EdgeStatement, precedingItem.pos);
    node.source = precedingItem;
    node.rhs = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.EdgeRhsList, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseEdgeRhs).call(this));
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.OpenBracketToken) {
        node.attributes = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.AttributeContainerList, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseAttributeContainer).call(this));
    }
    else {
        node.attributes = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createEmptyArray).call(this);
    }
    node.terminator = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.SemicolonToken);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseEdgeRhs = function _Parser_parseEdgeRhs() {
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.EdgeRhs);
    const op = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedTokenOneOf).call(this, types_1.SyntaxKind.DirectedEdgeOp, [
        types_1.SyntaxKind.DirectedEdgeOp,
        types_1.SyntaxKind.UndirectedEdgeOp,
    ]);
    node.operation = op;
    switch (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this)) {
        case types_1.SyntaxKind.SubgraphKeyword:
        case types_1.SyntaxKind.OpenBraceToken:
            node.target = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseSubGraph).call(this);
            break;
        default: {
            node.target = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseNodeId).call(this);
            break;
        }
    }
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_createMissingNode = function _Parser_createMissingNode(kind) {
    const result = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, kind);
    if (isIdentifierNode(result)) {
        switch (result.kind) {
            case types_1.SyntaxKind.QuotedTextIdentifier: {
                const literal = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.StringLiteral);
                literal.text = "";
                const values = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNodeArray).call(this, [literal], result.pos, result.pos);
                result.values = values;
                break;
            }
            case types_1.SyntaxKind.HtmlIdentifier:
                result.htmlContent = "";
                break;
            case types_1.SyntaxKind.TextIdentifier:
            case types_1.SyntaxKind.NumericIdentifier:
                result.text = "";
                break;
        }
    }
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, result);
}, _Parser_parseAssignment = function _Parser_parseAssignment() {
    if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier))
        debugger;
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.Assignment);
    node.leftId = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this);
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.EqualsToken);
    node.rightId = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this);
    let terminator = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.CommaToken);
    if (terminator === undefined)
        terminator = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.SemicolonToken);
    node.terminator = terminator;
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseSubGraph = function _Parser_parseSubGraph() {
    console.assert(__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.SubgraphKeyword ||
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.OpenBraceToken);
    const subGraph = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, types_1.SyntaxKind.SubgraphKeyword);
    const subGraphStart = subGraph !== undefined ? subGraph.pos : undefined;
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.SubGraph, subGraphStart);
    const identifier = subGraph !== undefined && __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier).call(this) ? __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this) : undefined;
    node.id = identifier;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.OpenBraceToken);
    node.statements = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseList).call(this, ParsingContext.StatementList, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseStatement).call(this));
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseExpectedToken).call(this, types_1.SyntaxKind.CloseBraceToken);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseNodeId = function _Parser_parseNodeId() {
    if (!__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier))
        debugger;
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.NodeId);
    node.id = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this);
    node.port =
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.ColonToken ? __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parsePortDeclaration).call(this) : undefined;
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseCompassPortDeclaration = function _Parser_parseCompassPortDeclaration() {
    console.assert(__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.ColonToken);
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.CompassPortDeclaration);
    node.colon = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseTokenNode).call(this);
    node.compassPt = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseTokenNode).call(this);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parseNormalPortDeclaration = function _Parser_parseNormalPortDeclaration() {
    console.assert(__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.ColonToken);
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, types_1.SyntaxKind.NormalPortDeclaration);
    node.colon = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseTokenNode).call(this);
    node.id = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseIdentifier).call(this);
    node.compassPt =
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.ColonToken
            ? __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseCompassPortDeclaration).call(this)
            : undefined;
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_parsePortDeclaration = function _Parser_parsePortDeclaration() {
    console.assert(__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.ColonToken);
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_lookAhead).call(this, () => __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isCompassPort).call(this)))
        return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseCompassPortDeclaration).call(this);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseNormalPortDeclaration).call(this);
}, _Parser_isCompassPort = function _Parser_isCompassPort() {
    console.assert(__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.ColonToken);
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) !== types_1.SyntaxKind.ColonToken)
        return false;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isCompassPortKind).call(this, __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this));
}, _Parser_parseList = function _Parser_parseList(context, parseElement, atLeastOne = false) {
    const saveParsingContext = this.currentContext;
    this.currentContext |= 1 << context;
    let isListTerminated = atLeastOne ? false : __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isListTerminator).call(this, context);
    const startPos = this.scanner.startPos;
    const elements = new Array();
    while (!isListTerminated) {
        if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isListElement).call(this, context, false)) {
            const element = parseElement();
            elements.push(element);
            isListTerminated = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isListTerminator).call(this, context);
            continue;
        }
        if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_abortListParsing).call(this, context))
            break;
    }
    this.currentContext = saveParsingContext;
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNodeArray).call(this, elements, startPos);
}, _Parser_getContextParseError = function _Parser_getContextParseError(context) {
    switch (context) {
        case ParsingContext.StatementList:
            return "Assignment, node definition, graph/node/edge attribute or edge definition expected.";
        case ParsingContext.AssignmentList:
            return "Assignment expected.";
        case ParsingContext.EdgeRhsList:
            return "Edge operation expected.";
        case ParsingContext.QuotedTextIdentifierConcatenation:
            return "Quoted identifier expected";
        case ParsingContext.AttributeContainerList:
            return "Attribute marker expected.";
        case ParsingContext.None:
            return "Wat, no parsing context";
        case ParsingContext.Count:
            return "Wat, 'Count' parsing context";
        default:
            return (0, util_js_1.assertNever)(context);
    }
}, _Parser_isInSomeParsingContext = function _Parser_isInSomeParsingContext() {
    for (let ctx = 0; ctx < ParsingContext.Count; ctx++) {
        if (this.currentContext & (1 << ctx)) {
            if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isListElement).call(this, ctx, true) ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isListTerminator).call(this, ctx)) {
                return true;
            }
        }
    }
    return false;
}, _Parser_abortListParsing = function _Parser_abortListParsing(context) {
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseErrorAtCurrentToken).call(this, __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_getContextParseError).call(this, context), 2);
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isInSomeParsingContext).call(this)) {
        return true;
    }
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    return false;
}, _Parser_isListElement = function _Parser_isListElement(context, _inErrorRecovery) {
    switch (context) {
        case ParsingContext.AssignmentList:
            return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier).call(this);
        case ParsingContext.AttributeContainerList:
            return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.OpenBracketToken;
        case ParsingContext.EdgeRhsList:
            return (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.DirectedEdgeOp ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.UndirectedEdgeOp);
        case ParsingContext.QuotedTextIdentifierConcatenation:
            return (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.StringLiteral ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.PlusToken);
        case ParsingContext.StatementList:
            return (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier).call(this) ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.SubgraphKeyword ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.OpenBraceToken ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.GraphKeyword ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.EdgeKeyword ||
                __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.NodeKeyword);
        default:
            throw "This should never happen";
    }
}, _Parser_isListTerminator = function _Parser_isListTerminator(context) {
    const token = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this);
    if (token === types_1.SyntaxKind.EndOfFileToken)
        return true;
    switch (context) {
        case ParsingContext.StatementList:
            return token === types_1.SyntaxKind.CloseBraceToken;
        case ParsingContext.AttributeContainerList:
            return token !== types_1.SyntaxKind.OpenBracketToken;
        case ParsingContext.AssignmentList:
            return token === types_1.SyntaxKind.CloseBracketToken;
        case ParsingContext.EdgeRhsList:
            return token !== types_1.SyntaxKind.DirectedEdgeOp && token !== types_1.SyntaxKind.UndirectedEdgeOp;
        case ParsingContext.QuotedTextIdentifierConcatenation:
            return token !== types_1.SyntaxKind.PlusToken;
        default:
            throw "Unsupported parsing context";
    }
}, _Parser_createEmptyArray = function _Parser_createEmptyArray() {
    const startPos = this.scanner.startPos;
    const elements = new Array();
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNodeArray).call(this, elements, startPos);
}, _Parser_finishNode = function _Parser_finishNode(node, end) {
    node.end = end === undefined ? this.scanner.startPos : end;
    if (this.currentNodeHasError) {
        this.currentNodeHasError = false;
        node.flags |= 2;
    }
    return node;
}, _Parser_createNode = function _Parser_createNode(kind, pos) {
    this.nodeCount++;
    const p = pos !== undefined && pos >= 0 ? pos : this.scanner.startPos;
    if (isNodeKind(kind) || kind === types_1.SyntaxKind.Unknown)
        return newNode(kind, p, p);
    return isIdentifier(kind) ? newIdentifier(kind, p, p) : newToken(kind, p, p);
}, _Parser_createNodeArray = function _Parser_createNodeArray(elements, pos, end) {
    const length = elements.length;
    const array = ((length >= 1 && length <= 4 ? elements.slice() : elements));
    array.pos = pos;
    array.end = end === undefined ? this.scanner.startPos : end;
    return array;
}, _Parser_parseTokenNode = function _Parser_parseTokenNode() {
    const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this));
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
}, _Parser_getLastError = function _Parser_getLastError(diagnostics) {
    return diagnostics && diagnostics.length > 0
        ? diagnostics[diagnostics.length - 1]
        : undefined;
}, _Parser_parseErrorAtPosition = function _Parser_parseErrorAtPosition(start, end, message, code) {
    const ds = this.diagnostics;
    const lastError = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_getLastError).call(this, ds);
    if (!lastError || start !== lastError.start) {
        ds.push({
            category: types_1.DiagnosticCategory.Error,
            start,
            end,
            message,
            code,
        });
    }
    this.currentNodeHasError = true;
}, _Parser_parseErrorAtCurrentToken = function _Parser_parseErrorAtCurrentToken(message, sub) {
    const error = {
        source: 2,
        sub,
    };
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseErrorAtPosition).call(this, this.scanner.tokenPos, this.scanner.pos, message, error);
}, _Parser_scanError = function _Parser_scanError(message, _category, sub, length) {
    const errorPos = this.scanner.pos;
    const err = {
        source: 1,
        sub,
    };
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseErrorAtPosition).call(this, errorPos, errorPos + length, message, err);
}, _Parser_reportExpectedError = function _Parser_reportExpectedError(expectedKinds) {
    const found = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_isIdentifier).call(this)
        ? "identifier"
        : __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === types_1.SyntaxKind.EndOfFileToken
            ? "end of file"
            : `"${(0, scanner_js_1.getTokenAsText)(__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this))}"`;
    const expected = expectedKinds.map(k => {
        if (isIdentifier(k)) {
            return "identifier";
        }
        if (k === types_1.SyntaxKind.EndOfFileToken) {
            return "end of file";
        }
        return `"${(0, scanner_js_1.getTokenAsText)(k)}"`;
    });
    const lastExpected = expected.pop();
    const expectedJoined = expected.join(", ");
    const msg = expected.length > 0
        ? `Expected ${expectedJoined} or ${lastExpected} but found ${found} instead.`
        : `Expected ${lastExpected} but found ${found} instead.`;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseErrorAtCurrentToken).call(this, msg, 0);
}, _Parser_parseExpectedOneOf = function _Parser_parseExpectedOneOf(...kinds) {
    if (kinds.length < 2) {
        console.assert(false);
        debugger;
    }
    for (const kind of kinds) {
        if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === kind) {
            __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
            return true;
        }
    }
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_reportExpectedError).call(this, kinds);
    return false;
}, _Parser_parseExpectedTokenOneOf = function _Parser_parseExpectedTokenOneOf(fallback, kinds) {
    if (kinds.length < 2) {
        console.assert(false);
        debugger;
    }
    for (const kind of kinds) {
        if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === kind) {
            const node = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createNode).call(this, __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this));
            __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
            return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_finishNode).call(this, node);
        }
    }
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_reportExpectedError).call(this, kinds);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createMissingNode).call(this, fallback);
}, _Parser_parseExpectedToken = function _Parser_parseExpectedToken(kind) {
    const tokenNode = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptionalToken).call(this, kind);
    if (tokenNode !== undefined)
        return tokenNode;
    __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_reportExpectedError).call(this, [kind]);
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_createMissingNode).call(this, kind);
}, _Parser_parseExpected = function _Parser_parseExpected(kind) {
    const res = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseOptional).call(this, kind);
    if (!res)
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_reportExpectedError).call(this, [kind]);
    return res;
}, _Parser_parseOptionalToken = function _Parser_parseOptionalToken(t) {
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === t) {
        return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_parseTokenNode).call(this);
    }
    return undefined;
}, _Parser_parseOptional = function _Parser_parseOptional(t) {
    if (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this) === t) {
        __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_nextToken).call(this);
        return true;
    }
    return false;
}, _Parser_isEdgeOp = function _Parser_isEdgeOp() {
    switch (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this)) {
        case types_1.SyntaxKind.DirectedEdgeOp:
        case types_1.SyntaxKind.UndirectedEdgeOp:
            return true;
        default:
            return false;
    }
}, _Parser_isIdentifier = function _Parser_isIdentifier() {
    switch (__classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this)) {
        case types_1.SyntaxKind.TextIdentifier:
        case types_1.SyntaxKind.NumericIdentifier:
        case types_1.SyntaxKind.StringLiteral:
        case types_1.SyntaxKind.HtmlIdentifier:
            return true;
        default:
            return false;
    }
}, _Parser_isCompassPortKind = function _Parser_isCompassPortKind(kind) {
    return kind >= types_1.SyntaxKind.CompassCenterToken && kind <= types_1.SyntaxKind.CompassEnd;
}, _Parser_speculationHelper = function _Parser_speculationHelper(callback, isLookAhead) {
    const saveToken = __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_token).call(this);
    const saveDiagnosticsLength = this.diagnostics.length;
    const result = isLookAhead
        ? this.scanner.lookAhead(callback)
        : this.scanner.tryScan(callback);
    if (!result || isLookAhead) {
        this.currentToken = saveToken;
        this.diagnostics.length = saveDiagnosticsLength;
    }
    return result;
}, _Parser_lookAhead = function _Parser_lookAhead(callback) {
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_speculationHelper).call(this, callback, true);
}, _Parser_tryParse = function _Parser_tryParse(callback) {
    return __classPrivateFieldGet(this, _Parser_instances, "m", _Parser_speculationHelper).call(this, callback, false);
};
function newNode(kind, pos, end) {
    return {
        kind,
        flags: 0,
        end,
        pos,
        parent: undefined,
    };
}
const newIdentifier = newNode;
const newToken = newNode;
function isNodeKind(kind) {
    return kind >= types_1.SyntaxKind.FirstNode;
}
function isIdentifier(kind) {
    return (kind === types_1.SyntaxKind.HtmlIdentifier ||
        kind === types_1.SyntaxKind.NumericIdentifier ||
        kind === types_1.SyntaxKind.TextIdentifier ||
        kind === types_1.SyntaxKind.QuotedTextIdentifier);
}
function isIdentifierNode(node) {
    return isIdentifier(node.kind);
}
//# sourceMappingURL=parser.js.map