/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gd extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nabhru";
        final String metaValue_TO = "Tonga";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tubhalu";
        final String metaValue_ar = "Arabais";
        final String metaValue_hy = "Airmeinis";
        final String metaValue_ae = "Avestanais";
        final String metaValue_zbl = "Comharran Bliss";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptais";
        final String metaValue_gez = "Ge\u2019ez";
        final String metaValue_ka = "Cairtbheilis";
        final String metaValue_got = "Gotais";
        final String metaValue_el = "Greugais";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Eabhra";
        final String metaValue_jv = "De\u00e0bhanais";
        final String metaValue_ja = "Seapanais";
        final String metaValue_kaw = "Kawi";
        final String metaValue_km = "Cm\u00e8ar";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Coir\u00e8anais";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_lo = "L\u00e0tho";
        final String metaValue_la = "Laideann";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolais";
        final String metaValue_MM = "Mi\u00e0nmar";
        final String metaValue_osa = "Osage";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_si = "Sinhala";
        final String metaValue_syr = "Suraidheac";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_bo = "Tibeitis";
        final String metaValue_vai = "Vai";
        final String metaValue_peo = "Seann-Pheirsis";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "An Saoghal" },
            { "002", "Afraga" },
            { "003", "Aimeireaga a Tuath" },
            { "005", "Aimeireaga a Deas" },
            { "009", "Roinn a\u2019 Chuain S\u00e8imh" },
            { "011", "Afraga an Iar" },
            { "013", "Meadhan Aimeireaga" },
            { "014", "Afraga an Ear" },
            { "015", "Afraga a Tuath" },
            { "017", "Meadhan Afraga" },
            { "018", "Ceann a Deas Afraga" },
            { "019", "An D\u00e0 Aimeireaga" },
            { "021", "Ceann a Tuath Aimeireaga" },
            { "029", "Am Muir Caraibeach" },
            { "030", "\u00c0isia an Ear" },
            { "034", "\u00c0isia a Deas" },
            { "035", "\u00c0isia an Ear-dheas" },
            { "039", "An Roinn-E\u00f2rpa a Deas" },
            { "053", "Astr\u00e0ilia is Sealainn Nuadh" },
            { "054", "Na h-Eileanan Dubha" },
            { "057", "Roinn nam Meanbh-Eileanan" },
            { "061", "Poilin\u00e8is" },
            { "142", "\u00c0isia" },
            { "143", "Meadhan \u00c0isia" },
            { "145", "\u00c0isia an Iar" },
            { "150", "An Roinn-E\u00f2rpa" },
            { "151", "An Roinn-E\u00f2rpa an Ear" },
            { "154", "An Roinn-E\u00f2rpa a Tuath" },
            { "155", "An Roinn-E\u00f2rpa an Iar" },
            { "202", "Afraga Deas air an t-Sathara" },
            { "419", "Aimeireaga Laidinneach" },
            { "AC", "Eilean na Deasgabhalach" },
            { "AD", "Andorra" },
            { "AE", "Na h-Iomaratan Arabach Aonaichte" },
            { "AF", "Afghanast\u00e0n" },
            { "AG", "Aint\u00ecoga is Barbuda" },
            { "AI", "Anguillia" },
            { "AL", "Alb\u00e0inia" },
            { "AM", "Airmeinea" },
            { "AO", "Ang\u00f2la" },
            { "AQ", "An Antartaig" },
            { "AR", "An Argantain" },
            { "AS", "Samotha na h-Aimeireaga" },
            { "AT", "An Ostair" },
            { "AU", "Astr\u00e0ilia" },
            { "AW", "Ar\u00f9ba" },
            { "AX", "Na h-Eileanan \u00c5land" },
            { "AZ", "Asarbaide\u00e0n" },
            { "BA", "Bosna is Hearsagobhana" },
            { "BB", "Barbados" },
            { "BD", "Bangladais" },
            { "BE", "A\u2019 Bheilg" },
            { "BF", "Buirciona Faso" },
            { "BG", "A\u2019 Bhulgair" },
            { "BH", "Bachrain" },
            { "BI", "Burundaidh" },
            { "BJ", "Beinin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bearm\u00f9da" },
            { "BN", "Br\u00f9naigh" },
            { "BO", "Boilibhia" },
            { "BQ", "Na T\u00ecrean \u00ccsle Caraibeach" },
            { "BR", "Braisil" },
            { "BS", "Na h-Eileanan Bhathama" },
            { "BT", "But\u00e0n" },
            { "BV", "Eilean Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "A\u2019 Bhealaruis" },
            { "BZ", "A\u2019 Bheil\u00ecs" },
            { "CA", "Canada" },
            { "CC", "Na h-Eileanan Chocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Poblachd Meadhan Afraga" },
            { "CG", "A\u2019 Chongo - Brazzaville" },
            { "CH", "An Eilbheis" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Eileanan Cook" },
            { "CL", "An t-Sile" },
            { "CM", "Camarun" },
            { "CN", "An t-S\u00ecn" },
            { "CO", "Coloimbia" },
            { "CP", "Eilean Clipperton" },
            { "CQ", "Sarc" },
            { "CR", "Costa R\u00eccea" },
            { "CU", "C\u00f9ba" },
            { "CV", "An Ceap Uaine" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Eilean na Nollaig" },
            { "CY", "C\u00ecopras" },
            { "CZ", "An t-Seic" },
            { "DE", "A\u2019 Ghearmailt" },
            { "DG", "Diego Garcia" },
            { "DJ", "Diob\u00f9taidh" },
            { "DK", "An Danmhairg" },
            { "DM", "Doiminicea" },
            { "DO", "A\u2019 Phoblachd Dhoiminiceach" },
            { "DZ", "Aildiria" },
            { "EA", "Ceuta agus Melilla" },
            { "EC", "Eacuador" },
            { "EE", "An Eastoin" },
            { "EG", "An \u00c8iphit" },
            { "EH", "Sathara an Iar" },
            { "ER", "Eartra" },
            { "ES", "An Sp\u00e0innt" },
            { "ET", "An Itiop" },
            { "EU", "An t-Aonadh E\u00f2rpach" },
            { "EZ", "Raon an E\u00f2ro" },
            { "FI", "An Fhionnlann" },
            { "FJ", "F\u00ecdi" },
            { "FK", "Na h-Eileanan F\u00e0clannach" },
            { "FM", "Na Meanbh-eileanan" },
            { "FO", "Na h-Eileanan F\u00e0ro" },
            { "FR", "An Fhraing" },
            { "GA", "Gabon" },
            { "GB", "An R\u00ecoghachd Aonaichte" },
            { "GD", "Grean\u00e0da" },
            { "GE", "A\u2019 Chairtbheil" },
            { "GF", "Guidhe\u00e0na na Frainge" },
            { "GG", "Ge\u00e0rnsaidh" },
            { "GH", "G\u00e0na" },
            { "GI", "Diobraltar" },
            { "GL", "A\u2019 Ghraonlann" },
            { "GM", "A\u2019 Ghaimbia" },
            { "GN", "Gini" },
            { "GP", "Guadalup" },
            { "GQ", "Gini Mheadhan-Chriosach" },
            { "GR", "A\u2019 Ghreug" },
            { "GS", "Se\u00f2irsea a Deas is na h-Eileanan Sandwich a Deas" },
            { "GT", "Guatamala" },
            { "GU", "Guam" },
            { "GW", "Gini-Bioso" },
            { "GY", "Guidhe\u00e0na" },
            { "HK", "Hong Kong SAR na S\u00ecne" },
            { "HM", "Eilean Heard is MhicDh\u00f2mhnaill" },
            { "HN", "Hond\u00f9ras" },
            { "HR", "A\u2019 Chr\u00f2thais" },
            { "HT", "Haidhti" },
            { "HU", "An Ungair" },
            { "IC", "Na h-Eileanan Can\u00e0rach" },
            { "ID", "Na h-Innd-innse" },
            { "IE", "\u00c8irinn" },
            { "IL", "Iosrael" },
            { "IM", "Eilean Mhanainn" },
            { "IN", "Na h-Innseachan" },
            { "IO", "Ranntair Breatannach Cuan nan Innseachan" },
            { "IQ", "Ior\u00e0c" },
            { "IR", "Ior\u00e0n" },
            { "IS", "Innis T\u00ecle" },
            { "IT", "An Eadailt" },
            { "JE", "De\u00e0rsaidh" },
            { "JM", "Diameuga" },
            { "JO", "I\u00f2rdan" },
            { "JP", "An t-Seapan" },
            { "KE", "Ceinia" },
            { "KG", "C\u00ecorgastan" },
            { "KH", "Cambuidea" },
            { "KI", "Ciribeas" },
            { "KM", "Comoros" },
            { "KN", "Naomh Cr\u00ecstean is Nibheis" },
            { "KP", "Coir\u00e8a a Tuath" },
            { "KR", "Coir\u00e8a" },
            { "KW", "Cuibh\u00e8it" },
            { "KY", "Na h-Eileanan Caimean" },
            { "KZ", "Casachst\u00e0n" },
            { "LA", "L\u00e0thos" },
            { "LB", "Leabanon" },
            { "LC", "Naomh L\u00f9isea" },
            { "LI", "Lichtenstein" },
            { "LK", "Sri Lanca" },
            { "LR", "Lib\u00e8ir" },
            { "LS", "Leasoto" },
            { "LT", "An Liotuain" },
            { "LU", "Lugsamburg" },
            { "LV", "An Laitbhe" },
            { "LY", "Libia" },
            { "MA", "Moroco" },
            { "MC", "Monaco" },
            { "MD", "A\u2019 Mholdobha" },
            { "ME", "Am Monadh Neagrach" },
            { "MF", "Naomh M\u00e0rtainn" },
            { "MG", "Madagasgar" },
            { "MH", "Eileanan Mharshall" },
            { "MK", "A\u2019 Mhasadon a Tuath" },
            { "ML", "M\u00e0ili" },
            { "MM", metaValue_MM },
            { "MN", "D\u00f9thaich nam Mongol" },
            { "MO", "Mac\u00e0thu SAR na S\u00ecne" },
            { "MP", "Na h-Eileanan Mairianach a Tuath" },
            { "MQ", "Mairtinic" },
            { "MR", "Morat\u00e0inea" },
            { "MS", "Montsarat" },
            { "MT", "Malta" },
            { "MU", "Na h-Eileanan Mhoiriseas" },
            { "MV", "Na h-Eileanan Mhaladaibh" },
            { "MW", "Malabhaidh" },
            { "MX", "Meagsago" },
            { "MY", "Malaidhsea" },
            { "MZ", "M\u00f2saimbic" },
            { "NA", "An Namaib" },
            { "NC", "Cailleann Nuadh" },
            { "NE", "N\u00ecgeir" },
            { "NF", "Eilean Norfolk" },
            { "NG", "Nig\u00e8iria" },
            { "NI", "Niocaragua" },
            { "NL", "Na T\u00ecrean \u00ccsle" },
            { "NO", "Nirribhidh" },
            { "NP", "Neap\u00e0l" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Sealainn Nuadh" },
            { "OM", "Om\u00e0n" },
            { "PA", "Panama" },
            { "PE", "Pear\u00f9" },
            { "PF", "Poilin\u00e8is na Frainge" },
            { "PG", "Gini Nuadh Phaputhach" },
            { "PH", "Na h-Eileanan Filipineach" },
            { "PK", "Pagast\u00e0n" },
            { "PL", "A\u2019 Ph\u00f2lainn" },
            { "PM", "Saint Pierre agus Miquelon" },
            { "PN", "Eileanan Pheit a\u2019 Ch\u00e0irn" },
            { "PR", "Porto R\u00ecceo" },
            { "PS", "\u00d9ghdarras nam Palastaineach" },
            { "PT", "A\u2019 Phortagail" },
            { "PW", "Palabh" },
            { "PY", "Paraguaidh" },
            { "QA", "Catar" },
            { "QO", "Roinn Iomallach a\u2019 Chuain S\u00e8imh" },
            { "RE", "R\u00e9union" },
            { "RO", "Rom\u00e0inia" },
            { "RS", "An t-S\u00e8irb" },
            { "RU", "An Ruis" },
            { "RW", "Rubhanda" },
            { "SA", "Ar\u00e0ibia nan Sabhd" },
            { "SB", "Eileanan Sholaimh" },
            { "SC", "Na h-Eileanan Sheiseall" },
            { "SD", "Sud\u00e0n" },
            { "SE", "An t-Suain" },
            { "SG", "Singeap\u00f2r" },
            { "SH", "Eilean Naomh Eilidh" },
            { "SI", "An t-Sl\u00f2bhain" },
            { "SJ", "Svalbard is Jan Mayen" },
            { "SK", "An t-Sl\u00f2bhac" },
            { "SL", "Siarra Le\u00f2mhann" },
            { "SM", "San Marino" },
            { "SN", "Seanagal" },
            { "SO", "Som\u00e0ilia" },
            { "SR", "Suranam" },
            { "SS", "Sud\u00e0n a Deas" },
            { "ST", "S\u00e3o Tom\u00e9 agus Pr\u00edncipe" },
            { "SV", "An Salbhador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siridhea" },
            { "SZ", "eSwatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Na h-Eileanan Turcach is Caiceo" },
            { "TD", "An t-Se\u00e0d" },
            { "TF", "Ranntairean a Deas na Frainge" },
            { "TG", "Togo" },
            { "TH", "D\u00f9thaich nan T\u00e0idh" },
            { "TJ", "Taidigeast\u00e0n" },
            { "TK", metaValue_TK },
            { "TL", "Timor-Leste" },
            { "TM", "Turcmanast\u00e0n" },
            { "TN", "Tuinisea" },
            { "TO", metaValue_TO },
            { "TR", "An Tuirc" },
            { "TT", "Trianaid agus Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taidh-Bh\u00e0n" },
            { "TZ", "An Tansan" },
            { "UA", "An Ucr\u00e0in" },
            { "UG", "Uganda" },
            { "UM", "Meanbh-Eileanan Iomallach nan SA" },
            { "UN", "Na D\u00f9thchannan Aonaichte" },
            { "US", "Na St\u00e0itean Aonaichte" },
            { "UY", "Uruguaidh" },
            { "UZ", "Usbagast\u00e0n" },
            { "VA", "Cathair na Bhatacain" },
            { "VC", "Naomh Bhionsant agus Eileanan Greanadach" },
            { "VE", "A\u2019 Bheiniseala" },
            { "VG", "Eileanan Breatannach na Maighdinn" },
            { "VI", "Eileanan na Maighdinn aig na SA" },
            { "VN", "Bhiet-Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Uallas agus Futuna" },
            { "WS", "Samotha" },
            { "XA", "Sr\u00e0can fuadain" },
            { "XB", "D\u00e0-chomhaireach fuadain" },
            { "XK", "A\u2019 Chosobho" },
            { "YE", "An Eaman" },
            { "YT", "Mayotte" },
            { "ZA", "Afraga a Deas" },
            { "ZM", "S\u00e0imbia" },
            { "ZW", "An t-S\u00ecombab" },
            { "ZZ", "Roinn-d\u00f9thcha neo-aithnichte" },
            { "aa", "Afar" },
            { "ab", "Abchasais" },
            { "ae", metaValue_ae },
            { "af", "Afraganais" },
            { "ak", "Akan" },
            { "am", "Amtharais" },
            { "an", "Aragonais" },
            { "ar", metaValue_ar },
            { "as", "Asamais" },
            { "av", "Avarais" },
            { "ay", "Aymara" },
            { "az", "Asarbaide\u00e0nais" },
            { "ba", "Bashkir" },
            { "be", "Bealaruisis" },
            { "bg", "Bulgarais" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bangla" },
            { "bo", metaValue_bo },
            { "br", "Breatnais" },
            { "bs", "Bosnais" },
            { "ca", "Catalanais" },
            { "ce", "Deideanais" },
            { "ch", "Chamorro" },
            { "co", "Corsais" },
            { "cr", "Cree" },
            { "cs", "Seicis" },
            { "cu", "Sl\u00e0bhais na h-Eaglaise" },
            { "cv", "Chuvash" },
            { "cy", "Cuimris" },
            { "da", "Danmhairgis" },
            { "de", "Gearmailtis" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Beurla" },
            { "eo", "Esperanto" },
            { "es", "Sp\u00e0inntis" },
            { "et", "Eastoinis" },
            { "eu", "Basgais" },
            { "fa", "Peirsis" },
            { "ff", "Fulah" },
            { "fi", "Fionnlannais" },
            { "fj", "F\u00ecdis" },
            { "fo", "F\u00e0rothais" },
            { "fr", "Fraingis" },
            { "fy", "Fr\u00ecoslannais Shiarach" },
            { "ga", "Gaeilge" },
            { "gd", "G\u00e0idhlig" },
            { "gl", "Gail\u00ecsis" },
            { "gn", "Guaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "Gaelg" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindis" },
            { "ho", "Hiri Motu" },
            { "hr", "Cr\u00f2thaisis" },
            { "ht", "Cr\u00ectheol Haidhti" },
            { "hu", "Ungairis" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Innd-Innsis" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Yi Sichuan" },
            { "ik", "Inupiaq" },
            { "io", "Ido" },
            { "is", "Innis T\u00eclis" },
            { "it", "Eadailtis" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Casachais" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Caismiris" },
            { "ku", "C\u00f9rdais" },
            { "kv", "Komi" },
            { "kw", "C\u00f2rnais" },
            { "ky", "C\u00ecorgasais" },
            { "la", metaValue_la },
            { "lb", "Lugsamburgais" },
            { "lg", "Ganda" },
            { "li", "C\u00e0nan Limburg" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Liotuainis" },
            { "lu", "Luba-Katanga" },
            { "lv", "Laitbheis" },
            { "mg", "Malagasais" },
            { "mh", "Marshallais" },
            { "mi", "M\u0101ori" },
            { "mk", "Masadonais" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaidhis" },
            { "mt", "Maltais" },
            { "my", "Burmais" },
            { "na", metaValue_NR },
            { "nb", "Bokm\u00e5l na Nirribhidh" },
            { "nd", "Ndebele Thuathach" },
            { "ne", "Neap\u00e0lais" },
            { "ng", "Ndonga" },
            { "nl", "Duitsis" },
            { "nn", "Nynorsk na Nirribhidh" },
            { "no", "Nirribhis" },
            { "nr", "Ndebele Dheasach" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Ogsatanais" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Ossetic" },
            { "pa", "Panjabi" },
            { "pi", "Pali" },
            { "pl", "P\u00f2lainnis" },
            { "ps", "Pashto" },
            { "pt", "Portagailis" },
            { "qu", "Quechua" },
            { "rm", "Rumains" },
            { "rn", "Kirundi" },
            { "ro", "Rom\u00e0inis" },
            { "ru", "Ruisis" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "S\u00e0rdais" },
            { "sd", "Sindhi" },
            { "se", "S\u00e0mais Thuathach" },
            { "sg", "Sango" },
            { "sh", "S\u00e8irb-Chr\u00f2thaisis" },
            { "si", metaValue_si },
            { "sk", "Sl\u00f2bhacais" },
            { "sl", "Sl\u00f2bhainis" },
            { "sm", "Samothais" },
            { "sn", "Shona" },
            { "so", "Som\u00e0ilis" },
            { "sq", "Alb\u00e0inis" },
            { "sr", "S\u00e8irbis" },
            { "ss", "Swati" },
            { "st", "Sesotho" },
            { "su", "C\u00e0nan Sunda" },
            { "sv", "Suainis" },
            { "sw", "Kiswahili" },
            { "ta", "Taimilis" },
            { "te", metaValue_te },
            { "tg", "Taidigis" },
            { "th", "C\u00e0nan nan T\u00e0idh" },
            { "ti", "Tigrinya" },
            { "tk", "Turcmanais" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "tr", "Turcais" },
            { "ts", "Tsonga" },
            { "tt", "Tatarais" },
            { "tw", "Twi" },
            { "ty", "C\u00e0nan Tahiti" },
            { "ug", "\u00d9igiurais" },
            { "uk", "Ucr\u00e0inis" },
            { "ur", "\u00d9rdu" },
            { "uz", "Usbagais" },
            { "ve", "Venda" },
            { "vi", "Bhiet-Namais" },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "I\u00f9dhais" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "S\u00ecnis" },
            { "zu", "Zulu" },
            { "ace", "Basa Ac\u00e8h" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "aeb", "Arabais Thuiniseach" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "akk", "Acadais" },
            { "akz", "Alabama" },
            { "ale", "Aleutais" },
            { "aln", "Alb\u00e0inis Ghegeach" },
            { "alt", "Altais Dheasach" },
            { "ang", "Seann-Bheurla" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "apc", "Arabais Levantach" },
            { "arc", "Aramais" },
            { "arn", "Mapudungun" },
            { "aro", "Araona" },
            { "arp", "Arapaho" },
            { "arq", "Arabais Aildireach" },
            { "ars", "Arabais Najdi" },
            { "arw", "Arawak" },
            { "ary", "Arabais Mhorocach" },
            { "arz", "Arabais \u00c8ipheiteach" },
            { "asa", "Asu" },
            { "ase", "Cainnt-shanais na h-Aimeireaga" },
            { "ast", "Ast\u00f9rais" },
            { "atj", "Atikamekw" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Baluch\u00ec" },
            { "ban", "C\u00e0nan Bali" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bgc", "Haryanvi" },
            { "bgn", "Balochi Shiarach" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Edo" },
            { "bjn", "Banjar" },
            { "bkm", "Kom" },
            { "bla", "Siksika" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bakhtiari" },
            { "bra", "Braj" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buriat" },
            { "bug", "C\u00e0nan nam Bugis" },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Caddo" },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "C\u00e0nan Chuuk" },
            { "chm", "Mari" },
            { "chn", "Chinuk Wawa" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "C\u00f9rdais Mheadhanach" },
            { "clc", "Chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "Capiznon" },
            { "crg", "Michif" },
            { "crh", "Turcais Chriomach" },
            { "crj", "Cree Ear-dheasach" },
            { "crk", "Cree nam Machair" },
            { "crl", "Cree Ear-thuathach" },
            { "crm", "Moose Cree" },
            { "crr", "Algonquianais Charolina" },
            { "crs", "Seiseallais" },
            { "csb", "Caisiubais" },
            { "csw", "Omushkego" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slavey" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "S\u00f2rbais \u00ccochdarach" },
            { "dtp", "Dusun Mheadhanach" },
            { "dua", "Duala" },
            { "dum", "Meadhan-Dhuitsis" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "\u00c8ipheitis \u00c0rsaidh" },
            { "eka", "Ekajuk" },
            { "elx", "Elamais" },
            { "enm", "Meadhan-Bheurla" },
            { "esu", "Yupik Mheadhanach" },
            { "ewo", "Ewondo" },
            { "ext", "C\u00e0nan na h-Extremadura" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipinis" },
            { "fit", "Me\u00e4nkieli" },
            { "fon", "Fon" },
            { "frc", "Fraingis nan Cajun" },
            { "frm", "Meadhan-Fhraingis" },
            { "fro", "Seann-Fhraingis" },
            { "frp", "Arpitan" },
            { "frr", "Fr\u00ecoslannais Thuathach" },
            { "frs", "Fr\u00ecoslannais Earach" },
            { "fur", "Fri\u00f9ilis" },
            { "gaa", "Ga" },
            { "gag", "Gagauz" },
            { "gan", "Gan" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gbz", "Dari Zoroastrach" },
            { "gez", metaValue_gez },
            { "gil", "Ciribeasais" },
            { "glk", "Gilaki" },
            { "gmh", "Meadhan-\u00c0rd-Gearmailtis" },
            { "goh", "Seann-\u00c0rd-Gearmailtis" },
            { "gom", "Konkani Goa" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Greugais \u00c0rsaidh" },
            { "gsw", "Gearmailtis Eilbheiseach" },
            { "guc", "Wayuu" },
            { "gur", "Frafra" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "hak", "Hakka" },
            { "haw", "C\u00e0nan Hawai\u2019i" },
            { "hax", "Haida Dheasach" },
            { "hif", "Hindis Fh\u00ecditheach" },
            { "hil", "Hiligaynon" },
            { "hit", "C\u00e0nan Het" },
            { "hmn", "Hmong" },
            { "hsb", "S\u00f2rbais Uachdarach" },
            { "hsn", "Xiang" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Inuktitut Shiarach Chanada" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jam", "Beurla Cr\u00ectheolach Diameuga" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Peirsis I\u00f9dhach" },
            { "jrb", "Arabais I\u00f9dhach" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", metaValue_kaw },
            { "kbd", "Cabardais" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "kho", "C\u00e0nan Khotan" },
            { "khq", "Koyra Chiini" },
            { "khw", "Khowar" },
            { "kiu", "Kirmanjki" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "kpe", metaValue_kpe },
            { "krc", "Karachay-Balkar" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Cairealais" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Gearmailtis Chologne" },
            { "kum", "Kumyk" },
            { "kut", "Kutenai" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Leasgais" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Liog\u00f9rais" },
            { "lil", "Lillooet" },
            { "lkt", "Lakh\u00f3ta" },
            { "lmo", "Lombardais" },
            { "lol", "Mongo" },
            { "lou", "Cr\u00ectheol Louisiana" },
            { "loz", "Lozi" },
            { "lrc", "Luri Thuathach" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luise\u00f1o" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "lzh", "S\u00ecnis an Litreachais" },
            { "lzz", "Laz" },
            { "mad", "C\u00e0nan Madhura" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", metaValue_mak },
            { "man", "Mandingo" },
            { "mas", "Maasai" },
            { "mde", "Maba" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Meadhan-Ghaeilge" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Mi\u2019kmaq" },
            { "min", "Minangkabau" },
            { "mnc", "Manchu" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mrj", "Mari Shiarach" },
            { "mua", "Mundang" },
            { "mul", "Iomadh c\u00e0nan" },
            { "mus", "Creek" },
            { "mwl", "Miorandais" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nan", "Min Nan" },
            { "nap", "Eadailtis Napoli" },
            { "naq", "Nama" },
            { "nds", "Gearmailtis \u00ccochdarach" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "C\u00e0nan Niue" },
            { "njo", "Ao Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Seann-Lochlannais" },
            { "nov", "Novial" },
            { "nqo", "N\u2019Ko" },
            { "nso", "Sesotho sa Leboa" },
            { "nus", "Nuer" },
            { "nwc", "Newari Chlasaigeach" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "ojb", "Ojibwa Iar-thuathach" },
            { "ojc", "Ojibwa Mheadhanach" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Ojibwa Shiarach" },
            { "oka", "Okanagan" },
            { "osa", metaValue_osa },
            { "ota", "Turcais Otomanach" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiamentu" },
            { "pau", "Palabhais" },
            { "pcd", "Picard" },
            { "pcm", "Beurla Nig\u00e8iriach" },
            { "pdc", "Gearmailtis Phennsylvania" },
            { "pdt", "Plautdietsch" },
            { "peo", metaValue_peo },
            { "phn", "Phenicis" },
            { "pis", "Pijin" },
            { "pms", "Piedmontese" },
            { "pon", "C\u00e0nan Pohnpei" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Pruisis" },
            { "pro", "Seann-Phroven\u00e7al" },
            { "quc", "K\u2019iche\u2019" },
            { "qug", "Quichua \u00c0rd-t\u00ecr Chimborazo" },
            { "raj", "Rajasthani" },
            { "rap", "Rapa Nui" },
            { "rar", "C\u00e0nan Rarotonga" },
            { "rgn", "Romagnol" },
            { "rhg", "Rohingya" },
            { "rif", "Tamaisich an Rif" },
            { "rof", "Rombo" },
            { "rom", "Romanais" },
            { "rue", "Rusyn" },
            { "rug", "Roviana" },
            { "rup", "Aromanais" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "sam", "Aramais Shamaritanach" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sisilis" },
            { "sco", "Albais" },
            { "sdc", "Sassarese" },
            { "sdh", "C\u00f9rdais Dheasach" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkup" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Seann-Ghaeilge" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "shu", "Arabais Se\u00e0dach" },
            { "sid", "Sidamo" },
            { "slh", "Lushootseed Dheasach" },
            { "sly", "Selayar" },
            { "sma", "S\u00e0mais Dheasach" },
            { "smj", "S\u00e0mais Lule" },
            { "smn", "S\u00e0mais Inari" },
            { "sms", "S\u00e0mais Skolt" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer" },
            { "ssy", metaValue_ssy },
            { "str", "Salish a\u2019 Chaolais" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "C\u00e0nan Sumer" },
            { "swb", "Comorais" },
            { "syc", "Suraidheac Chlasaigeach" },
            { "syr", metaValue_syr },
            { "tce", "Tutchone Dheasach" },
            { "tcy", "Tulu" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Ter\u00eana" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", metaValue_TK },
            { "tkr", "Tsakhur" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tly", "Talysh" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "tsi", "Tsimshian" },
            { "ttm", "Tutchone Thuathach" },
            { "ttt", "Tati" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "C\u00e0nan Tuva" },
            { "tzm", "Tamaisich an Atlais Mheadhanaich" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "C\u00e0nan neo-aithnichte" },
            { "vai", metaValue_vai },
            { "vec", "Bheinisis" },
            { "vep", "Veps" },
            { "vls", "Fl\u00e0nrais Shiarach" },
            { "vro", "V\u00f5ro" },
            { "vun", "Vunjo" },
            { "wae", "Gearmailtis Wallis" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "C\u00e0nan Yap" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Cantonais" },
            { "zap", "Zapotec" },
            { "zbl", metaValue_zbl },
            { "zea", "C\u00e0nan Zeeland" },
            { "zen", "Zenaga" },
            { "zgh", "Tamaisich Stannardach Moroco" },
            { "zun", "Zu\u00f1i" },
            { "zxx", "Susbaint nach eil \u2019na ch\u00e0nan" },
            { "zza", "Zazaki" },
            { "Adlm", "Adlam" },
            { "Afak", "Afaka" },
            { "Aghb", "Alb\u00e0inis Chabhcasach" },
            { "Ahom", "Ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armi", "Aramais impireil" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", "Bali" },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Beangailis" },
            { "Bhks", "Bhaiksuki" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", "Lontara" },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Sgr\u00ecobhadh Lideach Aonaichte nan T\u00f9sanach Canadach" },
            { "Cari", "Carian" },
            { "Cham", "Cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "Khwarazm" },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cpmn", "M\u00ecneothais Ch\u00ecopras" },
            { "Cprt", "C\u00ecoprasais" },
            { "Cyrl", "Cirilis" },
            { "Cyrs", "Cirilis Seann-Sl\u00e0bhais na h-Eaglaise" },
            { "Deva", "Devanagari" },
            { "Diak", "Dives Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Gearr-sgr\u00ecobhadh Duploy\u00e9" },
            { "Egyp", "Sealbh-sgr\u00ecobhadh \u00c8ipheiteach" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaidheach" },
            { "Ethi", metaValue_gez },
            { "Geor", metaValue_ka },
            { "Glag", "Glagoliticeach" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", metaValue_got },
            { "Gran", "Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han le Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Simplichte" },
            { "Hant", "Tradaiseanta" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Dealbh-sgr\u00ecobhadh Anatolach" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "Katakana no Hiragana" },
            { "Hung", "Seann-Ungarais" },
            { "Ital", "Seann-Eadailtis" },
            { "Jamo", "Jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Kawi", metaValue_kaw },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Kits", "Litrichean beaga na Khitan" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Laideann fraktur" },
            { "Latg", "Laideann Gh\u00e0idhealach" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Lisu" },
            { "Loma", "Loma" },
            { "Lyci", "Lycian" },
            { "Lydi", "Lydian" },
            { "Mahj", "Mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "Mandaean" },
            { "Mani", "Manichaean" },
            { "Marc", "Marchen" },
            { "Maya", "Dealbh-sgr\u00ecobhadh Mayach" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Meroiticeach ceangailte" },
            { "Mero", "Meroiticeach" },
            { "Mlym", metaValue_ml },
            { "Modi", "Modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", metaValue_MM },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Seann-Arabach Thuathach" },
            { "Nbat", "Nabataean" },
            { "Newa", "Newa" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", "N\u2019ko" },
            { "Nshu", "N\u00fcshu" },
            { "Ogam", "Ogham-chraobh" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", "Oriya" },
            { "Osge", metaValue_osa },
            { "Osma", "Osmanya" },
            { "Ougr", "Seann-\u00d9igiurais" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Seann-Phermic" },
            { "Phag", "Phags-pa" },
            { "Phli", "Pahlavi nan snaidh-sgr\u00ecobhaidhean" },
            { "Phlp", "Pahlavi nan saltair" },
            { "Phnx", "Pheniceach" },
            { "Plrd", "Miao Phollard" },
            { "Prti", "Partais snaidh-sgr\u00ecobhte" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi Rohingya" },
            { "Roro", "Rongorongo" },
            { "Runr", "R\u00f9n-sgr\u00ecobhadh" },
            { "Samr", "Samaritanais" },
            { "Sara", "Sarati" },
            { "Sarb", "Seann-Arabais Dheasach" },
            { "Saur", metaValue_saz },
            { "Sgnw", "Sgr\u00ecobhadh cainnte-sanais" },
            { "Shaw", "Sgr\u00ecobhadh an t-Seathaich" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "Sogdianais" },
            { "Sogo", "Seann-Sogdianais" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", "Sunda" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syrj", "Suraidheac Siarach" },
            { "Syrn", "Suraidheac Earach" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue \u00d9r" },
            { "Taml", "Taimil" },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", "T\u00e0idh" },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Tnsa", "Tangsa" },
            { "Toto", "Toto" },
            { "Ugar", "Ugariticeach" },
            { "Vaii", metaValue_vai },
            { "Vith", "Vithkuqi" },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Wole", "Woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "G\u00e8inn-sgr\u00ecobhadh Sumer is Akkad" },
            { "Yezi", "Yezidis" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar ce\u00e0rnagach" },
            { "Zinh", "D\u00ecleab" },
            { "Zmth", "Gn\u00ecomhairean matamataig" },
            { "Zsye", "Emoji" },
            { "Zsym", "Samhlaidhean" },
            { "Zxxx", "Gun sgr\u00ecobhadh" },
            { "Zyyy", "Coitcheann" },
            { "Zzzz", "Litreadh neo-aithnichte" },
            { "de_AT", "Gearmailtis na h-Ostaire" },
            { "de_CH", "\u00c0rd-Ghearmailtis na h-Eilbheise" },
            { "en_AU", "Beurla Astr\u00e0ilia" },
            { "en_CA", "Beurla Chanada" },
            { "en_GB", "Beurla Bhreatainn" },
            { "en_US", "Beurla na h-Aimeireaga" },
            { "es_ES", "Sp\u00e0inntis E\u00f2rpach" },
            { "es_MX", "Sp\u00e0inntis Mheagsagach" },
            { "fa_AF", "Dari" },
            { "fr_CA", "Fraingis Chanada" },
            { "fr_CH", "Fraingis Eilbheiseach" },
            { "nl_BE", "Fl\u00e0nrais" },
            { "pt_BR", "Portagailis Bhraisileach" },
            { "pt_PT", "Portagailis E\u00f2rpach" },
            { "ro_MD", "Moldobhais" },
            { "sw_CD", "Kiswahili na Congo" },
            { "%%1901", "Litreachadh tradaiseanta na Gearmailtise" },
            { "%%1994", "Litreachadh stannardach dual-chainnt Resia" },
            { "%%1996", "Litreachadh na Gearmailtise 1996" },
            { "ar_001", "Nuadh-Arabais Stannardach" },
            { "es_419", "Sp\u00e0inntis na h-Aimeireaga Laidinneach" },
            { "key.ca", "M\u00ecosachan" },
            { "key.cf", "F\u00f2rmat an airgeadra" },
            { "key.co", "\u00d2rdugh an t-se\u00f2rsachaidh" },
            { "key.cu", "Airgeadra" },
            { "key.hc", "Cearcall an ama (12 no 24 uair)" },
            { "key.lb", "Stoidhle nam brisidhean-loidhe" },
            { "key.ms", "Siostam tomhais" },
            { "key.nu", "\u00c0ireamhan" },
            { "nds_NL", "Sagsannais \u00ccochdarach" },
            { "%%ALUKU", "Dual-chainnt Aluku" },
            { "%%BARLA", "Dual-chainntean Barlavento de Kabuverdianu" },
            { "%%BISKE", "Dual-chainnt San Giorgio/Bila" },
            { "%%BOONT", "Boontling" },
            { "%%CORNU", "Beurla na C\u00f2irne" },
            { "%%GALLO", "Gallo" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Litreachadh coitcheann" },
            { "%%KSCOR", "Litreachadh stannardach" },
            { "%%LIPAW", "Dual-chainnt Lipovaz Resia" },
            { "%%NEDIS", "Dual-chainnt Natisone" },
            { "%%NJIVA", "Dual-chainnt Gniva/Njiva" },
            { "%%NULIK", "Nua-Volap\u00fck" },
            { "%%OSOJS", "Dual-chainnt Oseacco/Osojane" },
            { "%%PEANO", "Peano" },
            { "%%POSIX", "Coimpiutair" },
            { "%%PUTER", "Puter" },
            { "%%RIGIK", "Volap\u00fck chlasaigeach" },
            { "%%ROZAJ", "Dual-chainnt Resia" },
            { "%%RUMGR", "Rumantsch Grischun" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Dual-chainnt Stolvizza/Solbica" },
            { "%%SOTAV", "Dual-chainntean Sotavento de Kabuverdianu" },
            { "%%UCCOR", "Litreachadh aonaichte" },
            { "zh_Hans", "S\u00ecnis Shimplichte" },
            { "zh_Hant", "S\u00ecnis Thradaiseanta" },
            { "%%AO1990", "Aonta litreachadh na Portagailise 1990" },
            { "%%ARANES", "Aranais" },
            { "%%ASANTE", "Asante" },
            { "%%AUVERN", "Auvernhat" },
            { "%%CISAUP", "Ogsatanais cios-Ailpeach" },
            { "%%CREISS", "Ogsatanais Chroissant" },
            { "%%DAJNKO", "Aibidil Dajnko" },
            { "%%EKAVSK", "S\u00e8irbhis le fuaimneachadh iarach" },
            { "%%FONIPA", "Comharran fuaim-e\u00f2lais an IPA" },
            { "%%FONUPA", "Comharran fuaim-e\u00f2lais an UPA" },
            { "%%GASCON", "Ogsatanais Ghascogne" },
            { "%%GRITAL", "N\u00f2s-sgr\u00ecobhaidh Eadailteach na h-Ogsatanaise" },
            { "%%NDYUKA", "Dual-chainnt Ndyuka" },
            { "%%NICARD", "Ogsatanais Nice" },
            { "%%PAMAKA", "Dual-chainnt Pamaka" },
            { "%%PINYIN", "R\u00f2manachadh Pinyin" },
            { "%%SCOUSE", "Scouse" },
            { "%%SIMPLE", "Samhlaidhean s\u00ecmplichte" },
            { "%%TARASK", "Litreachadh Tara\u0161kievica" },
            { "%%UCRCOR", "Litreachadh aonaichte \u2019s l\u00e8irmheasaichte" },
            { "%%ULSTER", "Albais Uladh" },
            { "%%UNIFON", "Aibidil fuaim-e\u00f2lais Unifon" },
            { "%%ABL1943", "Gn\u00e0thas-litreachaidh 1943" },
            { "%%AKUAPEM", "Akuapem" },
            { "%%ALALC97", "R\u00f2manachadh ALA-LC 1997" },
            { "%%AREVELA", "Airmeinis an Ear" },
            { "%%AREVMDA", "Airmeinis an Iar" },
            { "%%ARKAIKA", "Arkaika" },
            { "%%BALANKA", "Dual-chainnt Balanka de Anii" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "Aibidil Bohori\u010d" },
            { "%%EMODENG", "Nua-Bheurla thr\u00e0th" },
            { "%%FONNAPA", "Aibidil Fhuaim-e\u00f2lach Aimeireaga a Tuath" },
            { "%%GRCLASS", "N\u00f2s-sgr\u00ecobhaidh clasaigeach na h-Ogsatanaise" },
            { "%%GRMISTR", "N\u00f2s-sgr\u00ecobhaidh Mhistral na h-Ogsatanaise" },
            { "%%HEPBURN", "R\u00f2manachadh Hepburn" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%LEMOSIN", "Ogsatanais Lemosin" },
            { "%%LTG1929", "Litreachadh na Latgailise 1929" },
            { "%%LTG2007", "Litreachadh na Latgailise 2007" },
            { "%%METELKO", "Aibidil Metelko" },
            { "%%MONOTON", "Greugais mhonotonach" },
            { "%%PAHAWH2", "Pahawh Hmong na 2na \u00ecre" },
            { "%%PAHAWH3", "Pahawh Hmong na 3s \u00ecre" },
            { "%%PAHAWH4", "Pahawh Hmong na 4mh \u00ecre" },
            { "%%POLYTON", "Greugais phoiliotonach" },
            { "%%PROVENC", "Ogsatanais Phrovence" },
            { "%%REVISED", "Litreachadh l\u00e8irmheasaichte" },
            { "%%SURSILV", "Sursilvan" },
            { "%%SUTSILV", "Sutsilvan" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "Meadhan-Fhraingis anmoch gu 1606" },
            { "%%1694ACAD", "Nua-Fhraingis thr\u00e0th" },
            { "%%1959ACAD", "Bealaruisis Acadamaigeach" },
            { "%%BAKU1926", "Abidil Laideann aonaichte na Turcaise" },
            { "%%BASICENG", "Beurla bhunasach" },
            { "%%BISCAYAN", "Dual-chainnt Bizkaia" },
            { "%%BORNHOLM", "Bornholmsk" },
            { "%%COLB1945", "Aonta litreachaidh eadar a\u2019 Phortagail is Braisil 1945" },
            { "%%FONKIRSH", "C\u00f2dachadh Kirshenbaum na h-Aibidil Fuaim-e\u00f2laiche" },
            { "%%FONXSAMP", "Tar-sgr\u00ecobhadh X-SAMPA" },
            { "%%HOGNORSK", "H\u00f8gnorsk" },
            { "%%HSISTEMO", "Roghainn-\u00e8iginn stannardach litreachadh na h-Esperanto le h" },
            { "%%IJEKAVSK", "S\u00e8irbis le fuaimneachadh Ijekavia" },
            { "%%IVANCHOV", "Bulgarian in 1899 orthography = Bulgairis le litreachadh na bliadhna 1899" },
            { "%%JYUTPING", "Jyutping" },
            { "%%KOCIEWIE", "Kociewie" },
            { "%%LENGADOC", "Ogsatanais Lengadoc" },
            { "%%LUNA1918", "Litreachadh na Ruisise \u00e0s d\u00e8idh 1917" },
            { "%%NEWFOUND", "Beurla Talamh an \u00c8isg" },
            { "%%OXENDICT", "Litreachadh faclair Oxford na Beurla" },
            { "%%PETR1708", "Litreachadh Pheadair 1708" },
            { "%%SCOTLAND", "Beurla Stannardach na h-Alba" },
            { "%%SPANGLIS", "Spanglish" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%SYNNEJYL", "Diutlannais Dheasach" },
            { "%%TONGYONG", "Tongyong" },
            { "%%TUNUMIIT", "Tunumiit" },
            { "%%VALENCIA", "Valenci\u00e0" },
            { "%%VALLADER", "Vallader" },
            { "%%VECDRUKA", "Vec\u0101 Druka" },
            { "%%VIVARAUP", "Ogsatanais Vivaro-Ailpeach" },
            { "%%WADEGILE", "R\u00f2manachadh Wade-Giles" },
            { "%%XSISTEMO", "Roghainn-\u00e8iginn stannardach litreachadh na h-Esperanto le x" },
            { "type.ca.roc", "M\u00ecosachan Poblachd na S\u00ecne" },
            { "type.co.eor", "\u00d2rdugh se\u00f2rsachaidh E\u00f2rpach" },
            { "type.hc.h11", "Cleoc 12 uair a th\u00ecde (0\u201311)" },
            { "type.hc.h12", "Cleoc 12 uair a th\u00ecde (1\u201312)" },
            { "type.hc.h23", "Cleoc 24 uair a th\u00ecde (0\u201323)" },
            { "type.hc.h24", "Cleoc 24 uair a th\u00ecde (1\u201324)" },
            { "type.m0.bgn", "Tar-litreachadh BGN nan St\u00e0itean Aonaichte" },
            { "type.nu.ahom", "\u00c0ireamhan Ahom" },
            { "type.nu.arab", "\u00c0ireamhan Arabach-Innseanach" },
            { "type.nu.armn", "\u00c0ireamhan na h-Airmeinise" },
            { "type.nu.bali", "\u00c0ireamhan Bali" },
            { "type.nu.beng", "\u00c0ireamhan na Beangailise" },
            { "type.nu.brah", "\u00c0ireamhan Brahmi" },
            { "type.nu.cakm", "\u00c0ireamhan Chakma" },
            { "type.nu.cham", "\u00c0ireamhan Cham" },
            { "type.nu.cyrl", "\u00c0ireamhan na Cirilise" },
            { "type.nu.deva", "\u00c0ireamhan Devanagari" },
            { "type.nu.diak", "\u00c0ireamhan Dives Akuru" },
            { "type.nu.ethi", "\u00c0ireamhan Itiopach" },
            { "type.nu.geor", "\u00c0ireamhan na Cairtbheilise" },
            { "type.nu.gong", "\u00c0ireamhan Gunjala Gondi" },
            { "type.nu.gonm", "\u00c0ireamhan Masaram Gondi" },
            { "type.nu.grek", "\u00c0ireamhan na Greugaise" },
            { "type.nu.gujr", "\u00c0ireamhan Gujarati" },
            { "type.nu.guru", "\u00c0ireamhan Gurmukhi" },
            { "type.nu.hans", "\u00c0ireamhan na S\u00ecnise Shimplichte" },
            { "type.nu.hant", "\u00c0ireamhan na S\u00ecnise Thradaiseanta" },
            { "type.nu.hebr", "\u00c0ireamhan na h-Eabhra" },
            { "type.nu.hmng", "\u00c0ireamhan Pahawh Hmong" },
            { "type.nu.hmnp", "\u00c0ireamhan Nyiakeng Puachue" },
            { "type.nu.java", "\u00c0ireamhan na De\u00e0bhanaise" },
            { "type.nu.jpan", "\u00c0ireamhan na Seapanaise" },
            { "type.nu.kali", "\u00c0ireamhan Kayah Li" },
            { "type.nu.kawi", "\u00c0ireamhan Kawi" },
            { "type.nu.khmr", "\u00c0ireamhan Cm\u00e8ar" },
            { "type.nu.knda", "\u00c0ireamhan Kannada" },
            { "type.nu.lana", "\u00c0ireamhan Tai Tham Hora" },
            { "type.nu.laoo", "\u00c0ireamhan L\u00e0tho" },
            { "type.nu.latn", "\u00c0ireamhan Siarach" },
            { "type.nu.lepc", "\u00c0ireamhan Lepcha" },
            { "type.nu.limb", "\u00c0ireamhan Limbu" },
            { "type.nu.mlym", "\u00c0ireamhan Malayalam" },
            { "type.nu.modi", "\u00c0ireamhan Modi" },
            { "type.nu.mong", "\u00c0ireamhan na Mongolaise" },
            { "type.nu.mroo", "\u00c0ireamhan Mro" },
            { "type.nu.mtei", "\u00c0ireamhan Meetei Mayek" },
            { "type.nu.mymr", "\u00c0ireamhan Mi\u00e0nmar" },
            { "type.nu.nagm", "\u00c0ireamhan Nag Mundari" },
            { "type.nu.nkoo", "\u00c0ireamhan N\u2019Ko" },
            { "type.nu.olck", "\u00c0ireamhan Ol Chiki" },
            { "type.nu.orya", "\u00c0ireamhan Odia" },
            { "type.nu.osma", "\u00c0ireamhan Osmanya" },
            { "type.nu.rohg", "\u00c0ireamhan Hanifi Rohingya" },
            { "type.nu.saur", "\u00c0ireamhan Saurashtra" },
            { "type.nu.shrd", "\u00c0ireamhan Sharada" },
            { "type.nu.sind", "\u00c0ireamhan Khudawadi" },
            { "type.nu.sinh", "\u00c0ireamhan Lith na Sinhala" },
            { "type.nu.sora", "\u00c0ireamhan Sora Sompeng" },
            { "type.nu.sund", "\u00c0ireamhan Sunda" },
            { "type.nu.takr", "\u00c0ireamhan Takri" },
            { "type.nu.talu", "\u00c0ireamhan Tai Lue \u00d9r" },
            { "type.nu.taml", "\u00c0ireamhan na Taimilise Tradaiseanta" },
            { "type.nu.telu", "\u00c0ireamhan Telugu" },
            { "type.nu.thai", "\u00c0ireamhan T\u00e0idh" },
            { "type.nu.tibt", "\u00c0ireamhan na Tibeitise" },
            { "type.nu.tirh", "\u00c0ireamhan Tirhuta" },
            { "type.nu.tnsa", "\u00c0ireamhan Tangsa" },
            { "type.nu.vaii", "\u00c0ireamhan Vai" },
            { "type.nu.wara", "\u00c0ireamhan Warang Citi" },
            { "type.nu.wcho", "\u00c0ireamhan Wancho" },
            { "type.ca.dangi", "M\u00ecosachan Dangi" },
            { "type.co.ducet", "\u00d2rdugh se\u00f2rsachaidh Unicode bunaiteach" },
            { "type.co.emoji", "\u00d2rdugh se\u00f2rsachaidh Emoji" },
            { "type.lb.loose", "Brisidhean-loidhe fuasgailte" },
            { "type.nu.roman", "\u00c0ireamhan R\u00f2manach" },
            { "type.ca.coptic", "Am M\u00ecosachan Coptach" },
            { "type.ca.hebrew", "Am M\u00ecosachan Eabhrach" },
            { "type.ca.indian", "M\u00ecosachan N\u00e0iseanta nan Innseachan" },
            { "type.co.compat", "\u00d2rdugh se\u00f2rsachaidh roimhe a chum co-ch\u00f2rdalachd" },
            { "type.co.pinyin", "\u00d2rdugh se\u00f2rsachaidh Pinyin" },
            { "type.co.search", "Lorg coitcheann" },
            { "type.co.stroke", "\u00d2rdugh nan str\u00e0can" },
            { "type.co.unihan", "\u00d2rdugh an fhreumha \u2019s nan str\u00e0can" },
            { "type.co.zhuyin", "\u00d2rdugh se\u00f2rsachaidh Zhuyin" },
            { "type.d0.fwidth", "L\u00e0n-Leud" },
            { "type.d0.hwidth", "Leth-Leud" },
            { "type.lb.normal", "Brisidhean-loidhe \u00e0bhaisteach" },
            { "type.lb.strict", "Brisidhean-loidhe teanna" },
            { "type.m0.ungegn", "Tar-litreachadh GEGN nan D\u00f9thchannan Aonaichte" },
            { "type.ms.metric", "Tomhas meatrach" },
            { "type.ca.chinese", "Am M\u00ecosachan S\u00ecneach" },
            { "type.ca.islamic", "Am M\u00ecosachan Hijri" },
            { "type.ca.iso8601", "M\u00ecosachan ISO-8601" },
            { "type.ca.persian", "Am M\u00ecosachan Pearsach" },
            { "type.cf.account", "F\u00f2rmat airgeadra na cunntasachd" },
            { "type.co.big5han", "\u00d2rdugh se\u00f2rsachaidh na S\u00ecnise Tradaiseanta - Big5" },
            { "type.d0.npinyin", "\u00c0ireamhach" },
            { "type.nu.arabext", "\u00c0ireamhan Arabach-Innseanach leudaichte" },
            { "type.nu.armnlow", "\u00c0ireamhan beaga na h-Airmeinise" },
            { "type.nu.greklow", "\u00c0ireamhan beaga na Greugaise" },
            { "type.nu.hanidec", "\u00c0ireamhan deicheach na S\u00ecnise" },
            { "type.nu.hansfin", "\u00c0ireamhan ionmhasail na S\u00ecnise Shimplichte" },
            { "type.nu.hantfin", "\u00c0ireamhan ionmhasail na S\u00ecnise Thradaiseanta" },
            { "type.nu.jpanfin", "\u00c0ireamhan ionmhasail na Seapanaise" },
            { "type.nu.mathdbl", "\u00c0ireamhan matamataig le loidhne dh\u00f9bailte" },
            { "type.nu.tamldec", "\u00c0ireamhan na Taimilise" },
            { "type.ca.buddhist", "Am M\u00ecosachan Budach" },
            { "type.ca.ethiopic", "M\u00ecosachan na h-Itioipe" },
            { "type.ca.japanese", "Am M\u00ecosachan Seapanach" },
            { "type.cf.standard", "F\u00f2rmat stannardach an airgeadra" },
            { "type.co.searchjl", "Lorg leis a\u2019 chiad chonnrag Hangul" },
            { "type.co.standard", "\u00d2rdugh se\u00f2rsachaidh stannardach" },
            { "type.ms.uksystem", "Tomhas impireil" },
            { "type.ms.ussystem", "Tomhas nan St\u00e0itean Aonaichte" },
            { "type.nu.fullwide", "\u00c0ireamhan l\u00e0n-leud" },
            { "type.nu.lanatham", "\u00c0ireamhan Tai Tham Tham" },
            { "type.nu.mathbold", "\u00c0ireamhan matamataig troma" },
            { "type.nu.mathmono", "\u00c0ireamhan matamataig aon-leud" },
            { "type.nu.mathsanb", "\u00c0ireamhan matamataig sans-serif troma" },
            { "type.nu.mathsans", "\u00c0ireamhan matamataig sans-serif" },
            { "type.nu.mymrshan", "\u00c0ireamhan Shan Mi\u00e0nmar" },
            { "type.nu.mymrtlng", "\u00c0ireamhan Tai Laing Mi\u00e0nmar" },
            { "type.nu.romanlow", "\u00c0ireamhan beaga R\u00f2manach" },
            { "type.ca.gregorian", "Am M\u00ecosachan Griogarach" },
            { "type.co.gb2312han", "\u00d2rdugh se\u00f2rsachaidh na S\u00ecnise Simplichte - GB2312" },
            { "type.co.phonebook", "\u00d2rdugh se\u00f2rsachaidh nan leabhraichean-f\u00f2n" },
            { "type.co.dictionary", "\u00d2rdugh se\u00f2rsachaidh an fhaclair" },
            { "type.co.traditional", "\u00d2rdugh se\u00f2rsachaidh tradaiseanta" },
            { "type.ca.islamic-rgsa", "Am M\u00ecosachan Hijri (Ar\u00e0ibia nan Sabhd, sealladh)" },
            { "type.ca.islamic-tbla", "Am M\u00ecosachan Hijri (cl\u00e0rach, linn reul-e\u00f2lach)" },
            { "type.ca.islamic-civil", "Am M\u00ecosachan Hijri (cl\u00e0rach, linn s\u00ecobhalta)" },
            { "type.ca.islamic-umalqura", "Am M\u00ecosachan Hijri (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "M\u00ecosachan Itiopach Amete Alem" },
        };
        return data;
    }
}
