# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TableRow message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # A row in a table
    ##
    class TableRow < Message
      ##
      # The location of the first cell in the row
      ##
      attr_reader :location

      ##
      # Cells in the row
      ##
      attr_reader :cells

      attr_reader :id

      def initialize(
        location: Location.new,
        cells: [],
        id: ''
      )
        @location = location
        @cells = cells
        @id = id
        super()
      end

      ##
      # Returns a new TableRow from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TableRow.from_h(some_hash) # => #<Cucumber::Messages::TableRow:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          location: Location.from_h(hash[:location]),
          cells: hash[:cells]&.map { |item| TableCell.from_h(item) },
          id: hash[:id]
        )
      end
    end
  end
end
