# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestStepStarted message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class TestStepStarted < Message
      attr_reader :test_case_started_id

      attr_reader :test_step_id

      attr_reader :timestamp

      def initialize(
        test_case_started_id: '',
        test_step_id: '',
        timestamp: Timestamp.new
      )
        @test_case_started_id = test_case_started_id
        @test_step_id = test_step_id
        @timestamp = timestamp
        super()
      end

      ##
      # Returns a new TestStepStarted from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestStepStarted.from_h(some_hash) # => #<Cucumber::Messages::TestStepStarted:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          test_case_started_id: hash[:testCaseStartedId],
          test_step_id: hash[:testStepId],
          timestamp: Timestamp.from_h(hash[:timestamp])
        )
      end
    end
  end
end
