/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.storeconfig.StoreAppender;
import org.apache.catalina.storeconfig.StoreDescription;

public class StoreContextAppender
extends StoreAppender {
    @Override
    protected void printAttribute(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription, String string, Object object2, Object object3) {
        if (this.isPrintValue(object, object2, string, storeDescription)) {
            String string2;
            if (string.equals("docBase") && object instanceof StandardContext && (string2 = ((StandardContext)object).getOriginalDocBase()) != null) {
                object3 = string2;
            }
            this.printValue(printWriter, n, string, object3);
        }
    }

    @Override
    public boolean isPrintValue(Object object, Object object2, String string, StoreDescription storeDescription) {
        boolean bl = super.isPrintValue(object, object2, string, storeDescription);
        if (bl) {
            Container container;
            StandardContext standardContext = (StandardContext)object;
            if ("workDir".equals(string)) {
                String string2 = this.getDefaultWorkDir(standardContext);
                if (string2 != null) {
                    bl = !string2.equals(standardContext.getWorkDir());
                }
            } else if ("path".equals(string)) {
                bl = storeDescription.isStoreSeparate() && storeDescription.isExternalAllowed() && standardContext.getConfigFile() == null;
            } else if ("docBase".equals(string) && (container = standardContext.getParent()) instanceof StandardHost) {
                File file;
                File file2 = this.getAppBase((StandardHost)container);
                bl = !file2.equals((file = this.getDocBase(standardContext, file2)).getParentFile());
            }
        }
        return bl;
    }

    protected File getAppBase(StandardHost standardHost) {
        File file;
        File file2 = new File(standardHost.getAppBase());
        if (!file2.isAbsolute()) {
            file2 = new File(System.getProperty("catalina.base"), standardHost.getAppBase());
        }
        try {
            file = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file2;
        }
        return file;
    }

    protected File getDocBase(StandardContext standardContext, File file) {
        File file2;
        File file3;
        String string = standardContext.getOriginalDocBase();
        if (string == null) {
            string = standardContext.getDocBase();
        }
        if (!(file3 = new File(string)).isAbsolute()) {
            file3 = new File(file, string);
        }
        try {
            file2 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = file3;
        }
        return file2;
    }

    protected String getDefaultWorkDir(StandardContext standardContext) {
        Container container;
        String string = null;
        String string2 = standardContext.getName();
        if (string2.length() == 0) {
            string2 = "_";
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if ((container = standardContext.getParent()) instanceof StandardHost) {
            String string3 = ((StandardHost)container).getWorkDir();
            if (string3 != null) {
                string = string3 + File.separator + string2;
            } else {
                String string4 = standardContext.getParent().getParent().getName();
                String string5 = standardContext.getParent().getName();
                string = "work" + File.separator + string4 + File.separator + string5 + File.separator + string2;
            }
        }
        return string;
    }

    @Override
    public Object defaultInstance(Object object) throws ReflectiveOperationException {
        if (object instanceof StandardContext) {
            StandardContext standardContext = new StandardContext();
            return standardContext;
        }
        return super.defaultInstance(object);
    }
}

