/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u000b\u0010\u000b\u001a\u00070\u0006\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001aI\u0010\u000f\u001a\r\u0012\u0004\u0012\u00020\u00060\u0010\u00a2\u0006\u0002\b\u00112\u0017\u0010\u0012\u001a\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00152\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019\u001a0\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00100\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002\u001a\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006("}, d2={"FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT", "", "QODANA_PLUGINS_THIRD_PARTY_ACCEPT", "getQODANA_PLUGINS_THIRD_PARTY_ACCEPT$annotations", "()V", "THIRD_PARTY_PLUGINS_FILE", "", "thirdPartyPluginsNoteAccepted", "Ljava/lang/Boolean;", "findClassInPluginThatUsesCoreClassloader", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "className", "Lorg/jetbrains/annotations/NonNls;", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "message", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/Nls;", "key", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.CoreBundle", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/function/Supplier;", "prepareActions", "", "Lcom/intellij/openapi/util/text/HtmlChunk;", "pluginNamesToDisable", "", "pluginNamesToEnable", "readPluginIdsFromFile", "", "Lcom/intellij/openapi/extensions/PluginId;", "path", "Ljava/nio/file/Path;", "tryReadPluginIdsFromFile", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.core.impl"})
public final class PluginManagerCoreKt {
    private static final boolean QODANA_PLUGINS_THIRD_PARTY_ACCEPT = Boolean.getBoolean("idea.qodana.thirdpartyplugins.accept");
    private static final boolean FLEET_BACKEND_PLUGINS_THIRD_PARTY_ACCEPT = Boolean.getBoolean("fleet.backend.third-party.plugins.accept");

    private static final Supplier<String> message(String key, Object ... params) {
        return () -> PluginManagerCoreKt.message$lambda$0(key, params);
    }

    @NotNull
    public static final synchronized Set<PluginId> tryReadPluginIdsFromFile(@NotNull Path path, @NotNull Logger log2) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(log2, "log");
        try {
            return PluginManagerCoreKt.readPluginIdsFromFile(path);
        }
        catch (IOException e) {
            log2.warn("Unable to read plugin id list from: " + path, e);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized Set<PluginId> readPluginIdsFromFile(Path path) {
        try {
            AutoCloseable autoCloseable = Files.lines(path);
            Throwable throwable = null;
            try {
                Stream lines = (Stream)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNull(lines);
                Set<PluginId> set = SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(SequencesKt.map(StreamsKt.asSequence(lines), readPluginIdsFromFile.1.1.INSTANCE), readPluginIdsFromFile.1.2.INSTANCE), readPluginIdsFromFile.1.3.INSTANCE));
                return set;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        catch (NoSuchFileException _) {
            return SetsKt.emptySet();
        }
    }

    private static final String message$lambda$0(String $key, Object[] $params) {
        Intrinsics.checkNotNullParameter($params, "$params");
        String string2 = $key;
        Intrinsics.checkNotNull(string2);
        return CoreBundle.message(string2, Arrays.copyOf($params, $params.length));
    }

    public static final /* synthetic */ Supplier access$message(String key, Object ... params) {
        return PluginManagerCoreKt.message(key, params);
    }
}

