/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportOnAnnotationWithNonSourceRetention", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "declarationName", "", "isSpecialStaticProperty", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "Companion", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmAnnotationsTargetNonExistentAccessorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAnnotationsTargetNonExistentAccessorChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1863#2,2:88\n1863#2,2:90\n*S KotlinDebug\n*F\n+ 1 JvmAnnotationsTargetNonExistentAccessorChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker\n*L\n59#1:88,2\n65#1:90,2\n*E\n"})
public final class JvmAnnotationsTargetNonExistentAccessorChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<AnnotationUseSiteTarget> getterUselessTargets = SetsKt.setOf(AnnotationUseSiteTarget.PROPERTY_GETTER);
    @NotNull
    private static final Set<AnnotationUseSiteTarget> setterUselessTargets;

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        block17: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!(descriptor instanceof MemberDescriptor)) {
                return;
            }
            if (!(declaration instanceof KtParameter) && !(declaration instanceof KtProperty)) {
                return;
            }
            if (!DescriptorVisibilities.isPrivate(((MemberDescriptor)descriptor).getVisibility()) && !this.isSpecialStaticProperty((MemberDescriptor)descriptor)) {
                return;
            }
            if (!(declaration instanceof KtProperty)) ** GOTO lbl-1000
            v0 = ((KtProperty)declaration).getGetter();
            v1 = v0 != null ? v0.hasBody() : false;
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = hasGetterWithBody = false;
            }
            if (!(declaration instanceof KtProperty)) ** GOTO lbl-1000
            v3 = ((KtProperty)declaration).getSetter();
            v4 = v3 != null ? v3.hasBody() : false;
            if (v4) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = hasSetterWithBody = false;
            }
            if (hasGetterWithBody && hasSetterWithBody) {
                return;
            }
            if (declaration instanceof KtProperty && ((KtProperty)declaration).hasDelegate()) {
                return;
            }
            v6 = declaration.getName();
            if (v6 == null) {
                v7 = ((MemberDescriptor)descriptor).getName().asString();
                v6 = v7;
                Intrinsics.checkNotNullExpressionValue(v7, "asString(...)");
            }
            declarationName = v6;
            for (KtAnnotationEntry annotation : declaration.getAnnotationEntries()) {
                if (annotation.getUseSiteTarget() == null) continue;
                useSiteTarget = psiTarget.getAnnotationUseSiteTarget();
                if ((hasGetterWithBody || !JvmAnnotationsTargetNonExistentAccessorChecker.getterUselessTargets.contains((Object)useSiteTarget)) && (hasSetterWithBody || !JvmAnnotationsTargetNonExistentAccessorChecker.setterUselessTargets.contains((Object)useSiteTarget))) continue;
                Intrinsics.checkNotNull(annotation);
                this.reportOnAnnotationWithNonSourceRetention(annotation, declarationName, context);
            }
            if (!(declaration instanceof KtProperty)) break block17;
            if (!hasGetterWithBody) {
                v8 = ((KtProperty)declaration).getGetter();
                if (v8 != null && (v8 = v8.getAnnotationEntries()) != null) {
                    $this$forEach$iv = (Iterable)v8;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (KtAnnotationEntry)element$iv;
                        $i$a$-forEach-JvmAnnotationsTargetNonExistentAccessorChecker$check$1 = false;
                        Intrinsics.checkNotNull(it);
                        this.reportOnAnnotationWithNonSourceRetention(it, declarationName, context);
                    }
                }
            }
            if (!hasSetterWithBody) {
                v9 = ((KtProperty)declaration).getSetter();
                if (v9 != null && (v9 = v9.getAnnotationEntries()) != null) {
                    $this$forEach$iv = (Iterable)v9;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (KtAnnotationEntry)element$iv;
                        $i$a$-forEach-JvmAnnotationsTargetNonExistentAccessorChecker$check$2 = false;
                        Intrinsics.checkNotNull(it);
                        this.reportOnAnnotationWithNonSourceRetention(it, declarationName, context);
                    }
                }
            }
        }
    }

    private final void reportOnAnnotationWithNonSourceRetention(KtAnnotationEntry entry, String declarationName, DeclarationCheckerContext context) {
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.getTrace().get(BindingContext.ANNOTATION, entry);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor2);
        if ((classDescriptor != null ? DescriptorUtilsKt.getAnnotationRetention(classDescriptor) : null) == KotlinRetention.SOURCE) {
            return;
        }
        BindingTrace bindingTrace = context.getTrace();
        ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = ErrorsJvm.ANNOTATION_TARGETS_NON_EXISTENT_ACCESSOR.on((KtAnnotationEntry)((PsiElement)entry), declarationName);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
        DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
    }

    private final boolean isSpecialStaticProperty(MemberDescriptor descriptor) {
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor) || descriptor instanceof VariableDescriptor && ((VariableDescriptor)((Object)descriptor)).isConst();
    }

    static {
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.SETTER_PARAMETER};
        setterUselessTargets = SetsKt.setOf(annotationUseSiteTargetArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker$Companion;", "", "<init>", "()V", "getterUselessTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "setterUselessTargets", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

