/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.CheckUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.w3c.epubcheck.core.Checker;

public class OCFZipChecker
implements Checker {
    private final ValidationContext context;
    private final Report report;
    private final File zip;

    public OCFZipChecker(ValidationContext context) {
        this.context = context;
        this.report = context.report;
        this.zip = new File(context.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check() {
        FileInputStream epubIn = null;
        try {
            int readCount;
            epubIn = new FileInputStream(this.zip);
            byte[] header = new byte[58];
            if (readCount != -1) {
                int read;
                for (readCount = epubIn.read(header); readCount < header.length && (read = epubIn.read(header, readCount, header.length - readCount)) != -1; readCount += read) {
                }
            }
            if (readCount != header.length) {
                this.report.message(MessageId.PKG_003, EPUBLocation.of(this.context), new Object[0]);
            } else {
                int fnsize = OCFZipChecker.getIntFromBytes(header, 26);
                int extsize = OCFZipChecker.getIntFromBytes(header, 28);
                if (header[0] != 80 && header[1] != 75) {
                    this.report.message(MessageId.PKG_004, EPUBLocation.of(this.context), new Object[0]);
                } else if (fnsize != 8) {
                    this.report.message(MessageId.PKG_006, EPUBLocation.of(this.context), new Object[0]);
                } else if (extsize != 0) {
                    this.report.message(MessageId.PKG_005, EPUBLocation.of(this.context), extsize);
                } else if (!CheckUtil.checkString(header, 30, "mimetype")) {
                    this.report.message(MessageId.PKG_006, EPUBLocation.of(this.context), new Object[0]);
                } else if (!CheckUtil.checkString(header, 38, "application/epub+zip")) {
                    this.report.message(MessageId.PKG_007, EPUBLocation.of(this.context), new Object[0]);
                }
            }
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.of(this.context), e.getMessage());
        }
        finally {
            try {
                if (epubIn != null) {
                    epubIn.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static int getIntFromBytes(byte[] bytes, int offset) {
        int hi = 0xFF & bytes[offset + 1];
        int lo = 0xFF & bytes[offset];
        return hi << 8 | lo;
    }
}

