/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.TwoItemIterator;
import net.sf.saxon.value.Cardinality;

public final class CardinalityCheckingIterator
implements SequenceIterator {
    private final SequenceIterator base;
    private final Location locator;
    private Item first = null;
    private Item second = null;
    private int position = 0;

    public CardinalityCheckingIterator(SequenceIterator base, int requiredCardinality, RoleDiagnostic role, Location locator) throws XPathException {
        this.base = base;
        this.locator = locator;
        try {
            this.first = base.next();
            if (this.first == null) {
                if (!Cardinality.allowsZero(requiredCardinality)) {
                    this.typeError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
                }
            } else {
                if (requiredCardinality == 8192) {
                    this.typeError("The only value allowed for the " + role.getMessage() + " is an empty sequence", role.getErrorCode());
                }
                this.second = base.next();
                if (this.second != null && !Cardinality.allowsMany(requiredCardinality)) {
                    Item[] leaders = new Item[]{this.first, this.second};
                    this.typeError("A sequence of more than one item is not allowed as the " + role.getMessage() + CardinalityChecker.depictSequenceStart(new TwoItemIterator(this.first, this.second), 2), role.getErrorCode());
                }
            }
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public Item next() {
        if (this.position < 2) {
            if (this.position == 0) {
                Item current = this.first;
                this.position = this.first == null ? -1 : 1;
                return current;
            }
            if (this.position == 1) {
                Item current = this.second;
                this.position = this.second == null ? -1 : 2;
                return current;
            }
            return null;
        }
        Item nextBase = this.base.next();
        this.position = nextBase == null ? -1 : ++this.position;
        return nextBase;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public void discharge() {
        this.base.discharge();
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, errorCode, this.locator);
        e.setIsTypeError(!errorCode.startsWith("FORG"));
        throw e;
    }
}

