/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.jar.Manifest;
import sun.nio.ByteBuffered;

public abstract class Resource {
    private InputStream cis;

    public abstract String getName();

    public abstract URL getURL();

    public abstract URL getCodeSourceURL();

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength() throws IOException;

    private synchronized InputStream cachedInputStream() throws IOException {
        if (this.cis == null) {
            this.cis = this.getInputStream();
        }
        return this.cis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] b;
        int len;
        InputStream in = this.cachedInputStream();
        boolean isInterrupted = Thread.interrupted();
        while (true) {
            try {
                len = this.getContentLength();
            }
            catch (InterruptedIOException iioe) {
                Thread.interrupted();
                isInterrupted = true;
                continue;
            }
            break;
        }
        try {
            int cc;
            b = new byte[]{};
            if (len == -1) {
                len = Integer.MAX_VALUE;
            }
            for (int pos = 0; pos < len; pos += cc) {
                int bytesToRead;
                if (pos >= b.length) {
                    bytesToRead = Math.min(len - pos, b.length + 1024);
                    if (b.length < pos + bytesToRead) {
                        b = Arrays.copyOf(b, pos + bytesToRead);
                    }
                } else {
                    bytesToRead = b.length - pos;
                }
                cc = 0;
                try {
                    cc = in.read(b, pos, bytesToRead);
                }
                catch (InterruptedIOException iioe) {
                    Thread.interrupted();
                    isInterrupted = true;
                }
                if (cc >= 0) continue;
                if (len != Integer.MAX_VALUE) {
                    throw new EOFException("Detect premature EOF");
                }
                if (b.length != pos) {
                    b = Arrays.copyOf(b, pos);
                }
                break;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (InterruptedIOException iioe) {
                isInterrupted = true;
            }
            catch (IOException iOException) {}
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return b;
    }

    public ByteBuffer getByteBuffer() throws IOException {
        InputStream in = this.cachedInputStream();
        if (in instanceof ByteBuffered) {
            return ((ByteBuffered)((Object)in)).getByteBuffer();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public CodeSigner[] getCodeSigners() {
        return null;
    }
}

