"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDocumentColors = getDocumentColors;
exports.getColorRepresentations = getColorRepresentations;
const languageFacts = __importStar(require("./languageFacts.js"));
const util_js_1 = require("./util.js");
const colorMap = languageFacts.colors;
function getDocumentColors(doc, sourceFile) {
    const cs = sourceFile.colors;
    return cs ? colorTableToColorInformation(doc, sourceFile, cs) : undefined;
}
function getColorRepresentations(_doc, _sourceFile, color, range) {
    return !color || !range ? undefined : [{ label: `"${getColorStringFromColor(color)}"` }];
}
function colorTableToColorInformation(doc, sf, colors) {
    if (!colors || colors.size === 0)
        return [];
    const res = [];
    for (const [name, value] of colors) {
        if (!name || !value)
            continue;
        const color = getColorFromName(name);
        if (color) {
            res.push({
                range: (0, util_js_1.syntaxNodeToRange)(doc, sf, value.node),
                color,
            });
        }
    }
    return res;
}
function getColorFromName(name) {
    if (name.charAt(0) === "#")
        return getHexCodeColor(name);
    const colorAlias = colorMap[name.toLowerCase()];
    return colorAlias ? getHexCodeColor(colorAlias) : undefined;
}
function getHexCodeColor(colorCode) {
    const hexCode = colorCode.charAt(0) === "#" ? colorCode.substring(1) : colorCode;
    const colorInt = Number.parseInt(hexCode, 16);
    return {
        red: ((colorInt >> 16) & 0xff) / 255.0,
        green: ((colorInt >> 8) & 0xff) / 255.0,
        blue: (colorInt & 0xff) / 255.0,
        alpha: hexCode.length === 8 ? ((colorInt >> 24) & 0xff) / 255.0 : 1.0,
    };
}
function getColorStringFromColor(c) {
    const red = (c.red * 255) | 0;
    const green = (c.green * 255) | 0;
    const blue = (c.blue * 255) | 0;
    return `#${numberToPaddedString(red)}${numberToPaddedString(green)}${numberToPaddedString(blue)}`;
}
function numberToPaddedString(n) {
    const s = n.toString(16);
    return (s.length === 1 ? `0${s}` : s).toLowerCase();
}
//# sourceMappingURL=colorProvider.js.map