/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleQrcode
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<qrcode[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleQrcode() {
    }

    public static Command create() {
        return new CommandCreoleQrcode();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m4 = pattern.matcher(line);
        if (!m4.find()) {
            return 0;
        }
        return m4.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m4 = pattern.matcher(line);
        if (!m4.find()) {
            throw new IllegalStateException();
        }
        String src = m4.group(2);
        double scale = Parser.getScale(m4.group(3), 3.0);
        stripe.addQrcode(src, scale);
        return line.substring(m4.group(1).length());
    }
}

