/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.LabelPosition;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.draw.TaskDrawRegular;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class ResourceDrawVersion2
implements ResourceDraw {
    private final Resource res;
    private final TimeScale timeScale;
    private final double y;
    private final Day min;
    private final Day max;
    private final GanttDiagram gantt;

    public ResourceDrawVersion2(GanttDiagram gantt, Resource res, TimeScale timeScale, double y, Day min2, Day max) {
        this.res = res;
        this.timeScale = timeScale;
        this.y = y;
        this.min = min2;
        this.max = max;
        this.gantt = gantt;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double ypos = 16.0;
        double tmpHeight = this.getHeight(stringBounder) - ypos;
        Day wink = this.gantt.getStartingDate();
        while (wink.compareTo(this.gantt.getEndingDate()) <= 0) {
            double start = this.timeScale.getStartingPosition(wink);
            double end = this.timeScale.getEndingPosition(wink);
            URectangle rect = URectangle.build(end - start, tmpHeight);
            if (this.res.isClosedAt(wink)) {
                ug.apply(HColors.LIGHT_GRAY.bg()).apply(new UTranslate(start, ypos)).draw(rect);
            }
            wink = wink.increment();
        }
        TextBlock title = Display.getWithNewlines(this.gantt.getPragma(), this.res.getName()).create(this.getFontConfiguration(13), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        title.drawU(ug);
        ULine line = ULine.hline(this.timeScale.getEndingPosition(this.max) - this.timeScale.getStartingPosition(this.min));
        ug.apply(HColors.BLACK).apply(UTranslate.dy(title.calculateDimension(ug.getStringBounder()).getHeight())).draw(line);
        LabelStrategy labelStrategy = new LabelStrategy(LabelPosition.LEGACY, HorizontalAlignment.LEFT);
        for (TaskDrawRegular draw : this.gantt.getAllTasksForResource(this.res)) {
            draw.drawShape(ug.apply(UTranslate.dy(ypos + this.getTopMarginBetweenTask())));
            draw.drawTitle(ug.apply(UTranslate.dy(ypos + this.getTopMarginBetweenTask())), labelStrategy, 10.0, 100.0);
            ypos += draw.getShapeHeight(stringBounder) + this.getMarginBetweenTask();
        }
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        double ypos = 16.0;
        for (TaskDrawRegular draw : this.gantt.getAllTasksForResource(this.res)) {
            ypos += draw.getShapeHeight(stringBounder) + this.getMarginBetweenTask();
        }
        return ypos + 8.0;
    }

    private double getTopMarginBetweenTask() {
        return 2.0;
    }

    private double getMarginBetweenTask() {
        return 4.0;
    }

    private FontConfiguration getFontConfiguration(int size) {
        return this.getFontConfiguration(size, HColors.BLACK);
    }

    private FontConfiguration getFontConfiguration(int size, HColor color) {
        UFont font = UFont.serif(size);
        return FontConfiguration.create(font, color, color, null);
    }

    @Override
    public final double getY() {
        return this.y;
    }
}

