/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml.parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.yaml.parser.MonomorphType;

public class Monomorph {
    private MonomorphType type = MonomorphType.UNDETERMINATE;
    private String value;
    private List<Monomorph> list;
    private Map<String, Monomorph> map;

    public String toString() {
        switch (this.type) {
            case UNDETERMINATE: {
                return "???";
            }
            case SCALAR: {
                return this.getValue();
            }
            case LIST: {
                return this.list.toString();
            }
            case MAP: {
                return this.map.toString();
            }
        }
        return super.toString();
    }

    public void setValue(String value) {
        if (this.type == MonomorphType.LIST || this.type == MonomorphType.MAP) {
            throw new IllegalStateException();
        }
        this.value = value;
        this.list = null;
        this.map = null;
        this.type = MonomorphType.SCALAR;
    }

    public void addInList(Monomorph elementToBeAdded) {
        if (this.type == MonomorphType.UNDETERMINATE) {
            this.list = new ArrayList<Monomorph>();
            this.type = MonomorphType.LIST;
        } else if (this.type != MonomorphType.LIST) {
            throw new IllegalStateException("Monomorph is not of type LIST.");
        }
        this.list.add(elementToBeAdded);
    }

    public void putInMap(String key, Monomorph value) {
        if (this.type == MonomorphType.UNDETERMINATE) {
            this.map = new LinkedHashMap<String, Monomorph>();
            this.type = MonomorphType.MAP;
        } else if (this.type != MonomorphType.MAP) {
            throw new IllegalStateException("Monomorph is not of type MAP.");
        }
        this.map.put(key, value);
    }

    public MonomorphType getType() {
        return this.type;
    }

    public String getValue() {
        if (this.type != MonomorphType.SCALAR) {
            throw new IllegalStateException("Not a scalar value.");
        }
        return this.value;
    }

    public Monomorph getElementAt(int index) {
        if (this.type != MonomorphType.LIST) {
            throw new IllegalStateException("Not a list.");
        }
        return this.list.get(index);
    }

    public Monomorph getMapValue(String key) {
        if (this.type != MonomorphType.MAP) {
            throw new IllegalStateException("Not a map.");
        }
        return this.map.get(key);
    }

    public Set<String> keys() {
        if (this.type != MonomorphType.MAP) {
            throw new IllegalStateException("Not a map.");
        }
        return this.map.keySet();
    }

    public int size() {
        if (this.type == MonomorphType.LIST) {
            return this.list.size();
        }
        if (this.type == MonomorphType.MAP) {
            return this.map.size();
        }
        throw new IllegalStateException("Not a container type.");
    }

    public static Monomorph scalar(String value) {
        Monomorph result = new Monomorph();
        result.setValue(value);
        return result;
    }

    public static Monomorph list(List<String> input) {
        Monomorph result = new Monomorph();
        result.list = new ArrayList<Monomorph>();
        result.type = MonomorphType.LIST;
        for (String s2 : input) {
            result.addInList(Monomorph.scalar(s2));
        }
        return result;
    }
}

