<h2 align="center">Headless UI Float Vue</h2>

<p align="center">
  Easily use <a href="https://headlessui.com/">Headless UI</a> for Vue 3 with <a href="https://floating-ui.com/">Floating UI</a> (New version Popper.js) to position floating elements.
</p>

<p align="center">
  <a href="https://www.npmjs.com/package/@headlessui-float/vue"><img src="https://img.shields.io/npm/v/@headlessui-float/vue?style=flat-square" alt="NPM Version"></a>
  <a href="https://github.com/ycs77/headlessui-float/blob/main/packages/vue/LICENSE.md"><img src="https://img.shields.io/badge/license-MIT-brightgreen?style=flat-square" alt="Software License"></a>
  <a href="https://www.npmjs.com/package/@headlessui-float/vue"><img src="https://img.shields.io/npm/dt/@headlessui-float/vue?style=flat-square" alt="NPM Downloads"></a>
</p>

<hr>

> [!NOTE]
> [Headless UI](https://headlessui.com/) has [released version 2.0](https://tailwindcss.com/blog/headless-ui-v2#built-in-anchor-positioning) (currently for React only), which builds in anchor positioning with Floating UI. Therefore, this package will be unnecessary when Headless UI v2 supports Vue.

## Features

* 💙 Easily use Headless UI & Tailwind CSS
* 💬 Floating UI (New version Popper.js) position floating elements
* 🔔 Auto-update floating elements
* ♾️ Support Transition
* 🚪 Support Portal (Teleport)
* ➡️ Support Arrow

## Demo

[**Online Demo**](https://stackblitz.com/github/ycs77/headlessui-float/tree/main/examples/example-vue?file=src%2FApp.vue)

## Documentation

[Documentation](https://headlessui-float.vercel.app/) | [繁體中文文檔](https://headlessui-float.vercel.app/zh-tw/)

## Sponsor

If you think this package has helped you, please consider [Becoming a sponsor](https://www.patreon.com/ycs77) to support my work~ and your avatar will be visible on my major projects.

<p align="center">
  <a href="https://www.patreon.com/ycs77">
    <img src="https://cdn.jsdelivr.net/gh/ycs77/static/sponsors.svg"/>
  </a>
</p>

<a href="https://www.patreon.com/ycs77">
  <img src="https://c5.patreon.com/external/logo/become_a_patron_button.png" alt="Become a Patron" />
</a>

## Credits

* [Headless UI](https://headlessui.com/)
* [Floating UI](https://floating-ui.com/)
* This package is inspired by the [headlessui#154 example](https://github.com/tailwindlabs/headlessui/issues/154)

## License

Under the [MIT LICENSE](LICENSE.md)
