/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner;

import java.util.List;
import lombok.Generated;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.optimizer.LogicalPlanOptimizer;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.Table;

public class Planner {
    private final LogicalPlanOptimizer logicalOptimizer;

    public PhysicalPlan plan(LogicalPlan plan) {
        Table table = this.findTable(plan);
        if (table == null) {
            return (PhysicalPlan)plan.accept(new DefaultImplementor(), null);
        }
        return table.implement(table.optimize(this.optimize(plan)));
    }

    private Table findTable(LogicalPlan plan) {
        return plan.accept(new LogicalPlanNodeVisitor<Table, Object>(){

            @Override
            public Table visitNode(LogicalPlan node, Object context) {
                List<LogicalPlan> children = node.getChild();
                if (children.isEmpty()) {
                    return null;
                }
                return children.get(0).accept(this, context);
            }

            @Override
            public Table visitRelation(LogicalRelation node, Object context) {
                return node.getTable();
            }
        }, null);
    }

    private LogicalPlan optimize(LogicalPlan plan) {
        return this.logicalOptimizer.optimize(plan);
    }

    @Generated
    public Planner(LogicalPlanOptimizer logicalOptimizer) {
        this.logicalOptimizer = logicalOptimizer;
    }
}

