'''OpenGL extension EXT.draw_transform_feedback

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.draw_transform_feedback to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds the DrawTransformFeedback commands. These
	were omitted from OpenGL ES 3.0 because the number of vertices
	captured by transform feedback could never be different than
	the number drawn during capture. The addition of geometry shaders
	in OpenGL ES 3.2 broke that assumption but, due to an oversight,
	DrawTransformFeedback et al were not reinstated. The
	DrawTransformFeedback commands unlock the full potential of
	geometry shaders.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/draw_transform_feedback.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.draw_transform_feedback import *
from OpenGL.raw.GLES2.EXT.draw_transform_feedback import _EXTENSION_NAME

def glInitDrawTransformFeedbackEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION