import * as Models from '../../../models';
import { BroadcastAddress } from '../../../zspec/enums';
import * as Zcl from '../../../zspec/zcl';
import * as Zdo from '../../../zspec/zdo';
import * as ZdoTypes from '../../../zspec/zdo/definition/tstypes';
import Adapter from '../../adapter';
import * as Events from '../../events';
import { AdapterOptions, CoordinatorVersion, NetworkOptions, NetworkParameters, SerialPortOptions, StartResult } from '../../tstype';
export declare class DeconzAdapter extends Adapter {
    private driver;
    private openRequestsQueue;
    private transactionID;
    private frameParserEvent;
    private fwVersion?;
    private waitress;
    private TX_OPTIONS;
    private joinPermitted;
    constructor(networkOptions: NetworkOptions, serialPortOptions: SerialPortOptions, backupPath: string, adapterOptions: AdapterOptions);
    /**
     * Adapter methods
     */
    start(): Promise<StartResult>;
    stop(): Promise<void>;
    getCoordinatorIEEE(): Promise<string>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    getCoordinatorVersion(): Promise<CoordinatorVersion>;
    addInstallCode(ieeeAddress: string, key: Buffer, hashed: boolean): Promise<void>;
    reset(type: 'soft' | 'hard'): Promise<void>;
    waitFor(networkAddress: number | undefined, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<Events.ZclPayload>;
        cancel: () => void;
    };
    sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<Events.ZclPayload | void>;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress): Promise<void>;
    supportsBackup(): Promise<boolean>;
    backup(): Promise<Models.Backup>;
    getNetworkParameters(): Promise<NetworkParameters>;
    restoreChannelInterPAN(): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddr: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<Events.ZclPayload>;
    sendZclFrameInterPANBroadcastWithResponse(zclFrame: Zcl.Frame, timeout: number): Promise<Events.ZclPayload>;
    setChannelInterPAN(channel: number): Promise<void>;
    sendZclFrameInterPANIeeeAddr(zclFrame: Zcl.Frame, ieeeAddr: string): Promise<void>;
    /**
     * Private methods
     */
    private waitForData;
    private checkReceivedGreenPowerIndication;
    private checkReceivedDataPayload;
    private nextTransactionID;
    private waitressTimeoutFormatter;
    private waitressValidator;
}
//# sourceMappingURL=deconzAdapter.d.ts.map