// Copyright 2015, Tobias Hermann and the FunctionalPlus contributors.
// https://github.com/Dobiasd/FunctionalPlus
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt)

#pragma once

#include <chrono>

namespace fplus {

class stopwatch {
public:
    stopwatch()
        : beg_(clock::now())
    {
    }
    void reset() { beg_ = clock::now(); }

    // time since creation or last reset in seconds
    double elapsed() const
    {
        return std::chrono::duration_cast<second>(clock::now() - beg_).count();
    }

private:
    typedef std::chrono::high_resolution_clock clock;
    typedef std::chrono::duration<double, std::ratio<1>> second;
    std::chrono::time_point<clock> beg_;
};

} // namespace fplus
