"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Adapter = void 0;
const node_events_1 = __importDefault(require("node:events"));
const Zcl = __importStar(require("../zspec/zcl"));
const adapterDiscovery_1 = require("./adapterDiscovery");
class Adapter extends node_events_1.default.EventEmitter {
    hasZdoMessageOverhead;
    manufacturerID;
    networkOptions;
    adapterOptions;
    serialPortOptions;
    backupPath;
    constructor(networkOptions, serialPortOptions, backupPath, adapterOptions) {
        super();
        this.hasZdoMessageOverhead = true;
        this.manufacturerID = Zcl.ManufacturerCode.RESERVED_10;
        this.networkOptions = networkOptions;
        this.adapterOptions = adapterOptions;
        this.serialPortOptions = serialPortOptions;
        this.backupPath = backupPath;
    }
    /**
     * Utility
     */
    static async create(networkOptions, serialPortOptions, backupPath, adapterOptions) {
        const adapterLookup = {
            deconz: ['./deconz/adapter/deconzAdapter', 'DeconzAdapter'],
            ember: ['./ember/adapter/emberAdapter', 'EmberAdapter'],
            ezsp: ['./ezsp/adapter/ezspAdapter', 'EZSPAdapter'],
            zstack: ['./z-stack/adapter/zStackAdapter', 'ZStackAdapter'],
            zboss: ['./zboss/adapter/zbossAdapter', 'ZBOSSAdapter'],
            zigate: ['./zigate/adapter/zigateAdapter', 'ZiGateAdapter'],
        };
        const [adapter, path] = await (0, adapterDiscovery_1.discoverAdapter)(serialPortOptions.adapter, serialPortOptions.path);
        const detectedAdapter = adapterLookup[adapter];
        if (detectedAdapter) {
            serialPortOptions.adapter = adapter;
            serialPortOptions.path = path;
            const adapterModule = await Promise.resolve(`${detectedAdapter[0]}`).then(s => __importStar(require(s)));
            const AdapterCtor = adapterModule[detectedAdapter[1]];
            return new AdapterCtor(networkOptions, serialPortOptions, backupPath, adapterOptions);
        }
        else {
            throw new Error(`Adapter '${adapter}' does not exists, possible options: ${Object.keys(adapterLookup).join(', ')}`);
        }
    }
}
exports.Adapter = Adapter;
exports.default = Adapter;
//# sourceMappingURL=adapter.js.map