/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DelegatingDynamicMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

@JRubyClass(name={"Method"})
public class RubyMethod
extends AbstractRubyMethod {
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime2) {
        RubyClass methodClass = runtime2.defineClass("Method", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        methodClass.setClassIndex(ClassIndex.METHOD);
        methodClass.setReifiedClass(RubyMethod.class);
        methodClass.defineAnnotatedMethods(AbstractRubyMethod.class);
        methodClass.defineAnnotatedMethods(RubyMethod.class);
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, CacheEntry entry, IRubyObject receiver2) {
        Ruby runtime2 = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime2, runtime2.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.entry = entry;
        newMethod.method = entry.method;
        newMethod.sourceModule = entry.sourceModule;
        newMethod.receiver = receiver2;
        return newMethod;
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, Block block) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, block);
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject arg2, Block block) {
        arg2 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg2);
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        arg1 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg1);
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg0, arg1, block);
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        arg2 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg2);
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length > 0) {
            args2[args2.length - 1] = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, args2[args2.length - 1]);
        }
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, args2, block);
    }

    @Override
    @JRubyMethod
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getSignature().arityValue());
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context, this.equals(other));
    }

    @Override
    @JRubyMethod(name={"==="})
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, other, Block.NULL_BLOCK);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RubyMethod)) {
            return false;
        }
        if (this.method instanceof ProcMethod) {
            return ((ProcMethod)this.method).isSame(((RubyMethod)other).getMethod());
        }
        if (this.getMetaClass() != ((RubyBasicObject)other).getMetaClass()) {
            return false;
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return this.receiver == otherMethod.receiver && (this.isSerialMatch(otherMethod.method) || this.isMethodMissingMatch(otherMethod.getMethod().getRealMethod()));
    }

    private boolean isMethodMissingMatch(DynamicMethod other) {
        return this.method.getRealMethod() instanceof RubyModule.RespondToMissingMethod && ((RubyModule.RespondToMissingMethod)this.method.getRealMethod()).equals(other);
    }

    private boolean isSerialMatch(DynamicMethod otherMethod) {
        return this.method.getRealMethod().getSerialNumber() == otherMethod.getRealMethod().getSerialNumber();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCodeImpl());
    }

    @Override
    public int hashCode() {
        return (int)this.hashCodeImpl();
    }

    private long hashCodeImpl() {
        return (long)this.receiver.hashCode() * this.method.getRealMethod().getSerialNumber();
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        RubyMethod newMethod = RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry, this.receiver);
        newMethod.setMetaClass(this.getMetaClass());
        if (this.isFrozen()) {
            newMethod.setFrozen(true);
        }
        return newMethod;
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        Signature signature = this.method.getSignature();
        ArgumentDescriptor[] argsDesc = this.method instanceof IRMethodArgs ? ((IRMethodArgs)((Object)this.method)).getArgumentDescriptors() : Helpers.methodToArgumentDescriptors(this.method);
        int line = this.getLine();
        MethodBlockBody body = new MethodBlockBody(runtime2.getStaticScopeFactory().getDummyScope(), signature, this.entry, argsDesc, this.receiver, this.originModule, this.originName, this.getFilename(), line == -1 ? -1 : line - 1);
        Block b2 = MethodBlockBody.createMethodBlock(body);
        RubyProc proc2 = RubyProc.newProc(runtime2, b2, Block.Type.LAMBDA);
        proc2.setFromMethod();
        return proc2;
    }

    @JRubyMethod
    public RubyUnboundMethod unbind() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry);
        return unboundMethod;
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        RubyString str = RubyString.newString(runtime2, "#<");
        String sharp = "#";
        str.catString(this.getType().getName()).catString(": ");
        RubyModule mklass = this.originModule;
        RubyModule definedClass = this.method instanceof AliasMethod || this.method instanceof DelegatingDynamicMethod ? this.method.getRealMethod().getDefinedClass() : this.method.getDefinedClass();
        if (definedClass.isIncluded()) {
            definedClass = definedClass.getMetaClass();
        }
        if (mklass.isSingleton()) {
            RubyBasicObject attached = ((MetaClass)mklass).getAttached();
            if (this.receiver == null) {
                str.catWithCodeRange(RubyMethod.inspect(context, mklass).convertToString());
            } else if (this.receiver == attached) {
                str.catWithCodeRange(RubyMethod.inspect(context, attached).convertToString());
                sharp = ".";
            } else {
                str.catWithCodeRange(RubyMethod.inspect(context, this.receiver).convertToString());
                str.catString("(");
                str.catWithCodeRange(RubyMethod.inspect(context, attached).convertToString());
                str.catString(")");
                sharp = ".";
            }
        } else {
            if (this.receiver instanceof RubyClass) {
                str.catString("#<");
                str.cat(mklass.rubyName());
                str.catString(":");
                str.cat(((RubyClass)this.receiver).rubyName());
                str.catString(">");
            } else {
                str.cat(mklass.rubyName());
            }
            if (definedClass != mklass) {
                str.catString("(");
                str.cat(definedClass.rubyName());
                str.catString(")");
            }
        }
        str.catString(sharp);
        str.cat(runtime2.newSymbol(this.methodName).asString());
        if (!this.methodName.equals(this.method.getName())) {
            str.catString("(");
            str.cat(runtime2.newSymbol(this.method.getRealMethod().getName()).asString());
            str.catString(")");
        }
        if (this.method.isNotImplemented()) {
            str.catString(" (not-implemented)");
        }
        str.catString("(");
        ArgumentDescriptor[] descriptors = Helpers.methodToArgumentDescriptors(this.method);
        if (descriptors.length > 0) {
            RubyString desc = descriptors[0].asParameterName(context);
            boolean specialDots = false;
            if (descriptors.length == 3 && descriptors[0].type == ArgumentType.rest && "*".equals(descriptors[0].name.idString()) && descriptors[1].type == ArgumentType.keyrest && "**".equals(descriptors[1].name.idString()) && descriptors[2].type == ArgumentType.block && "&".equals(descriptors[2].name.idString())) {
                str.catString("...");
                specialDots = true;
            }
            if (!specialDots) {
                str.cat(desc);
                for (int i2 = 1; i2 < descriptors.length; ++i2) {
                    desc = descriptors[i2].asParameterName(context);
                    str.catString(", ");
                    str.cat(desc);
                }
            }
        }
        str.catString(")");
        String fileName = this.getFilename();
        if (fileName != null) {
            str.catString(" ");
            str.catString(fileName).cat(58).catString("" + this.getLine());
        }
        str.catString(">");
        return str;
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        return this.receiver;
    }

    @Override
    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        String filename2 = this.getFilename();
        if (filename2 != null) {
            return runtime2.newArray((IRubyObject)runtime2.newString(filename2), (IRubyObject)runtime2.newFixnum(this.getLine()));
        }
        return context.nil;
    }

    @Override
    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        return Helpers.methodToParameters(context.runtime, this);
    }

    @JRubyMethod
    public IRubyObject curry(ThreadContext context) {
        IRubyObject proc2 = this.to_proc(context);
        return RubyMethod.sites((ThreadContext)context).curry.call(context, proc2, proc2);
    }

    @JRubyMethod
    public IRubyObject curry(ThreadContext context, IRubyObject arg0) {
        IRubyObject proc2 = this.to_proc(context);
        return RubyMethod.sites((ThreadContext)context).curry.call(context, proc2, proc2, arg0);
    }

    @JRubyMethod
    public IRubyObject super_method(ThreadContext context) {
        RubyClass superClass = null;
        if (this.method instanceof PartialDelegatingMethod || this.method instanceof AliasMethod) {
            RubyModule definedClass = this.method.getRealMethod().getDefinedClass();
            RubyModule module = this.sourceModule.findImplementer(definedClass);
            if (module != null) {
                superClass = module.getSuperClass();
            }
        } else {
            superClass = this.sourceModule.getSuperClass();
        }
        return this.super_method(context, this.receiver, superClass);
    }

    @Override
    @JRubyMethod
    public IRubyObject original_name(ThreadContext context) {
        if (this.method instanceof AliasMethod) {
            return context.runtime.newSymbol(((AliasMethod)this.method).getOldName());
        }
        return this.name(context);
    }

    public IRubyObject getReceiver() {
        return this.receiver;
    }

    @Deprecated
    public IRubyObject curry(ThreadContext context, IRubyObject[] args2) {
        IRubyObject proc2 = this.to_proc(context);
        return RubyMethod.sites((ThreadContext)context).curry.call(context, proc2, proc2, args2);
    }

    private static JavaSites.MethodSites sites(ThreadContext context) {
        return context.sites.Method;
    }
}

