"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = void 0;
var _ismPlugin = _interopRequireDefault(require("./clusters/ism/ismPlugin"));
var _services = require("./services");
var _routes = require("../server/routes");
var _dataStreams = _interopRequireDefault(require("./routes/dataStreams"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class IndexPatternManagementPlugin {
  async setup(core, {
    dataSource
  }) {
    // create OpenSearch client that aware of ISM API endpoints
    const osDriver = core.opensearch.legacy.createClient("index_management", {
      plugins: [_ismPlugin.default]
    });
    const dataSourceEnabled = !!dataSource;

    // Initialize services
    const indexService = new _services.IndexService(osDriver, dataSourceEnabled);
    const dataStreamService = new _services.DataStreamService(osDriver, dataSourceEnabled);
    const policyService = new _services.PolicyService(osDriver, dataSourceEnabled);
    const managedIndexService = new _services.ManagedIndexService(osDriver, dataSourceEnabled);
    const rollupService = new _services.RollupService(osDriver, dataSourceEnabled);
    const transformService = new _services.TransformService(osDriver, dataSourceEnabled);
    const notificationService = new _services.NotificationService(osDriver, dataSourceEnabled);
    const snapshotManagementService = new _services.SnapshotManagementService(osDriver, dataSourceEnabled);
    const commonService = new _services.CommonService(osDriver, dataSourceEnabled);
    const aliasService = new _services.AliasServices(osDriver, dataSourceEnabled);
    const services = {
      indexService,
      dataStreamService,
      policyService,
      managedIndexService,
      rollupService,
      transformService,
      notificationService,
      snapshotManagementService,
      commonService,
      aliasService
    };
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_ismPlugin.default);
    }

    // create router
    const router = core.http.createRouter();

    // Add server routes
    (0, _routes.indices)(services, router, dataSourceEnabled);
    (0, _dataStreams.default)(services, router, dataSourceEnabled);
    (0, _routes.policies)(services, router, dataSourceEnabled);
    (0, _routes.managedIndices)(services, router, dataSourceEnabled);
    (0, _routes.rollups)(services, router, dataSourceEnabled);
    (0, _routes.transforms)(services, router, dataSourceEnabled);
    (0, _routes.notifications)(services, router, dataSourceEnabled);
    (0, _routes.snapshotManagement)(services, router, dataSourceEnabled);
    (0, _routes.common)(services, router, dataSourceEnabled);
    (0, _routes.aliases)(services, router, dataSourceEnabled);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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