/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import org.coode.mdock.ComponentNode;
import org.coode.mdock.ComponentPropertiesFactory;
import org.coode.mdock.HorizontalSplitterNode;
import org.coode.mdock.TraversalNodeVisitor;
import org.coode.mdock.VerticalSplitterNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SerialisationNodeVisitor
extends TraversalNodeVisitor {
    private Document doc;
    private Stack<Element> elementStack;
    private ComponentPropertiesFactory componentPropertiesFactory;

    public SerialisationNodeVisitor(Document doc, ComponentPropertiesFactory factory) {
        this.doc = doc;
        this.componentPropertiesFactory = factory;
        this.elementStack = new Stack();
        Element element = doc.createElement("layout");
        doc.appendChild(element);
        this.elementStack.push(element);
    }

    @Override
    public void visit(ComponentNode componentNode) {
        super.visit(componentNode);
        Element element = this.doc.createElement("CNode");
        this.elementStack.peek().appendChild(element);
        for (JComponent component : componentNode.getComponents()) {
            Element componentElement = this.doc.createElement("Component");
            element.appendChild(componentElement);
            componentElement.setAttribute("label", componentNode.getLabel(component));
            Map<String, String> properties = this.getProperties(component);
            for (String key : properties.keySet()) {
                Element propertyElement = this.doc.createElement("Property");
                componentElement.appendChild(propertyElement);
                propertyElement.setAttribute("id", key);
                propertyElement.setAttribute("value", properties.get(key));
            }
        }
    }

    @Override
    public void visit(VerticalSplitterNode verticalSplitterNode) {
        Element element = this.doc.createElement("VSNode");
        element.setAttribute("splits", this.getSplitAttributeValue(verticalSplitterNode.getSplits()));
        this.elementStack.peek().appendChild(element);
        this.elementStack.push(element);
        super.visit(verticalSplitterNode);
        this.elementStack.pop();
    }

    @Override
    public void visit(HorizontalSplitterNode horizontalSplitterNode) {
        Element element = this.doc.createElement("HSNode");
        element.setAttribute("splits", this.getSplitAttributeValue(horizontalSplitterNode.getSplits()));
        this.elementStack.peek().appendChild(element);
        this.elementStack.push(element);
        super.visit(horizontalSplitterNode);
        this.elementStack.pop();
    }

    protected Map<String, String> getProperties(JComponent component) {
        return this.componentPropertiesFactory.getProperties(component);
    }

    private String getSplitAttributeValue(List<Double> splits) {
        StringBuilder sb = new StringBuilder();
        for (double d : splits) {
            sb.append(d);
            sb.append(" ");
        }
        return sb.toString().trim();
    }
}

