## Module#class_extend

    require 'facets/module/class_extend'

Module using class_extend

    mix = Module.new do
      def i ; end
      class_extend do
        def n ; 42   ; end
        def s ; self ; end
      end
    end

Extends module

    mix.n.assert == 42
    mix.s.assert == mix

Has expected methods

    mix.instance_methods.map{ |m| m.to_s }.assert == ['i']

transfers class methods to including class

    mod = Module.new do
      include mix
    end
    mod.n.assert == 42
    mod.s.assert == mod

Doesn't overwrite instance methods

    c = Class.new do
      include mix
      def n ; 11 ; end
    end
    c.new.n.assert == 11

Is overridable via including module

    mod = Module.new do
      include mix
      class_extend do
        def n ; super + 1 ; end
      end
    end
    mod.n.assert == 43  # notice the difference!
    mod.s.assert == mod

Transfers class methods thru multiple levels of include

    alt = Module.new do
      include mix
      class_extend do
        def n ; super + 1 ; end
      end
    end
    mod = Module.new do
      include alt
    end
    mod.n.assert == 43
    mod.s.assert == mod

