# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_apt_swarm_global_optspecs
	string join \n v/verbose q/quiet c/config= proxy= data-path= C/colors h/help V/version
end

function __fish_apt_swarm_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_apt_swarm_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_apt_swarm_using_subcommand
	set -l cmd (__fish_apt_swarm_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -s V -l version -d 'Print version'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "import" -d 'Import signed InRelease files'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "export" -d 'Export all known InRelease files'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "fetch" -d 'Fetch the latest InRelease files and import them'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "ls" -d 'List hashes of all known releases'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "keyring" -d 'List all keys currently configured for monitoring'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "pull" -d 'Connect to a remote node and sync from them'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "p2p" -d 'Run in p2p swarm mode'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "plumbing" -d 'Access to low-level features'
complete -c apt-swarm -n "__fish_apt_swarm_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand import" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand import" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand import" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand import" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand import" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand import" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand import" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -l scan -d 'Instead of exact matches, scan with the given prefix(es)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand export" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -s j -l concurrency -d 'Number of concurrent requests' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand fetch" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -s s -l count -d 'Count keys present in database instead of listing them'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand ls" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -l json -d 'Output keyring as json'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -s s -l stats -d 'Show the number of known signatures for a given subkey'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand keyring" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -l key -d 'Only sync data for specific keys, identified by their fingerprint' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -s n -l dry-run -d 'Run the sync but do not import'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand pull" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l irc-channel -d 'The irc server and channel to connect to' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l dns -d 'The dns names to query for bootstrapping' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -s B -l bind -d 'The addresses to bind a sync port for p2p traffic (if not disabled)' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -s A -l announce -d 'Configure addresses to announce if somebody wants to sync from us' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l check-container-updates -d 'Monitor a container registry for updates and terminate if an update is available (eg. ghcr.io/kpcyrd/apt-swarm:edge)' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l update-assume-commit -d 'The VCS commit to assume for our currently running image' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l no-irc -d 'Do not connect to irc for peer discovery'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l no-dns -d 'Do not query any configured dnsseeds'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l no-bootstrap -d 'Do not use any bootstrapping mechanism, initial peers need to be added manually'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l no-fetch -d 'Do not actively fetch updates from the configured repositories'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -l no-bind -d 'Do not bind a sync port for p2p traffic'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand p2p" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "attach-sig" -d 'Create a clear-signed document from a detached signature'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "canonicalize" -d 'Transform a signed InRelease file into a canonical representation'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "completions" -d 'Generate shell completions'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "config" -d 'Print applied configuration'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "container-update-check" -d 'Query a container registry for a more recent release of a given image'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "db-server" -d 'Bind a unix domain socket and allow abstract database access from multiple processes'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "dns-bootstrap" -d 'Run dns bootstrap query, print results'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "fingerprint" -d 'Extract the fingerprint of a pgp key'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "fsck" -d 'Verify stored objects'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "git-object" -d 'Convert signed git objects into signature format used by apt-swarm'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "git-scrape" -d 'Attempt to export all signed objects from a git repo'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "index" -d 'Scan the database and calculate the requested index'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "migrate" -d 'Open a fresh database and re-import the old data'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "paths" -d 'Print configured paths'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "peerdb-add" -d 'Add a peerdb entry'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "peerdb-list" -d 'Read and print peerdb file'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "sync-pull" -d 'Fetch all available signatures over stdio (use with sync-yield)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "sync-yield" -d 'Provide access to our signatures over stdio (use with sync-pull)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and not __fish_seen_subcommand_from attach-sig canonicalize completions config container-update-check db-server dns-bootstrap fingerprint fsck git-object git-scrape index migrate paths peerdb-add peerdb-list sync-pull sync-yield help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from attach-sig" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from attach-sig" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from attach-sig" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from attach-sig" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from attach-sig" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from attach-sig" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from attach-sig" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -l verify -d 'Verify signatures belong to trusted key in keyring'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from canonicalize" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from completions" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from completions" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from completions" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from completions" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from completions" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from completions" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from completions" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from config" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from config" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from config" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from config" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from config" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from config" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from config" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -l image -d 'The image to monitor for updates (eg. ghcr.io/kpcyrd/apt-swarm:edge)' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -l commit -d 'The commit to assume for our currently running image' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from container-update-check" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from db-server" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from db-server" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from db-server" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from db-server" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from db-server" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from db-server" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from db-server" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -s 4 -l ipv4-only -d 'Only print ipv4 records'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -s 6 -l ipv6-only -d 'Only print ipv6 records'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from dns-bootstrap" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fingerprint" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fingerprint" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fingerprint" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fingerprint" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fingerprint" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fingerprint" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fingerprint" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fsck" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fsck" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fsck" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fsck" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fsck" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fsck" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from fsck" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -s k -l kind -r -f -a "commit\t''
tag\t''"
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-object" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-scrape" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-scrape" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-scrape" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-scrape" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-scrape" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-scrape" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from git-scrape" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -s b -l batch -d 'Calculate a batch index, they are bigger but allow syncs with fewer round-trips'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from index" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from migrate" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from migrate" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from migrate" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from migrate" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from migrate" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from migrate" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from migrate" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from paths" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from paths" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from paths" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from paths" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from paths" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from paths" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from paths" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-add" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-add" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-add" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-add" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-add" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-add" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-add" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-list" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-list" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-list" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-list" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-list" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-list" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from peerdb-list" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -s n -l dry-run -d 'Run the sync but do not import'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-pull" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-yield" -s c -l config -d 'Path to config file to use' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-yield" -l proxy -d 'Configure a socks5 proxy for outgoing connections' -r
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-yield" -l data-path -d 'Configure the path where persistent data should be stored' -r -F
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-yield" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-yield" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-yield" -s C -l colors -d 'Always enable colored output'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from sync-yield" -s h -l help -d 'Print help'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "attach-sig" -d 'Create a clear-signed document from a detached signature'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "canonicalize" -d 'Transform a signed InRelease file into a canonical representation'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "completions" -d 'Generate shell completions'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "config" -d 'Print applied configuration'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "container-update-check" -d 'Query a container registry for a more recent release of a given image'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "db-server" -d 'Bind a unix domain socket and allow abstract database access from multiple processes'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "dns-bootstrap" -d 'Run dns bootstrap query, print results'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "fingerprint" -d 'Extract the fingerprint of a pgp key'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "fsck" -d 'Verify stored objects'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "git-object" -d 'Convert signed git objects into signature format used by apt-swarm'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "git-scrape" -d 'Attempt to export all signed objects from a git repo'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "index" -d 'Scan the database and calculate the requested index'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "migrate" -d 'Open a fresh database and re-import the old data'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "paths" -d 'Print configured paths'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "peerdb-add" -d 'Add a peerdb entry'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "peerdb-list" -d 'Read and print peerdb file'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "sync-pull" -d 'Fetch all available signatures over stdio (use with sync-yield)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "sync-yield" -d 'Provide access to our signatures over stdio (use with sync-pull)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand plumbing; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "import" -d 'Import signed InRelease files'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "export" -d 'Export all known InRelease files'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "fetch" -d 'Fetch the latest InRelease files and import them'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "ls" -d 'List hashes of all known releases'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "keyring" -d 'List all keys currently configured for monitoring'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "pull" -d 'Connect to a remote node and sync from them'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "p2p" -d 'Run in p2p swarm mode'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "plumbing" -d 'Access to low-level features'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and not __fish_seen_subcommand_from import export fetch ls keyring pull p2p plumbing help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "attach-sig" -d 'Create a clear-signed document from a detached signature'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "canonicalize" -d 'Transform a signed InRelease file into a canonical representation'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "completions" -d 'Generate shell completions'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "config" -d 'Print applied configuration'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "container-update-check" -d 'Query a container registry for a more recent release of a given image'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "db-server" -d 'Bind a unix domain socket and allow abstract database access from multiple processes'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "dns-bootstrap" -d 'Run dns bootstrap query, print results'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "fingerprint" -d 'Extract the fingerprint of a pgp key'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "fsck" -d 'Verify stored objects'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "git-object" -d 'Convert signed git objects into signature format used by apt-swarm'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "git-scrape" -d 'Attempt to export all signed objects from a git repo'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "index" -d 'Scan the database and calculate the requested index'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "migrate" -d 'Open a fresh database and re-import the old data'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "paths" -d 'Print configured paths'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "peerdb-add" -d 'Add a peerdb entry'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "peerdb-list" -d 'Read and print peerdb file'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "sync-pull" -d 'Fetch all available signatures over stdio (use with sync-yield)'
complete -c apt-swarm -n "__fish_apt_swarm_using_subcommand help; and __fish_seen_subcommand_from plumbing" -f -a "sync-yield" -d 'Provide access to our signatures over stdio (use with sync-pull)'
