import * as languageFacts from "./languageFacts.js";
import { syntaxNodeToRange } from "./util.js";
const colorMap = languageFacts.colors;
export function getDocumentColors(doc, sourceFile) {
    const cs = sourceFile.colors;
    return cs ? colorTableToColorInformation(doc, sourceFile, cs) : undefined;
}
export function getColorRepresentations(_doc, _sourceFile, color, range) {
    return !color || !range ? undefined : [{ label: `"${getColorStringFromColor(color)}"` }];
}
function colorTableToColorInformation(doc, sf, colors) {
    if (!colors || colors.size === 0)
        return [];
    const res = [];
    for (const [name, value] of colors) {
        if (!name || !value)
            continue;
        const color = getColorFromName(name);
        if (color) {
            res.push({
                range: syntaxNodeToRange(doc, sf, value.node),
                color,
            });
        }
    }
    return res;
}
function getColorFromName(name) {
    if (name.charAt(0) === "#")
        return getHexCodeColor(name);
    const colorAlias = colorMap[name.toLowerCase()];
    return colorAlias ? getHexCodeColor(colorAlias) : undefined;
}
function getHexCodeColor(colorCode) {
    const hexCode = colorCode.charAt(0) === "#" ? colorCode.substring(1) : colorCode;
    const colorInt = Number.parseInt(hexCode, 16);
    return {
        red: ((colorInt >> 16) & 0xff) / 255.0,
        green: ((colorInt >> 8) & 0xff) / 255.0,
        blue: (colorInt & 0xff) / 255.0,
        alpha: hexCode.length === 8 ? ((colorInt >> 24) & 0xff) / 255.0 : 1.0,
    };
}
function getColorStringFromColor(c) {
    const red = (c.red * 255) | 0;
    const green = (c.green * 255) | 0;
    const blue = (c.blue * 255) | 0;
    return `#${numberToPaddedString(red)}${numberToPaddedString(green)}${numberToPaddedString(blue)}`;
}
function numberToPaddedString(n) {
    const s = n.toString(16);
    return (s.length === 1 ? `0${s}` : s).toLowerCase();
}
//# sourceMappingURL=colorProvider.js.map