/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.features.progress.mindmapmode.ProgressUtilities;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

class ExternalImagePopupMenu
extends JPopupMenu
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private NodeModel node = null;
    private ViewerController viewer = null;
    private JMenuItem remove = null;
    private JMenuItem change = null;
    private JMenuItem open = null;
    private JMenuItem resetZoom = null;
    private NodeModel selectionRoot;

    ExternalImagePopupMenu() {
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
    }

    private JMenuItem getRemove() {
        final ProgressUtilities progUtil = new ProgressUtilities();
        if (this.remove == null) {
            this.remove = new JMenuItem(TextUtils.getText("ExternalImage_popupMenu_Remove"));
            this.remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (progUtil.hasExternalResource(ExternalImagePopupMenu.this.node) && !progUtil.hasExtendedProgressIcon(ExternalImagePopupMenu.this.node)) {
                        ExternalImagePopupMenu.this.viewer.undoableDeactivateHook(ExternalImagePopupMenu.this.node);
                        Controller.getCurrentModeController().getMapController().nodeChanged(ExternalImagePopupMenu.this.node, NodeModel.UNKNOWN_PROPERTY, null, null);
                    }
                }
            });
        }
        return this.remove;
    }

    private JMenuItem getOpen() {
        if (this.open == null) {
            this.open = new JMenuItem(TextUtils.getText("ExternalImage_popupMenu_Open"));
            this.open.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExternalResource extRes = ExternalImagePopupMenu.this.node.getExtension(ExternalResource.class);
                    if (extRes == null) {
                        return;
                    }
                    UrlManager urlManager = Controller.getCurrentModeController().getExtension(UrlManager.class);
                    urlManager.loadHyperlink(new Hyperlink(extRes.getUri()));
                }
            });
        }
        return this.open;
    }

    private JMenuItem getChange() {
        final ProgressUtilities progUtil = new ProgressUtilities();
        if (this.change == null) {
            this.change = new JMenuItem(TextUtils.getText("ExternalImage_popupMenu_Change"));
            this.change.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExternalResource extRes = (ExternalResource)ExternalImagePopupMenu.this.viewer.createExtension(ExternalImagePopupMenu.this.node);
                    if (extRes != null) {
                        URI uri = extRes.getAbsoluteUri(ExternalImagePopupMenu.this.node.getMap());
                        if (progUtil.hasExternalResource(ExternalImagePopupMenu.this.node) && !progUtil.hasExtendedProgressIcon(ExternalImagePopupMenu.this.node)) {
                            ExternalImagePopupMenu.this.viewer.undoableDeactivateHook(ExternalImagePopupMenu.this.node);
                            ExternalImagePopupMenu.this.viewer.paste(uri, ExternalImagePopupMenu.this.node);
                        }
                    }
                }
            });
        }
        return this.change;
    }

    private JMenuItem getResetZoom() {
        this.resetZoom = new JMenuItem(TextUtils.getText("ExternalImage_popupMenu_ResetZoom"));
        final ExternalResource extRes = this.node.getExtension(ExternalResource.class);
        if (extRes != null && extRes.getZoom() != 1.0f) {
            this.resetZoom.setEnabled(true);
        } else {
            this.resetZoom.setEnabled(false);
        }
        this.resetZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalImagePopupMenu.this.viewer.setZoom(Controller.getCurrentController().getModeController(), ExternalImagePopupMenu.this.node.getMap(), extRes, 1.0f);
            }
        });
        return this.resetZoom;
    }

    private void make() {
        ProgressUtilities progUtil = new ProgressUtilities();
        if (progUtil.hasExtendedProgressIcon(this.node)) {
            this.removeAll();
            this.add(this.getOpen());
            this.add(this.getResetZoom());
        } else {
            this.removeAll();
            this.add(this.getRemove());
            this.add(this.getChange());
            this.add(this.getOpen());
            this.add(this.getResetZoom());
        }
    }

    protected void maybeShowPopup(MouseEvent e) {
        MainView mv = null;
        if (e.isPopupTrigger()) {
            for (Component cmp : e.getComponent().getParent().getComponents()) {
                if (!(cmp instanceof MainView)) continue;
                mv = (MainView)cmp;
                NodeView nodeView = mv.getNodeView();
                this.selectionRoot = nodeView.getMap().getRoot().getNode();
                this.node = nodeView.getNode();
                this.viewer = Controller.getCurrentController().getModeController().getExtension(ViewerController.class);
                break;
            }
            this.make();
            this.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }
}

