/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.SharpEdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class SharpLinearEdgeView
extends SharpEdgeView {
    public SharpLinearEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    @Override
    public Stroke getStroke() {
        return this.getStroke(0.0f);
    }

    @Override
    protected void draw(Graphics2D g) {
        g.setColor(this.getColor());
        g.setPaint(this.getColor());
        g.setStroke(this.getStroke());
        int deltaX = this.getDeltaX();
        int deltaY = this.getDeltaY();
        int[] xs = new int[]{this.start.x + deltaX, this.end.x, this.start.x - deltaX};
        int[] ys = new int[]{this.start.y + deltaY, this.end.y, this.start.y - deltaY};
        g.fillPolygon(xs, ys, 3);
    }

    @Override
    public boolean detectCollision(Point p) {
        int w = this.getMap().getZoomed(this.getWidth() / 2 + 1);
        int[] xs = new int[]{this.start.x, this.end.x, this.start.x};
        int[] ys = new int[]{this.start.y + w, this.end.y, this.start.y - w};
        Polygon polygon = new Polygon(xs, ys, 3);
        return new CollisionDetector().detectCollision(p, polygon);
    }
}

