/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AddPrimitivesCommand
extends Command {
    private List<PrimitiveData> data;
    private Collection<PrimitiveData> toSelect;
    private List<PrimitiveData> preExistingData;
    private List<OsmPrimitive> createdPrimitives;

    public AddPrimitivesCommand(List<PrimitiveData> data, List<PrimitiveData> toSelect, DataSet ds) {
        super(ds);
        this.init(data, toSelect);
    }

    public AddPrimitivesCommand(List<PrimitiveData> data, DataSet ds) {
        this(data, data, ds);
    }

    private void init(List<PrimitiveData> data, List<PrimitiveData> toSelect) {
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        this.data = new ArrayList<PrimitiveData>(data);
        if (toSelect == data) {
            this.toSelect = this.data;
        } else if (toSelect != null) {
            this.toSelect = new ArrayList<PrimitiveData>(toSelect);
        }
    }

    @Override
    public boolean executeCommand() {
        DataSet ds = this.getAffectedDataSet();
        ds.update(() -> this.executeRealCommand(ds));
        if (this.toSelect != null) {
            ds.setSelected(this.toSelect.stream().map(ds::getPrimitiveById).collect(Collectors.toList()));
        }
        return true;
    }

    private void executeRealCommand(DataSet ds) {
        if (this.createdPrimitives == null) {
            ArrayList<OsmPrimitive> newPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
            this.preExistingData = new ArrayList<PrimitiveData>();
            for (PrimitiveData pd2 : this.data) {
                boolean created;
                OsmPrimitive primitive = ds.getPrimitiveById(pd2);
                boolean bl = created = primitive == null;
                if (primitive == null) {
                    primitive = pd2.getType().newInstance(pd2.getUniqueId(), true);
                } else {
                    this.preExistingData.add(primitive.save());
                }
                if (pd2 instanceof NodeData) {
                    primitive.load(pd2);
                }
                if (created) {
                    ds.addPrimitive(primitive);
                }
                newPrimitives.add(primitive);
            }
            for (int i = 0; i < newPrimitives.size(); ++i) {
                if (newPrimitives.get(i) instanceof Node) continue;
                ((OsmPrimitive)newPrimitives.get(i)).load(this.data.get(i));
            }
            newPrimitives.forEach(p -> p.setModified(true));
        } else {
            for (OsmPrimitive osm : this.createdPrimitives) {
                if (this.preExistingData.stream().anyMatch(pd -> pd.getPrimitiveId().equals(osm.getPrimitiveId()))) {
                    Optional<PrimitiveData> o = this.data.stream().filter(pd -> pd.getPrimitiveId().equals(osm.getPrimitiveId())).findAny();
                    o.ifPresent(osm::load);
                    continue;
                }
                ds.addPrimitive(osm);
            }
        }
    }

    @Override
    public void undoCommand() {
        DataSet ds = this.getAffectedDataSet();
        if (this.createdPrimitives == null) {
            this.createdPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
            for (PrimitiveData pd : this.data) {
                OsmPrimitive p = ds.getPrimitiveById(pd);
                this.createdPrimitives.add(p);
            }
            this.createdPrimitives = PurgeCommand.topoSort(this.createdPrimitives);
        }
        ArrayList<PrimitiveId> toRemove = new ArrayList<PrimitiveId>(this.createdPrimitives.size());
        ds.update(() -> {
            for (int i = this.createdPrimitives.size() - 1; i >= 0; --i) {
                OsmPrimitive osm = this.createdPrimitives.get(i);
                Optional<PrimitiveData> previous = this.preExistingData.stream().filter(pd -> pd.getPrimitiveId().equals(osm.getPrimitiveId())).findAny();
                if (previous.isPresent()) {
                    osm.load(previous.get());
                    continue;
                }
                toRemove.add(osm);
            }
        });
        ds.removePrimitives(toRemove);
    }

    @Override
    public String getDescriptionText() {
        int size = this.data != null ? this.data.size() : this.createdPrimitives.size();
        return I18n.trn("Added {0} object", "Added {0} objects", size, size);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        if (this.createdPrimitives != null) {
            return this.createdPrimitives;
        }
        return this.data.stream().map(d -> Objects.requireNonNull(this.getAffectedDataSet().getPrimitiveById((PrimitiveId)d), () -> "No primitive found for " + d)).collect(Collectors.toSet());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data, this.toSelect, this.preExistingData, this.createdPrimitives);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AddPrimitivesCommand that = (AddPrimitivesCommand)obj;
        return Objects.equals(this.data, that.data) && Objects.equals(this.toSelect, that.toSelect) && Objects.equals(this.preExistingData, that.preExistingData) && Objects.equals(this.createdPrimitives, that.createdPrimitives);
    }
}

