/*
Copyright (c) 2014, Ronnie Sahlberg
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "libnfs-zdr.h"
#include "libnfs-raw-mount.h"

uint32_t
zdr_fhandle3 (ZDR *zdrs, fhandle3 *objp)
{
	 if (!zdr_bytes (zdrs, (char **)&objp->fhandle3_val, (uint32_t *) &objp->fhandle3_len, FHSIZE3))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_dirpath (ZDR *zdrs, dirpath *objp)
{
	 if (!zdr_string (zdrs, objp, MNTPATHLEN))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_name (ZDR *zdrs, name *objp)
{
	 if (!zdr_string (zdrs, objp, MNTNAMLEN))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mountstat3 (ZDR *zdrs, mountstat3 *objp)
{
	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mountlist (ZDR *zdrs, mountlist *objp)
{
	 if (!zdr_pointer (zdrs, (char **)objp, sizeof (struct mountbody), (zdrproc_t) zdr_mountbody))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mountbody (ZDR *zdrs, mountbody *objp)
{
	 if (!zdr_name (zdrs, &objp->ml_hostname))
		 return FALSE;
	 if (!zdr_dirpath (zdrs, &objp->ml_directory))
		 return FALSE;
	 if (!zdr_mountlist (zdrs, &objp->ml_next))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_groups (ZDR *zdrs, groups *objp)
{
	 if (!zdr_pointer (zdrs, (char **)objp, sizeof (struct groupnode), (zdrproc_t) zdr_groupnode))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_groupnode (ZDR *zdrs, groupnode *objp)
{
	 if (!zdr_name (zdrs, &objp->gr_name))
		 return FALSE;
	 if (!zdr_groups (zdrs, &objp->gr_next))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_exports (ZDR *zdrs, exports *objp)
{
	 if (!zdr_pointer (zdrs, (char **)objp, sizeof (struct exportnode), (zdrproc_t) zdr_exportnode))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_exportnode (ZDR *zdrs, exportnode *objp)
{
	 if (!zdr_dirpath (zdrs, &objp->ex_dir))
		 return FALSE;
	 if (!zdr_groups (zdrs, &objp->ex_groups))
		 return FALSE;
	 if (!zdr_exports (zdrs, &objp->ex_next))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mountres3_ok (ZDR *zdrs, mountres3_ok *objp)
{
	 if (!zdr_fhandle3 (zdrs, &objp->fhandle))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->auth_flavors.auth_flavors_val, (uint32_t *) &objp->auth_flavors.auth_flavors_len, ~0,
		sizeof (int), (zdrproc_t) zdr_int))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mountres3 (ZDR *zdrs, mountres3 *objp)
{
	 if (!zdr_mountstat3 (zdrs, &objp->fhs_status))
		 return FALSE;
	switch (objp->fhs_status) {
	case MNT3_OK:
		 if (!zdr_mountres3_ok (zdrs, &objp->mountres3_u.mountinfo))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_mountstat1 (ZDR *zdrs, mountstat1 *objp)
{
	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fhandle1 (ZDR *zdrs, fhandle1 objp)
{
	 if (!zdr_opaque (zdrs, objp, FHSIZE))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mountres1_ok (ZDR *zdrs, mountres1_ok *objp)
{
	 if (!zdr_fhandle1 (zdrs, objp->fhandle))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mountres1 (ZDR *zdrs, mountres1 *objp)
{
	 if (!zdr_mountstat1 (zdrs, &objp->fhs_status))
		 return FALSE;
	switch (objp->fhs_status) {
	case MNT1_OK:
		 if (!zdr_mountres1_ok (zdrs, &objp->mountres1_u.mountinfo))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}
