/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public abstract class RelevanceQuery<T extends QueryBuilder>
extends LuceneQuery {
    private final Map<String, QueryBuilderStep<T>> queryBuildActions;

    protected void ignoreArguments(List<NamedArgumentExpression> arguments) {
        arguments.removeIf(a -> a.getArgName().equalsIgnoreCase("field") || a.getArgName().equalsIgnoreCase("fields") || a.getArgName().equalsIgnoreCase("query"));
    }

    protected void checkValidArguments(String argNormalized, T queryBuilder) {
        if (!this.queryBuildActions.containsKey(argNormalized)) {
            throw new SemanticCheckException(String.format("Parameter %s is invalid for %s function.", argNormalized, queryBuilder.getWriteableName()));
        }
    }

    protected T loadArguments(List<NamedArgumentExpression> arguments) throws SemanticCheckException {
        arguments.stream().collect(Collectors.groupingBy(a -> a.getArgName().toLowerCase())).forEach((k, v) -> {
            if (v.size() > 1) {
                throw new SemanticCheckException(String.format("Parameter '%s' can only be specified once.", k));
            }
        });
        T queryBuilder = this.createQueryBuilder(arguments);
        this.ignoreArguments(arguments);
        ListIterator<NamedArgumentExpression> iterator = arguments.listIterator();
        while (iterator.hasNext()) {
            NamedArgumentExpression arg = iterator.next();
            String argNormalized = arg.getArgName().toLowerCase();
            this.checkValidArguments(argNormalized, queryBuilder);
            Objects.requireNonNull(this.queryBuildActions.get(argNormalized)).apply(queryBuilder, arg.getValue().valueOf());
        }
        return queryBuilder;
    }

    @Override
    public QueryBuilder build(FunctionExpression func) {
        List<NamedArgumentExpression> arguments = func.getArguments().stream().map(a -> (NamedArgumentExpression)a).collect(Collectors.toList());
        if (arguments.size() < 2) {
            throw new SyntaxCheckException(String.format("%s requires at least two parameters", this.getQueryName()));
        }
        return this.loadArguments(arguments);
    }

    protected abstract T createQueryBuilder(List<NamedArgumentExpression> var1);

    protected abstract String getQueryName();

    @Generated
    public RelevanceQuery(Map<String, QueryBuilderStep<T>> queryBuildActions) {
        this.queryBuildActions = queryBuildActions;
    }

    @Generated
    public Map<String, QueryBuilderStep<T>> getQueryBuildActions() {
        return this.queryBuildActions;
    }

    protected static interface QueryBuilderStep<T extends QueryBuilder>
    extends BiFunction<T, ExprValue, T> {
    }
}

