/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class ClassWriter {
    int verbose;
    Package pkg;
    Package.Class cls;
    DataOutputStream out;
    ConstantPool.Index cpIndex;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream bufOut = new DataOutputStream(this.buf);

    ClassWriter(Package.Class cls, OutputStream out) throws IOException {
        this.pkg = cls.getPackage();
        this.cls = cls;
        this.verbose = this.pkg.verbose;
        this.out = new DataOutputStream(new BufferedOutputStream(out));
        this.cpIndex = ConstantPool.makeIndex(cls.toString(), cls.getCPMap());
        this.cpIndex.flattenSigs = true;
        if (this.verbose > 1) {
            Utils.log.fine("local CP=" + (this.verbose > 2 ? this.cpIndex.dumpString() : this.cpIndex.toString()));
        }
    }

    private void writeShort(int x) throws IOException {
        this.out.writeShort(x);
    }

    private void writeInt(int x) throws IOException {
        this.out.writeInt(x);
    }

    private void writeRef(ConstantPool.Entry e) throws IOException {
        int i = e == null ? 0 : this.cpIndex.indexOf(e);
        this.writeShort(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws IOException {
        boolean ok = false;
        try {
            if (this.verbose > 1) {
                Utils.log.fine("...writing " + this.cls);
            }
            this.writeMagicNumbers();
            this.writeConstantPool();
            this.writeHeader();
            this.writeMembers(false);
            this.writeMembers(true);
            this.writeAttributes(0, this.cls);
            this.out.flush();
            ok = true;
        }
        finally {
            if (!ok) {
                Utils.log.warning("Error on output of " + this.cls);
            }
        }
    }

    void writeMagicNumbers() throws IOException {
        this.writeInt(this.cls.magic);
        this.writeShort(this.cls.minver);
        this.writeShort(this.cls.majver);
    }

    void writeConstantPool() throws IOException {
        ConstantPool.Entry[] cpMap = this.cls.cpMap;
        this.writeShort(cpMap.length);
        block10: for (int i = 0; i < cpMap.length; ++i) {
            ConstantPool.Entry e = cpMap[i];
            assert (e == null == (i == 0 || cpMap[i - 1] != null && cpMap[i - 1].isDoubleWord()));
            if (e == null) continue;
            byte tag = e.getTag();
            if (this.verbose > 2) {
                Utils.log.fine("   CP[" + i + "] = " + e);
            }
            this.out.write(tag);
            switch (tag) {
                case 13: {
                    assert (false);
                    continue block10;
                }
                case 1: {
                    this.out.writeUTF(e.stringValue());
                    continue block10;
                }
                case 3: {
                    this.out.writeInt(((ConstantPool.NumberEntry)e).numberValue().intValue());
                    continue block10;
                }
                case 4: {
                    float fval = ((ConstantPool.NumberEntry)e).numberValue().floatValue();
                    this.out.writeInt(Float.floatToRawIntBits(fval));
                    continue block10;
                }
                case 5: {
                    this.out.writeLong(((ConstantPool.NumberEntry)e).numberValue().longValue());
                    continue block10;
                }
                case 6: {
                    double dval = ((ConstantPool.NumberEntry)e).numberValue().doubleValue();
                    this.out.writeLong(Double.doubleToRawLongBits(dval));
                    continue block10;
                }
                case 7: 
                case 8: {
                    this.writeRef(e.getRef(0));
                    continue block10;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.writeRef(e.getRef(0));
                    this.writeRef(e.getRef(1));
                    continue block10;
                }
                default: {
                    throw new IOException("Bad constant pool tag " + tag);
                }
            }
        }
    }

    void writeHeader() throws IOException {
        this.writeShort(this.cls.flags);
        this.writeRef(this.cls.thisClass);
        this.writeRef(this.cls.superClass);
        this.writeShort(this.cls.interfaces.length);
        for (int i = 0; i < this.cls.interfaces.length; ++i) {
            this.writeRef(this.cls.interfaces[i]);
        }
    }

    void writeMembers(boolean doMethods) throws IOException {
        List<Package.Class.Member> mems = !doMethods ? this.cls.getFields() : this.cls.getMethods();
        this.writeShort(mems.size());
        for (Package.Class.Member m : mems) {
            this.writeMember(m, doMethods);
        }
    }

    void writeMember(Package.Class.Member m, boolean doMethod) throws IOException {
        if (this.verbose > 2) {
            Utils.log.fine("writeMember " + m);
        }
        this.writeShort(m.flags);
        this.writeRef(m.getDescriptor().nameRef);
        this.writeRef(m.getDescriptor().typeRef);
        this.writeAttributes(!doMethod ? 1 : 2, m);
    }

    void writeAttributes(int ctype, Attribute.Holder h) throws IOException {
        if (h.attributes == null) {
            this.writeShort(0);
            return;
        }
        this.writeShort(h.attributes.size());
        for (Attribute a : h.attributes) {
            a.finishRefs(this.cpIndex);
            this.writeRef(a.getNameRef());
            if (a.layout() == Package.attrCodeEmpty || a.layout() == Package.attrInnerClassesEmpty) {
                DataOutputStream savedOut = this.out;
                assert (this.out != this.bufOut);
                this.buf.reset();
                this.out = this.bufOut;
                if ("Code".equals(a.name())) {
                    Package.Class.Method m = (Package.Class.Method)h;
                    this.writeCode(m.code);
                } else {
                    assert (h == this.cls);
                    this.writeInnerClasses(this.cls);
                }
                this.out = savedOut;
                if (this.verbose > 2) {
                    Utils.log.fine("Attribute " + a.name() + " [" + this.buf.size() + "]");
                }
                this.writeInt(this.buf.size());
                this.buf.writeTo(this.out);
                continue;
            }
            if (this.verbose > 2) {
                Utils.log.fine("Attribute " + a.name() + " [" + a.size() + "]");
            }
            this.writeInt(a.size());
            this.out.write(a.bytes());
        }
    }

    void writeCode(Code code) throws IOException {
        code.finishRefs(this.cpIndex);
        this.writeShort(code.max_stack);
        this.writeShort(code.max_locals);
        this.writeInt(code.bytes.length);
        this.out.write(code.bytes);
        int nh = code.getHandlerCount();
        this.writeShort(nh);
        for (int i = 0; i < nh; ++i) {
            this.writeShort(code.handler_start[i]);
            this.writeShort(code.handler_end[i]);
            this.writeShort(code.handler_catch[i]);
            this.writeRef(code.handler_class[i]);
        }
        this.writeAttributes(3, code);
    }

    void writeInnerClasses(Package.Class cls) throws IOException {
        List<Package.InnerClass> ics = cls.getInnerClasses();
        this.writeShort(ics.size());
        for (Package.InnerClass ic : ics) {
            this.writeRef(ic.thisClass);
            this.writeRef(ic.outerClass);
            this.writeRef(ic.name);
            this.writeShort(ic.flags);
        }
    }
}

