/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.ntlm;

import com.sun.security.sasl.ntlm.NTLMClient;
import com.sun.security.sasl.ntlm.NTLMServer;
import com.sun.security.sasl.util.PolicyUtils;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public final class FactoryImpl
implements SaslClientFactory,
SaslServerFactory {
    private static final String[] myMechs = new String[]{"NTLM"};
    private static final int[] mechPolicies = new int[]{17};

    @Override
    public SaslClient createSaslClient(String[] mechs, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (int i = 0; i < mechs.length; ++i) {
            if (!mechs[i].equals("NTLM") || !PolicyUtils.checkPolicy(mechPolicies[0], props)) continue;
            if (cbh == null) {
                throw new SaslException("Callback handler with support for RealmCallback, NameCallback, and PasswordCallback required");
            }
            return new NTLMClient(mechs[i], authorizationId, protocol, serverName, props, cbh);
        }
        return null;
    }

    @Override
    public SaslServer createSaslServer(String mech, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (mech.equals("NTLM") && PolicyUtils.checkPolicy(mechPolicies[0], props)) {
            String qop;
            if (props != null && (qop = (String)props.get("javax.security.sasl.qop")) != null && !qop.equals("auth")) {
                throw new SaslException("NTLM only support auth");
            }
            if (cbh == null) {
                throw new SaslException("Callback handler with support for RealmCallback, NameCallback, and PasswordCallback required");
            }
            return new NTLMServer(mech, protocol, serverName, props, cbh);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> env) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, env);
    }
}

