/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.parser.RubyParserBase;
import org.jruby.util.RubyStringBuilder;

public class ScopedParserState {
    private ScopedParserState enclosingScope;
    private long commandArgumentStack;
    private long condArgumentStack;
    private boolean[] namedCaptures;
    private Map<RubySymbol, Integer> definedVariables;
    private Set<RubySymbol> usedVariables;

    public ScopedParserState(ScopedParserState enclosingScope) {
        this.enclosingScope = enclosingScope;
        this.commandArgumentStack = 0L;
        this.condArgumentStack = 0L;
    }

    public ScopedParserState(ScopedParserState enclosingScope, long commandArgumentStack, long condArgumentStack) {
        this.enclosingScope = enclosingScope;
        this.commandArgumentStack = commandArgumentStack;
        this.condArgumentStack = condArgumentStack;
    }

    public void setCondArgumentStack(long condArgumentStack) {
        this.condArgumentStack = condArgumentStack;
    }

    public long getCondArgumentStack() {
        return this.condArgumentStack;
    }

    public void setCommandArgumentStack(long commandArgumentStack) {
        this.commandArgumentStack = commandArgumentStack;
    }

    public long getCommandArgumentStack() {
        return this.commandArgumentStack;
    }

    public ScopedParserState getEnclosingScope() {
        return this.enclosingScope;
    }

    public void growNamedCaptures(int index2) {
        boolean[] newNamedCaptures;
        boolean[] namedCaptures = this.namedCaptures;
        if (namedCaptures != null) {
            newNamedCaptures = new boolean[Math.max(index2 + 1, namedCaptures.length)];
            System.arraycopy(namedCaptures, 0, newNamedCaptures, 0, namedCaptures.length);
        } else {
            newNamedCaptures = new boolean[index2 + 1];
        }
        newNamedCaptures[index2] = true;
        this.namedCaptures = newNamedCaptures;
    }

    public boolean isNamedCapture(int index2) {
        boolean[] namedCaptures = this.namedCaptures;
        return namedCaptures != null && index2 < namedCaptures.length && namedCaptures[index2];
    }

    public void addDefinedVariable(RubySymbol name2, int line) {
        if (this.definedVariables == null) {
            this.definedVariables = new HashMap<RubySymbol, Integer>();
        }
        this.definedVariables.put(name2, line);
    }

    public void markUsedVariable(RubySymbol name2, int depth) {
        if (depth > 0) {
            if (this.enclosingScope != null) {
                this.enclosingScope.markUsedVariable(name2, depth - 1);
            }
            return;
        }
        if (this.usedVariables == null) {
            this.usedVariables = new HashSet<RubySymbol>();
        }
        this.usedVariables.add(name2);
    }

    public void warnUnusedVariables(RubyParserBase parser, String file2) {
        if (this.definedVariables == null) {
            return;
        }
        Ruby runtime2 = parser.getRuntime();
        for (RubySymbol name2 : this.definedVariables.keySet()) {
            if (RubyParserBase.is_private_local_id(name2.getBytes()) || this.usedVariables != null && this.usedVariables.contains(name2)) continue;
            parser.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, file2, this.definedVariables.get(name2), RubyStringBuilder.str(runtime2, "assigned but unused variable - ", name2));
        }
    }
}

