/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkSRGB
extends PngChunkSingle {
    public static final String ID = "sRGB";
    public static final int RENDER_INTENT_Perceptual = 0;
    public static final int RENDER_INTENT_Relative_colorimetric = 1;
    public static final int RENDER_INTENT_Saturation = 2;
    public static final int RENDER_INTENT_Absolute_colorimetric = 3;
    private int intent;

    public PngChunkSRGB(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 1) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        this.intent = PngHelperInternal.readInt1fromByte(chunkRaw.data, 0);
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(1, true);
        chunkRaw.data[0] = (byte)this.intent;
        return chunkRaw;
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkSRGB pngChunkSRGB = (PngChunkSRGB)pngChunk;
        this.intent = pngChunkSRGB.intent;
    }

    public int getIntent() {
        return this.intent;
    }

    public void setIntent(int n) {
        this.intent = n;
    }
}

