
use builtin;
use str;

set edit:completion:arg-completer[gix] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'gix'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'gix'= {
            cand -r 'The repository to access'
            cand --repository 'The repository to access'
            cand -c 'Add these values to the configuration in the form of `key=value` or `key`'
            cand --config 'Add these values to the configuration in the form of `key=value` or `key`'
            cand -t 'The amount of threads to use for some operations'
            cand --threads 'The amount of threads to use for some operations'
            cand -f 'Determine the format to use when outputting statistics'
            cand --format 'Determine the format to use when outputting statistics'
            cand --object-hash 'The object format to assume when reading files that don''t inherently know about it, or when writing files'
            cand -v 'Display verbose messages and progress information'
            cand --verbose 'Display verbose messages and progress information'
            cand --trace 'Display structured `tracing` output in a tree-like structure'
            cand --no-verbose 'Turn off verbose message display for commands where these are shown by default'
            cand --progress 'Bring up a terminal user interface displaying progress visually'
            cand -s 'Don''t default malformed configuration flags, but show an error instead. Ignore IO errors as well'
            cand --strict 'Don''t default malformed configuration flags, but show an error instead. Ignore IO errors as well'
            cand --progress-keep-open 'The progress TUI will stay up even though the work is already completed'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand archive 'Subcommands for creating worktree archives'
            cand clean 'Remove untracked files from the working tree'
            cand commit-graph 'Subcommands for interacting with commit-graph files'
            cand odb 'Interact with the object database'
            cand fsck 'Check for missing objects'
            cand tree 'Interact with tree objects'
            cand commit 'Interact with commit objects'
            cand verify 'Verify the integrity of the entire repository'
            cand revision 'Query and obtain information about revisions'
            cand rev 'Query and obtain information about revisions'
            cand r 'Query and obtain information about revisions'
            cand credential 'A program just like `git credential`'
            cand fetch 'Fetch data from remotes and store it in the repository'
            cand clone 'Clone a repository into a new directory'
            cand mailmap 'Interact with the mailmap'
            cand remote 'Interact with the remote hosts'
            cand remotes 'Interact with the remote hosts'
            cand attributes 'Interact with the attribute files like .gitattributes'
            cand attrs 'Interact with the attribute files like .gitattributes'
            cand exclude 'Interact with the exclude files like .gitignore'
            cand index 'Interact with a worktree index like .git/index'
            cand submodule 'Interact with submodules'
            cand cat 'Show whatever object is at the given spec'
            cand is-clean 'is-clean'
            cand is-changed 'is-changed'
            cand config-tree 'Show which git configuration values are used or planned'
            cand status 'compute repository status similar to `git status`'
            cand config 'Print all entries in a configuration file or access other sub-commands'
            cand merge-base 'A command for calculating all merge-bases'
            cand merge 'perform merges of various kinds'
            cand env 'env'
            cand diff 'Print all changes between two objects'
            cand log 'List all commits in a repository, optionally limited to those that change a given path'
            cand worktree 'Commands for handling worktrees'
            cand free 'Subcommands that need no git repository to run'
            cand no-repo 'Subcommands that need no git repository to run'
            cand blame 'Blame lines in a file'
            cand completions 'Generate shell completions to stdout or a directory'
            cand generate-completions 'Generate shell completions to stdout or a directory'
            cand shell-completions 'Generate shell completions to stdout or a directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;archive'= {
            cand -f 'Explicitly set the format. Otherwise derived from the suffix of the output file'
            cand --format 'Explicitly set the format. Otherwise derived from the suffix of the output file'
            cand --prefix 'Apply the prefix verbatim to any path we add to the archive. Use a trailing `/` if prefix is a directory'
            cand -l 'The compression strength to use for `.zip` and `.tar.gz` archives, valid from 0-9'
            cand --compression-level 'The compression strength to use for `.zip` and `.tar.gz` archives, valid from 0-9'
            cand -p 'Add the given path to the archive. Directories will always be empty'
            cand --add-path 'Add the given path to the archive. Directories will always be empty'
            cand -v 'Add the new file from a slash-separated path, which must happen in pairs of two, first the path, then the content'
            cand --add-virtual-file 'Add the new file from a slash-separated path, which must happen in pairs of two, first the path, then the content'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;clean'= {
            cand --skip-hidden-repositories 'Enter ignored directories to skip repositories contained within'
            cand --find-untracked-repositories 'What kind of repositories to find inside of untracked directories'
            cand --debug 'Print additional debug information to help understand decisions it made'
            cand -n 'A dummy to easy with muscle-memory. This flag is assumed if provided or not, and has no effect'
            cand --dry-run 'A dummy to easy with muscle-memory. This flag is assumed if provided or not, and has no effect'
            cand -e 'Actually perform the operation, which deletes files on disk without chance of recovery'
            cand --execute 'Actually perform the operation, which deletes files on disk without chance of recovery'
            cand -x 'Remove ignored (and expendable) files'
            cand --ignored 'Remove ignored (and expendable) files'
            cand -p 'Remove precious files'
            cand --precious 'Remove precious files'
            cand -d 'Remove whole directories'
            cand --directories 'Remove whole directories'
            cand -r 'Remove nested repositories, even outside ignored directories'
            cand --repositories 'Remove nested repositories, even outside ignored directories'
            cand -m 'Pathspec patterns are used to match the result of the dirwalk, not the dirwalk itself'
            cand --pathspec-matches-result 'Pathspec patterns are used to match the result of the dirwalk, not the dirwalk itself'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;commit-graph'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand verify 'Verify the integrity of a commit graph file'
            cand list 'List all entries in the commit-graph file as reachable by starting from `HEAD`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;commit-graph;verify'= {
            cand -s 'output statistical information about the graph'
            cand --statistics 'output statistical information about the graph'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;commit-graph;list'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;commit-graph;help'= {
            cand verify 'Verify the integrity of a commit graph file'
            cand list 'List all entries in the commit-graph file as reachable by starting from `HEAD`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;commit-graph;help;verify'= {
        }
        &'gix;commit-graph;help;list'= {
        }
        &'gix;commit-graph;help;help'= {
        }
        &'gix;odb'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand entries 'Print all object names'
            cand info 'Provide general information about the object database'
            cand stats 'Count and obtain information on all, possibly duplicate, objects in the database'
            cand statistics 'Count and obtain information on all, possibly duplicate, objects in the database'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;odb;entries'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;odb;info'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;odb;stats'= {
            cand --extra-header-lookup 'Lookup headers again, but without preloading indices'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;odb;statistics'= {
            cand --extra-header-lookup 'Lookup headers again, but without preloading indices'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;odb;help'= {
            cand entries 'Print all object names'
            cand info 'Provide general information about the object database'
            cand stats 'Count and obtain information on all, possibly duplicate, objects in the database'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;odb;help;entries'= {
        }
        &'gix;odb;help;info'= {
        }
        &'gix;odb;help;stats'= {
        }
        &'gix;odb;help;help'= {
        }
        &'gix;fsck'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;tree'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand entries 'Print entries in a given tree'
            cand info 'Provide information about a tree'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;tree;entries'= {
            cand -r 'Traverse the entire tree and its subtrees respectively, not only this tree'
            cand --recursive 'Traverse the entire tree and its subtrees respectively, not only this tree'
            cand -e 'Provide files size as well. This is expensive as the object is decoded entirely'
            cand --extended 'Provide files size as well. This is expensive as the object is decoded entirely'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;tree;info'= {
            cand -e 'Provide files size as well. This is expensive as the object is decoded entirely'
            cand --extended 'Provide files size as well. This is expensive as the object is decoded entirely'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;tree;help'= {
            cand entries 'Print entries in a given tree'
            cand info 'Provide information about a tree'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;tree;help;entries'= {
        }
        &'gix;tree;help;info'= {
        }
        &'gix;tree;help;help'= {
        }
        &'gix;commit'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand verify 'Verify the signature of a commit'
            cand describe 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;commit;verify'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;commit;describe'= {
            cand -c 'Consider only the given `n` candidates. This can take longer, but potentially produces more accurate results'
            cand --max-candidates 'Consider only the given `n` candidates. This can take longer, but potentially produces more accurate results'
            cand -d 'Set the suffix to append if the repository is dirty (not counting untracked files)'
            cand --dirty-suffix 'Set the suffix to append if the repository is dirty (not counting untracked files)'
            cand -t 'Use annotated tag references only, not all tags'
            cand --annotated-tags 'Use annotated tag references only, not all tags'
            cand -a 'Use all references under the `ref/` namespaces, which includes tag references, local and remote branches'
            cand --all-refs 'Use all references under the `ref/` namespaces, which includes tag references, local and remote branches'
            cand -f 'Only follow the first parent when traversing the commit graph'
            cand --first-parent 'Only follow the first parent when traversing the commit graph'
            cand -l 'Always display the long format, even if that would not be necessary as the id is located directly on a reference'
            cand --long 'Always display the long format, even if that would not be necessary as the id is located directly on a reference'
            cand -s 'Print information on stderr to inform about performance statistics'
            cand --statistics 'Print information on stderr to inform about performance statistics'
            cand --always 'If there was no way to describe the commit, fallback to using the abbreviated input revision'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;commit;help'= {
            cand verify 'Verify the signature of a commit'
            cand describe 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;commit;help;verify'= {
        }
        &'gix;commit;help;describe'= {
        }
        &'gix;commit;help;help'= {
        }
        &'gix;verify'= {
            cand -a 'The algorithm used to verify packs. They differ in costs'
            cand --algorithm 'The algorithm used to verify packs. They differ in costs'
            cand -s 'output statistical information'
            cand --statistics 'output statistical information'
            cand --decode 'Decode and parse tags, commits and trees to validate their correctness beyond hashing correctly'
            cand --re-encode 'Decode and parse tags, commits and trees to validate their correctness, and re-encode them'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;revision'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand list 'List all commits reachable from the given rev-spec'
            cand l 'List all commits reachable from the given rev-spec'
            cand explain 'Provide the revision specification like `@~1` to explain'
            cand e 'Provide the revision specification like `@~1` to explain'
            cand resolve 'Try to resolve the given revspec and print the object names'
            cand query 'Try to resolve the given revspec and print the object names'
            cand parse 'Try to resolve the given revspec and print the object names'
            cand p 'Try to resolve the given revspec and print the object names'
            cand previous-branches 'Return the names and hashes of all previously checked-out branches'
            cand prev 'Return the names and hashes of all previously checked-out branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;rev'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand list 'List all commits reachable from the given rev-spec'
            cand l 'List all commits reachable from the given rev-spec'
            cand explain 'Provide the revision specification like `@~1` to explain'
            cand e 'Provide the revision specification like `@~1` to explain'
            cand resolve 'Try to resolve the given revspec and print the object names'
            cand query 'Try to resolve the given revspec and print the object names'
            cand parse 'Try to resolve the given revspec and print the object names'
            cand p 'Try to resolve the given revspec and print the object names'
            cand previous-branches 'Return the names and hashes of all previously checked-out branches'
            cand prev 'Return the names and hashes of all previously checked-out branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;r'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand list 'List all commits reachable from the given rev-spec'
            cand l 'List all commits reachable from the given rev-spec'
            cand explain 'Provide the revision specification like `@~1` to explain'
            cand e 'Provide the revision specification like `@~1` to explain'
            cand resolve 'Try to resolve the given revspec and print the object names'
            cand query 'Try to resolve the given revspec and print the object names'
            cand parse 'Try to resolve the given revspec and print the object names'
            cand p 'Try to resolve the given revspec and print the object names'
            cand previous-branches 'Return the names and hashes of all previously checked-out branches'
            cand prev 'Return the names and hashes of all previously checked-out branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;revision;list'= {
            cand -l 'How many commits to list at most'
            cand --limit 'How many commits to list at most'
            cand -s 'Write the graph as SVG file to the given path'
            cand --svg 'Write the graph as SVG file to the given path'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;revision;l'= {
            cand -l 'How many commits to list at most'
            cand --limit 'How many commits to list at most'
            cand -s 'Write the graph as SVG file to the given path'
            cand --svg 'Write the graph as SVG file to the given path'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;rev;list'= {
            cand -l 'How many commits to list at most'
            cand --limit 'How many commits to list at most'
            cand -s 'Write the graph as SVG file to the given path'
            cand --svg 'Write the graph as SVG file to the given path'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;rev;l'= {
            cand -l 'How many commits to list at most'
            cand --limit 'How many commits to list at most'
            cand -s 'Write the graph as SVG file to the given path'
            cand --svg 'Write the graph as SVG file to the given path'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;r;list'= {
            cand -l 'How many commits to list at most'
            cand --limit 'How many commits to list at most'
            cand -s 'Write the graph as SVG file to the given path'
            cand --svg 'Write the graph as SVG file to the given path'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;r;l'= {
            cand -l 'How many commits to list at most'
            cand --limit 'How many commits to list at most'
            cand -s 'Write the graph as SVG file to the given path'
            cand --svg 'Write the graph as SVG file to the given path'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;revision;explain'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;revision;e'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;rev;explain'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;rev;e'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;r;explain'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;r;e'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;revision;resolve'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;revision;query'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;revision;parse'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;revision;p'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;rev;resolve'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;rev;query'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;rev;parse'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;rev;p'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;r;resolve'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;r;query'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;r;parse'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;r;p'= {
            cand -b 'How to display blobs'
            cand --blob-format 'How to display blobs'
            cand -t 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand --tree-mode 'How to display trees as obtained with `@:dirname` or `@^{tree}`'
            cand -e 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand --explain 'Instead of resolving a rev-spec, explain what would be done for the first spec'
            cand -r 'Also show the name of the reference which led to the object'
            cand --reference 'Also show the name of the reference which led to the object'
            cand -c 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand --cat-file 'Show the first resulting object similar to how `git cat-file` would, but don''t show the resolved spec'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;revision;previous-branches'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;revision;prev'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;rev;previous-branches'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;rev;prev'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;r;previous-branches'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;r;prev'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;revision;help'= {
            cand list 'List all commits reachable from the given rev-spec'
            cand explain 'Provide the revision specification like `@~1` to explain'
            cand resolve 'Try to resolve the given revspec and print the object names'
            cand previous-branches 'Return the names and hashes of all previously checked-out branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;revision;help;list'= {
        }
        &'gix;revision;help;explain'= {
        }
        &'gix;revision;help;resolve'= {
        }
        &'gix;revision;help;previous-branches'= {
        }
        &'gix;revision;help;help'= {
        }
        &'gix;rev;help'= {
            cand list 'List all commits reachable from the given rev-spec'
            cand explain 'Provide the revision specification like `@~1` to explain'
            cand resolve 'Try to resolve the given revspec and print the object names'
            cand previous-branches 'Return the names and hashes of all previously checked-out branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;rev;help;list'= {
        }
        &'gix;rev;help;explain'= {
        }
        &'gix;rev;help;resolve'= {
        }
        &'gix;rev;help;previous-branches'= {
        }
        &'gix;rev;help;help'= {
        }
        &'gix;r;help'= {
            cand list 'List all commits reachable from the given rev-spec'
            cand explain 'Provide the revision specification like `@~1` to explain'
            cand resolve 'Try to resolve the given revspec and print the object names'
            cand previous-branches 'Return the names and hashes of all previously checked-out branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;r;help;list'= {
        }
        &'gix;r;help;explain'= {
        }
        &'gix;r;help;resolve'= {
        }
        &'gix;r;help;previous-branches'= {
        }
        &'gix;r;help;help'= {
        }
        &'gix;credential'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand fill 'Get the credentials fed for `url=<url>` via STDIN'
            cand get 'Get the credentials fed for `url=<url>` via STDIN'
            cand approve 'Approve the information piped via STDIN as obtained with last call to `fill`'
            cand store 'Approve the information piped via STDIN as obtained with last call to `fill`'
            cand reject 'Try to resolve the given revspec and print the object names'
            cand erase 'Try to resolve the given revspec and print the object names'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;credential;fill'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;credential;get'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;credential;approve'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;credential;store'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;credential;reject'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;credential;erase'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;credential;help'= {
            cand fill 'Get the credentials fed for `url=<url>` via STDIN'
            cand approve 'Approve the information piped via STDIN as obtained with last call to `fill`'
            cand reject 'Try to resolve the given revspec and print the object names'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;credential;help;fill'= {
        }
        &'gix;credential;help;approve'= {
        }
        &'gix;credential;help;reject'= {
        }
        &'gix;credential;help;help'= {
        }
        &'gix;fetch'= {
            cand -g 'Open the commit graph used for negotiation and write an SVG file to PATH'
            cand --open-negotiation-graph 'Open the commit graph used for negotiation and write an SVG file to PATH'
            cand --depth 'Fetch with the history truncated to the given number of commits as seen from the remote'
            cand --deepen 'Extend the current shallow boundary by the given amount of commits, with 0 meaning no change'
            cand --shallow-since 'Cutoff all history past the given date. Can be combined with shallow-exclude'
            cand --shallow-exclude 'Cutoff all history past the tag-name or ref-name. Can be combined with shallow-since'
            cand -r 'The name of the remote to connect to, or the url of the remote to connect to directly'
            cand --remote 'The name of the remote to connect to, or the url of the remote to connect to directly'
            cand -n 'Don''t change the local repository, but otherwise try to be as accurate as possible'
            cand --dry-run 'Don''t change the local repository, but otherwise try to be as accurate as possible'
            cand -H 'Output additional typically information provided by the server as part of the connection handshake'
            cand --handshake-info 'Output additional typically information provided by the server as part of the connection handshake'
            cand -s 'Print statistics about negotiation phase'
            cand --negotiation-info 'Print statistics about negotiation phase'
            cand --unshallow 'Remove the shallow boundary and fetch the entire history available on the remote'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;clone'= {
            cand --depth 'Create a shallow clone with the history truncated to the given number of commits'
            cand --shallow-since 'Cutoff all history past the given date. Can be combined with shallow-exclude'
            cand --shallow-exclude 'Cutoff all history past the tag-name or ref-name. Can be combined with shallow-since'
            cand --ref 'The name of the reference to check out'
            cand -H 'Output additional typically information provided by the server as part of the connection handshake'
            cand --handshake-info 'Output additional typically information provided by the server as part of the connection handshake'
            cand --bare 'The clone will be bare and a working tree checkout won''t be available'
            cand --no-tags 'Do not clone any tags. Useful to reduce the size of the clone if only branches are needed'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;mailmap'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand entries 'Print all entries in configured mailmaps, inform about errors as well'
            cand check 'Print the canonical form of contacts according to the configured mailmaps'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;mailmap;entries'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;mailmap;check'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;mailmap;help'= {
            cand entries 'Print all entries in configured mailmaps, inform about errors as well'
            cand check 'Print the canonical form of contacts according to the configured mailmaps'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;mailmap;help;entries'= {
        }
        &'gix;mailmap;help;check'= {
        }
        &'gix;mailmap;help;help'= {
        }
        &'gix;remote'= {
            cand -n 'The name of the remote to connect to, or the URL of the remote to connect to directly'
            cand --name 'The name of the remote to connect to, or the URL of the remote to connect to directly'
            cand -H 'Output additional typically information provided by the server as part of the connection handshake'
            cand --handshake-info 'Output additional typically information provided by the server as part of the connection handshake'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand refs 'Print all references available on the remote'
            cand ref-map 'Print all references available on the remote as filtered through ref-specs'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;remotes'= {
            cand -n 'The name of the remote to connect to, or the URL of the remote to connect to directly'
            cand --name 'The name of the remote to connect to, or the URL of the remote to connect to directly'
            cand -H 'Output additional typically information provided by the server as part of the connection handshake'
            cand --handshake-info 'Output additional typically information provided by the server as part of the connection handshake'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand refs 'Print all references available on the remote'
            cand ref-map 'Print all references available on the remote as filtered through ref-specs'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;remote;refs'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;remotes;refs'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;remote;ref-map'= {
            cand -u 'Also display remote references that were sent by the server, but filtered by the refspec locally'
            cand --show-unmapped-remote-refs 'Also display remote references that were sent by the server, but filtered by the refspec locally'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;remotes;ref-map'= {
            cand -u 'Also display remote references that were sent by the server, but filtered by the refspec locally'
            cand --show-unmapped-remote-refs 'Also display remote references that were sent by the server, but filtered by the refspec locally'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;remote;help'= {
            cand refs 'Print all references available on the remote'
            cand ref-map 'Print all references available on the remote as filtered through ref-specs'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;remote;help;refs'= {
        }
        &'gix;remote;help;ref-map'= {
        }
        &'gix;remote;help;help'= {
        }
        &'gix;remotes;help'= {
            cand refs 'Print all references available on the remote'
            cand ref-map 'Print all references available on the remote as filtered through ref-specs'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;remotes;help;refs'= {
        }
        &'gix;remotes;help;ref-map'= {
        }
        &'gix;remotes;help;help'= {
        }
        &'gix;attributes'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand validate-baseline 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
            cand query 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;attrs'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand validate-baseline 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
            cand query 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;attributes;validate-baseline'= {
            cand -s 'Print various statistics to stderr'
            cand --statistics 'Print various statistics to stderr'
            cand --no-ignore 'Don''t validated excludes as obtaining them with `check-ignore` can be very slow'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;attrs;validate-baseline'= {
            cand -s 'Print various statistics to stderr'
            cand --statistics 'Print various statistics to stderr'
            cand --no-ignore 'Don''t validated excludes as obtaining them with `check-ignore` can be very slow'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;attributes;query'= {
            cand -s 'Print various statistics to stderr'
            cand --statistics 'Print various statistics to stderr'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;attrs;query'= {
            cand -s 'Print various statistics to stderr'
            cand --statistics 'Print various statistics to stderr'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;attributes;help'= {
            cand validate-baseline 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
            cand query 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;attributes;help;validate-baseline'= {
        }
        &'gix;attributes;help;query'= {
        }
        &'gix;attributes;help;help'= {
        }
        &'gix;attrs;help'= {
            cand validate-baseline 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
            cand query 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;attrs;help;validate-baseline'= {
        }
        &'gix;attrs;help;query'= {
        }
        &'gix;attrs;help;help'= {
        }
        &'gix;exclude'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand query 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;exclude;query'= {
            cand -p 'Additional patterns to use for exclusions. They have the highest priority'
            cand --patterns 'Additional patterns to use for exclusions. They have the highest priority'
            cand -s 'Print various statistics to stderr'
            cand --statistics 'Print various statistics to stderr'
            cand -i 'Show actual ignore patterns instead of un-excluding an entry'
            cand --show-ignore-patterns 'Show actual ignore patterns instead of un-excluding an entry'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;exclude;help'= {
            cand query 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;exclude;help;query'= {
        }
        &'gix;exclude;help;help'= {
        }
        &'gix;index'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand entries 'Print all entries to standard output'
            cand from-tree 'Create an index from a tree-ish'
            cand read-tree 'Create an index from a tree-ish'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;index;entries'= {
            cand -f 'How to output index entries'
            cand --format 'How to output index entries'
            cand --no-attributes 'Do not visualize excluded entries or attributes per path'
            cand -i 'Load attribute and ignore files from the index, don''t look at the worktree'
            cand --attributes-from-index 'Load attribute and ignore files from the index, don''t look at the worktree'
            cand -r 'Display submodule entries as well if their repository exists'
            cand --recurse-submodules 'Display submodule entries as well if their repository exists'
            cand -s 'Print various statistics to stderr'
            cand --statistics 'Print various statistics to stderr'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;index;from-tree'= {
            cand -i 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand --index-output-path 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand -f 'Overwrite the specified index file if it already exists'
            cand --force 'Overwrite the specified index file if it already exists'
            cand -s 'Don''t write the trailing hash for a performance gain'
            cand --skip-hash 'Don''t write the trailing hash for a performance gain'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;index;read-tree'= {
            cand -i 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand --index-output-path 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand -f 'Overwrite the specified index file if it already exists'
            cand --force 'Overwrite the specified index file if it already exists'
            cand -s 'Don''t write the trailing hash for a performance gain'
            cand --skip-hash 'Don''t write the trailing hash for a performance gain'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;index;help'= {
            cand entries 'Print all entries to standard output'
            cand from-tree 'Create an index from a tree-ish'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;index;help;entries'= {
        }
        &'gix;index;help;from-tree'= {
        }
        &'gix;index;help;help'= {
        }
        &'gix;submodule'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand list 'Print all direct submodules to standard output'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;submodule;list'= {
            cand -d 'Set the suffix to append if the repository is dirty (not counting untracked files)'
            cand --dirty-suffix 'Set the suffix to append if the repository is dirty (not counting untracked files)'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;submodule;help'= {
            cand list 'Print all direct submodules to standard output'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;submodule;help;list'= {
        }
        &'gix;submodule;help;help'= {
        }
        &'gix;cat'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;is-clean'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;is-changed'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;config-tree'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;status'= {
            cand -f 'The way status data is displayed'
            cand --format 'The way status data is displayed'
            cand --ignored 'If enabled, show ignored files and directories'
            cand --submodules 'Define how to display the submodule status. Defaults to git configuration if unset'
            cand --index-worktree-renames 'Enable rename tracking between the index and the working tree, preventing the collapse of folders as well'
            cand -s 'Print additional statistics to help understanding performance'
            cand --statistics 'Print additional statistics to help understanding performance'
            cand --no-write 'Don''t write back a changed index, which forces this operation to always be idempotent'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;config'= {
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;merge-base'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;merge'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand file 'Merge a file by specifying ours, base and theirs'
            cand tree 'Merge a tree by specifying ours, base and theirs, writing it to the object database'
            cand commit 'Merge a commits by specifying ours, and theirs, writing the tree to the object database'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;merge;file'= {
            cand -c 'Decide how to resolve conflicts. If unset, write conflict markers and fail'
            cand --resolve-with 'Decide how to resolve conflicts. If unset, write conflict markers and fail'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;merge;tree'= {
            cand -f 'Decide how to resolve content conflicts in files. If unset, write conflict markers and fail'
            cand --file-favor 'Decide how to resolve content conflicts in files. If unset, write conflict markers and fail'
            cand -t 'Decide how to resolve conflicts in trees, i.e. modification/deletion. If unset, try to preserve both states and fail'
            cand --tree-favor 'Decide how to resolve conflicts in trees, i.e. modification/deletion. If unset, try to preserve both states and fail'
            cand -m 'Keep all objects to be written in memory to avoid any disk IO'
            cand --in-memory 'Keep all objects to be written in memory to avoid any disk IO'
            cand -d 'Print additional information about conflicts for debugging'
            cand --debug 'Print additional information about conflicts for debugging'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;merge;commit'= {
            cand -f 'Decide how to resolve content conflicts in files. If unset, write conflict markers and fail'
            cand --file-favor 'Decide how to resolve content conflicts in files. If unset, write conflict markers and fail'
            cand -t 'Decide how to resolve conflicts in trees, i.e. modification/deletion. If unset, try to preserve both states and fail'
            cand --tree-favor 'Decide how to resolve conflicts in trees, i.e. modification/deletion. If unset, try to preserve both states and fail'
            cand -m 'Keep all objects to be written in memory to avoid any disk IO'
            cand --in-memory 'Keep all objects to be written in memory to avoid any disk IO'
            cand -d 'Print additional information about conflicts for debugging'
            cand --debug 'Print additional information about conflicts for debugging'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;merge;help'= {
            cand file 'Merge a file by specifying ours, base and theirs'
            cand tree 'Merge a tree by specifying ours, base and theirs, writing it to the object database'
            cand commit 'Merge a commits by specifying ours, and theirs, writing the tree to the object database'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;merge;help;file'= {
        }
        &'gix;merge;help;tree'= {
        }
        &'gix;merge;help;commit'= {
        }
        &'gix;merge;help;help'= {
        }
        &'gix;env'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;diff'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand tree 'Diff two trees'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;diff;tree'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;diff;help'= {
            cand tree 'Diff two trees'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;diff;help;tree'= {
        }
        &'gix;diff;help;help'= {
        }
        &'gix;log'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;worktree'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand list 'List all worktrees, along with some accompanying information'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;worktree;list'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;worktree;help'= {
            cand list 'List all worktrees, along with some accompanying information'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;worktree;help;list'= {
        }
        &'gix;worktree;help;help'= {
        }
        &'gix;free'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand commit-graph 'Subcommands for interacting with commit-graphs'
            cand mailmap 'Subcommands for interacting with mailmaps'
            cand pack 'Subcommands for interacting with pack files and indices'
            cand index 'Subcommands for interacting with a worktree index, typically at .git/index'
            cand discover 'Show information about repository discovery and when opening a repository at the current path'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand commit-graph 'Subcommands for interacting with commit-graphs'
            cand mailmap 'Subcommands for interacting with mailmaps'
            cand pack 'Subcommands for interacting with pack files and indices'
            cand index 'Subcommands for interacting with a worktree index, typically at .git/index'
            cand discover 'Show information about repository discovery and when opening a repository at the current path'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;commit-graph'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand verify 'Verify the integrity of a commit graph'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;commit-graph;verify'= {
            cand -s 'output statistical information about the pack'
            cand --statistics 'output statistical information about the pack'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;commit-graph;help'= {
            cand verify 'Verify the integrity of a commit graph'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;commit-graph;help;verify'= {
        }
        &'gix;free;commit-graph;help;help'= {
        }
        &'gix;no-repo;commit-graph'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand verify 'Verify the integrity of a commit graph'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;commit-graph;verify'= {
            cand -s 'output statistical information about the pack'
            cand --statistics 'output statistical information about the pack'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;commit-graph;help'= {
            cand verify 'Verify the integrity of a commit graph'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;commit-graph;help;verify'= {
        }
        &'gix;no-repo;commit-graph;help;help'= {
        }
        &'gix;free;mailmap'= {
            cand -p 'The path to the mailmap file'
            cand --path 'The path to the mailmap file'
            cand -h 'Print help'
            cand --help 'Print help'
            cand verify 'Parse all entries in the mailmap and report malformed lines or collisions'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;mailmap;verify'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;mailmap;help'= {
            cand verify 'Parse all entries in the mailmap and report malformed lines or collisions'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;mailmap;help;verify'= {
        }
        &'gix;free;mailmap;help;help'= {
        }
        &'gix;no-repo;mailmap'= {
            cand -p 'The path to the mailmap file'
            cand --path 'The path to the mailmap file'
            cand -h 'Print help'
            cand --help 'Print help'
            cand verify 'Parse all entries in the mailmap and report malformed lines or collisions'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;mailmap;verify'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;mailmap;help'= {
            cand verify 'Parse all entries in the mailmap and report malformed lines or collisions'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;mailmap;help;verify'= {
        }
        &'gix;no-repo;mailmap;help;help'= {
        }
        &'gix;free;pack'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand index 'Subcommands for interacting with pack indices (.idx)'
            cand multi-index 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
            cand create 'Create a new pack with a set of objects'
            cand receive 'Use the gix-protocol to receive a pack, emulating a clone'
            cand explode 'Dissolve a pack into its loose objects'
            cand verify 'Verify the integrity of a pack, index or multi-index file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;pack;index'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand create 'create a pack index from a pack data file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;pack;index;create'= {
            cand -i 'Specify how to iterate the pack, defaults to ''verify'''
            cand --iteration-mode 'Specify how to iterate the pack, defaults to ''verify'''
            cand -p 'Path to the pack file to read (with .pack extension)'
            cand --pack-path 'Path to the pack file to read (with .pack extension)'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;free;pack;index;help'= {
            cand create 'create a pack index from a pack data file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;pack;index;help;create'= {
        }
        &'gix;free;pack;index;help;help'= {
        }
        &'gix;free;pack;multi-index'= {
            cand -i 'The path to the index file'
            cand --multi-index-path 'The path to the index file'
            cand -h 'Print help'
            cand --help 'Print help'
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;pack;multi-index;entries'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;pack;multi-index;info'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;pack;multi-index;verify'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;pack;multi-index;create'= {
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;free;pack;multi-index;help'= {
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;pack;multi-index;help;entries'= {
        }
        &'gix;free;pack;multi-index;help;info'= {
        }
        &'gix;free;pack;multi-index;help;verify'= {
        }
        &'gix;free;pack;multi-index;help;create'= {
        }
        &'gix;free;pack;multi-index;help;help'= {
        }
        &'gix;free;pack;create'= {
            cand -r 'the directory containing the ''.git'' repository from which objects should be read'
            cand --repository 'the directory containing the ''.git'' repository from which objects should be read'
            cand -e 'the way objects are expanded. They differ in costs'
            cand --expansion 'the way objects are expanded. They differ in costs'
            cand --counting-threads 'The amount of threads to use when counting and the `--nondeterminisitc-count` flag is set, defaulting to the globally configured threads'
            cand --pack-cache-size-mb 'The size in megabytes for a cache to speed up pack access for packs with long delta chains. It is shared among all threads, so 4 threads would use their own cache 1/4th of the size'
            cand --object-cache-size-mb 'The size in megabytes for a cache to speed up accessing entire objects, bypassing object database access when hit. It is shared among all threads, so 4 threads would use their own cache 1/4th of the size'
            cand -o 'The directory into which to write the pack file'
            cand --output-directory 'The directory into which to write the pack file'
            cand --nondeterministic-count 'if set, the counting phase may be accelerated using multithreading'
            cand -s 'If set statistical information will be presented to inform about pack creation details. It''s a form of instrumentation for developers to help improve pack generation'
            cand --statistics 'If set statistical information will be presented to inform about pack creation details. It''s a form of instrumentation for developers to help improve pack generation'
            cand --thin 'if set, delta-objects whose base object wouldn''t be in the pack will not be recompressed as base object, but instead refer to its base object using its object id'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;free;pack;receive'= {
            cand -p 'The protocol version to use. Valid values are 1 and 2'
            cand --protocol 'The protocol version to use. Valid values are 1 and 2'
            cand -d 'the directory into which to write references. Existing files will be overwritten'
            cand --refs-directory 'the directory into which to write references. Existing files will be overwritten'
            cand -r 'If set once or more times, these references will be fetched instead of all advertised ones'
            cand --reference 'If set once or more times, these references will be fetched instead of all advertised ones'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;free;pack;explode'= {
            cand -c 'The amount of checks to run'
            cand --check 'The amount of checks to run'
            cand --verify 'Read written objects back and assert they match their source. Fail the operation otherwise'
            cand --delete-pack 'delete the pack and index file after the operation is successful'
            cand --sink-compress 'Compress bytes even when using the sink, i.e. no object directory is specified'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;free;pack;verify'= {
            cand -a 'The algorithm used to verify packs. They differ in costs'
            cand --algorithm 'The algorithm used to verify packs. They differ in costs'
            cand -s 'output statistical information'
            cand --statistics 'output statistical information'
            cand --decode 'Decode and parse tags, commits and trees to validate their correctness beyond hashing correctly'
            cand --re-encode 'Decode and parse tags, commits and trees to validate their correctness, and re-encode them'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;free;pack;help'= {
            cand index 'Subcommands for interacting with pack indices (.idx)'
            cand multi-index 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
            cand create 'Create a new pack with a set of objects'
            cand receive 'Use the gix-protocol to receive a pack, emulating a clone'
            cand explode 'Dissolve a pack into its loose objects'
            cand verify 'Verify the integrity of a pack, index or multi-index file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;pack;help;index'= {
            cand create 'create a pack index from a pack data file'
        }
        &'gix;free;pack;help;index;create'= {
        }
        &'gix;free;pack;help;multi-index'= {
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
        }
        &'gix;free;pack;help;multi-index;entries'= {
        }
        &'gix;free;pack;help;multi-index;info'= {
        }
        &'gix;free;pack;help;multi-index;verify'= {
        }
        &'gix;free;pack;help;multi-index;create'= {
        }
        &'gix;free;pack;help;create'= {
        }
        &'gix;free;pack;help;receive'= {
        }
        &'gix;free;pack;help;explode'= {
        }
        &'gix;free;pack;help;verify'= {
        }
        &'gix;free;pack;help;help'= {
        }
        &'gix;no-repo;pack'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand index 'Subcommands for interacting with pack indices (.idx)'
            cand multi-index 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
            cand create 'Create a new pack with a set of objects'
            cand receive 'Use the gix-protocol to receive a pack, emulating a clone'
            cand explode 'Dissolve a pack into its loose objects'
            cand verify 'Verify the integrity of a pack, index or multi-index file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;pack;index'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand create 'create a pack index from a pack data file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;pack;index;create'= {
            cand -i 'Specify how to iterate the pack, defaults to ''verify'''
            cand --iteration-mode 'Specify how to iterate the pack, defaults to ''verify'''
            cand -p 'Path to the pack file to read (with .pack extension)'
            cand --pack-path 'Path to the pack file to read (with .pack extension)'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;no-repo;pack;index;help'= {
            cand create 'create a pack index from a pack data file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;pack;index;help;create'= {
        }
        &'gix;no-repo;pack;index;help;help'= {
        }
        &'gix;no-repo;pack;multi-index'= {
            cand -i 'The path to the index file'
            cand --multi-index-path 'The path to the index file'
            cand -h 'Print help'
            cand --help 'Print help'
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;pack;multi-index;entries'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;pack;multi-index;info'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;pack;multi-index;verify'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;pack;multi-index;create'= {
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;no-repo;pack;multi-index;help'= {
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;pack;multi-index;help;entries'= {
        }
        &'gix;no-repo;pack;multi-index;help;info'= {
        }
        &'gix;no-repo;pack;multi-index;help;verify'= {
        }
        &'gix;no-repo;pack;multi-index;help;create'= {
        }
        &'gix;no-repo;pack;multi-index;help;help'= {
        }
        &'gix;no-repo;pack;create'= {
            cand -r 'the directory containing the ''.git'' repository from which objects should be read'
            cand --repository 'the directory containing the ''.git'' repository from which objects should be read'
            cand -e 'the way objects are expanded. They differ in costs'
            cand --expansion 'the way objects are expanded. They differ in costs'
            cand --counting-threads 'The amount of threads to use when counting and the `--nondeterminisitc-count` flag is set, defaulting to the globally configured threads'
            cand --pack-cache-size-mb 'The size in megabytes for a cache to speed up pack access for packs with long delta chains. It is shared among all threads, so 4 threads would use their own cache 1/4th of the size'
            cand --object-cache-size-mb 'The size in megabytes for a cache to speed up accessing entire objects, bypassing object database access when hit. It is shared among all threads, so 4 threads would use their own cache 1/4th of the size'
            cand -o 'The directory into which to write the pack file'
            cand --output-directory 'The directory into which to write the pack file'
            cand --nondeterministic-count 'if set, the counting phase may be accelerated using multithreading'
            cand -s 'If set statistical information will be presented to inform about pack creation details. It''s a form of instrumentation for developers to help improve pack generation'
            cand --statistics 'If set statistical information will be presented to inform about pack creation details. It''s a form of instrumentation for developers to help improve pack generation'
            cand --thin 'if set, delta-objects whose base object wouldn''t be in the pack will not be recompressed as base object, but instead refer to its base object using its object id'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;no-repo;pack;receive'= {
            cand -p 'The protocol version to use. Valid values are 1 and 2'
            cand --protocol 'The protocol version to use. Valid values are 1 and 2'
            cand -d 'the directory into which to write references. Existing files will be overwritten'
            cand --refs-directory 'the directory into which to write references. Existing files will be overwritten'
            cand -r 'If set once or more times, these references will be fetched instead of all advertised ones'
            cand --reference 'If set once or more times, these references will be fetched instead of all advertised ones'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;no-repo;pack;explode'= {
            cand -c 'The amount of checks to run'
            cand --check 'The amount of checks to run'
            cand --verify 'Read written objects back and assert they match their source. Fail the operation otherwise'
            cand --delete-pack 'delete the pack and index file after the operation is successful'
            cand --sink-compress 'Compress bytes even when using the sink, i.e. no object directory is specified'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;no-repo;pack;verify'= {
            cand -a 'The algorithm used to verify packs. They differ in costs'
            cand --algorithm 'The algorithm used to verify packs. They differ in costs'
            cand -s 'output statistical information'
            cand --statistics 'output statistical information'
            cand --decode 'Decode and parse tags, commits and trees to validate their correctness beyond hashing correctly'
            cand --re-encode 'Decode and parse tags, commits and trees to validate their correctness, and re-encode them'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'gix;no-repo;pack;help'= {
            cand index 'Subcommands for interacting with pack indices (.idx)'
            cand multi-index 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
            cand create 'Create a new pack with a set of objects'
            cand receive 'Use the gix-protocol to receive a pack, emulating a clone'
            cand explode 'Dissolve a pack into its loose objects'
            cand verify 'Verify the integrity of a pack, index or multi-index file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;pack;help;index'= {
            cand create 'create a pack index from a pack data file'
        }
        &'gix;no-repo;pack;help;index;create'= {
        }
        &'gix;no-repo;pack;help;multi-index'= {
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
        }
        &'gix;no-repo;pack;help;multi-index;entries'= {
        }
        &'gix;no-repo;pack;help;multi-index;info'= {
        }
        &'gix;no-repo;pack;help;multi-index;verify'= {
        }
        &'gix;no-repo;pack;help;multi-index;create'= {
        }
        &'gix;no-repo;pack;help;create'= {
        }
        &'gix;no-repo;pack;help;receive'= {
        }
        &'gix;no-repo;pack;help;explode'= {
        }
        &'gix;no-repo;pack;help;verify'= {
        }
        &'gix;no-repo;pack;help;help'= {
        }
        &'gix;free;index'= {
            cand --object-hash 'The object format to assume when reading files that don''t inherently know about it, or when writing files'
            cand -i 'The path to the index file'
            cand --index-path 'The path to the index file'
            cand -h 'Print help'
            cand --help 'Print help'
            cand from-list 'Create an index from a list of empty files, one per line of the input'
            cand verify 'Validate constraints and assumptions of an index along with its integrity'
            cand info 'Print information about the index structure'
            cand checkout-exclusive 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;index;from-list'= {
            cand -i 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand --index-output-path 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand -f 'Overwrite the specified index file if it already exists'
            cand --force 'Overwrite the specified index file if it already exists'
            cand -s 'Don''t write the trailing hash for a performance gain'
            cand --skip-hash 'Don''t write the trailing hash for a performance gain'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;index;verify'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;index;info'= {
            cand --no-details 'Do not extract specific extension information to gain only a superficial idea of the index''s composition'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;index;checkout-exclusive'= {
            cand -r 'The path to `.git` repository from which objects can be obtained to write the actual files referenced in the index. Use this measure the impact on extracting objects on overall performance'
            cand --repository 'The path to `.git` repository from which objects can be obtained to write the actual files referenced in the index. Use this measure the impact on extracting objects on overall performance'
            cand -k 'Ignore errors and keep checking out as many files as possible, and report all errors at the end of the operation'
            cand --keep-going 'Ignore errors and keep checking out as many files as possible, and report all errors at the end of the operation'
            cand -e 'Enable to query the object database yet write only empty files. This is useful to measure the overhead of ODB query compared to writing the bytes to disk'
            cand --empty-files 'Enable to query the object database yet write only empty files. This is useful to measure the overhead of ODB query compared to writing the bytes to disk'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;index;help'= {
            cand from-list 'Create an index from a list of empty files, one per line of the input'
            cand verify 'Validate constraints and assumptions of an index along with its integrity'
            cand info 'Print information about the index structure'
            cand checkout-exclusive 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;index;help;from-list'= {
        }
        &'gix;free;index;help;verify'= {
        }
        &'gix;free;index;help;info'= {
        }
        &'gix;free;index;help;checkout-exclusive'= {
        }
        &'gix;free;index;help;help'= {
        }
        &'gix;no-repo;index'= {
            cand --object-hash 'The object format to assume when reading files that don''t inherently know about it, or when writing files'
            cand -i 'The path to the index file'
            cand --index-path 'The path to the index file'
            cand -h 'Print help'
            cand --help 'Print help'
            cand from-list 'Create an index from a list of empty files, one per line of the input'
            cand verify 'Validate constraints and assumptions of an index along with its integrity'
            cand info 'Print information about the index structure'
            cand checkout-exclusive 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;index;from-list'= {
            cand -i 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand --index-output-path 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work'
            cand -f 'Overwrite the specified index file if it already exists'
            cand --force 'Overwrite the specified index file if it already exists'
            cand -s 'Don''t write the trailing hash for a performance gain'
            cand --skip-hash 'Don''t write the trailing hash for a performance gain'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;index;verify'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;index;info'= {
            cand --no-details 'Do not extract specific extension information to gain only a superficial idea of the index''s composition'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;index;checkout-exclusive'= {
            cand -r 'The path to `.git` repository from which objects can be obtained to write the actual files referenced in the index. Use this measure the impact on extracting objects on overall performance'
            cand --repository 'The path to `.git` repository from which objects can be obtained to write the actual files referenced in the index. Use this measure the impact on extracting objects on overall performance'
            cand -k 'Ignore errors and keep checking out as many files as possible, and report all errors at the end of the operation'
            cand --keep-going 'Ignore errors and keep checking out as many files as possible, and report all errors at the end of the operation'
            cand -e 'Enable to query the object database yet write only empty files. This is useful to measure the overhead of ODB query compared to writing the bytes to disk'
            cand --empty-files 'Enable to query the object database yet write only empty files. This is useful to measure the overhead of ODB query compared to writing the bytes to disk'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;index;help'= {
            cand from-list 'Create an index from a list of empty files, one per line of the input'
            cand verify 'Validate constraints and assumptions of an index along with its integrity'
            cand info 'Print information about the index structure'
            cand checkout-exclusive 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;index;help;from-list'= {
        }
        &'gix;no-repo;index;help;verify'= {
        }
        &'gix;no-repo;index;help;info'= {
        }
        &'gix;no-repo;index;help;checkout-exclusive'= {
        }
        &'gix;no-repo;index;help;help'= {
        }
        &'gix;free;discover'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;no-repo;discover'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;free;help'= {
            cand commit-graph 'Subcommands for interacting with commit-graphs'
            cand mailmap 'Subcommands for interacting with mailmaps'
            cand pack 'Subcommands for interacting with pack files and indices'
            cand index 'Subcommands for interacting with a worktree index, typically at .git/index'
            cand discover 'Show information about repository discovery and when opening a repository at the current path'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;free;help;commit-graph'= {
            cand verify 'Verify the integrity of a commit graph'
        }
        &'gix;free;help;commit-graph;verify'= {
        }
        &'gix;free;help;mailmap'= {
            cand verify 'Parse all entries in the mailmap and report malformed lines or collisions'
        }
        &'gix;free;help;mailmap;verify'= {
        }
        &'gix;free;help;pack'= {
            cand index 'Subcommands for interacting with pack indices (.idx)'
            cand multi-index 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
            cand create 'Create a new pack with a set of objects'
            cand receive 'Use the gix-protocol to receive a pack, emulating a clone'
            cand explode 'Dissolve a pack into its loose objects'
            cand verify 'Verify the integrity of a pack, index or multi-index file'
        }
        &'gix;free;help;pack;index'= {
            cand create 'create a pack index from a pack data file'
        }
        &'gix;free;help;pack;index;create'= {
        }
        &'gix;free;help;pack;multi-index'= {
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
        }
        &'gix;free;help;pack;multi-index;entries'= {
        }
        &'gix;free;help;pack;multi-index;info'= {
        }
        &'gix;free;help;pack;multi-index;verify'= {
        }
        &'gix;free;help;pack;multi-index;create'= {
        }
        &'gix;free;help;pack;create'= {
        }
        &'gix;free;help;pack;receive'= {
        }
        &'gix;free;help;pack;explode'= {
        }
        &'gix;free;help;pack;verify'= {
        }
        &'gix;free;help;index'= {
            cand from-list 'Create an index from a list of empty files, one per line of the input'
            cand verify 'Validate constraints and assumptions of an index along with its integrity'
            cand info 'Print information about the index structure'
            cand checkout-exclusive 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
        }
        &'gix;free;help;index;from-list'= {
        }
        &'gix;free;help;index;verify'= {
        }
        &'gix;free;help;index;info'= {
        }
        &'gix;free;help;index;checkout-exclusive'= {
        }
        &'gix;free;help;discover'= {
        }
        &'gix;free;help;help'= {
        }
        &'gix;no-repo;help'= {
            cand commit-graph 'Subcommands for interacting with commit-graphs'
            cand mailmap 'Subcommands for interacting with mailmaps'
            cand pack 'Subcommands for interacting with pack files and indices'
            cand index 'Subcommands for interacting with a worktree index, typically at .git/index'
            cand discover 'Show information about repository discovery and when opening a repository at the current path'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;no-repo;help;commit-graph'= {
            cand verify 'Verify the integrity of a commit graph'
        }
        &'gix;no-repo;help;commit-graph;verify'= {
        }
        &'gix;no-repo;help;mailmap'= {
            cand verify 'Parse all entries in the mailmap and report malformed lines or collisions'
        }
        &'gix;no-repo;help;mailmap;verify'= {
        }
        &'gix;no-repo;help;pack'= {
            cand index 'Subcommands for interacting with pack indices (.idx)'
            cand multi-index 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
            cand create 'Create a new pack with a set of objects'
            cand receive 'Use the gix-protocol to receive a pack, emulating a clone'
            cand explode 'Dissolve a pack into its loose objects'
            cand verify 'Verify the integrity of a pack, index or multi-index file'
        }
        &'gix;no-repo;help;pack;index'= {
            cand create 'create a pack index from a pack data file'
        }
        &'gix;no-repo;help;pack;index;create'= {
        }
        &'gix;no-repo;help;pack;multi-index'= {
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
        }
        &'gix;no-repo;help;pack;multi-index;entries'= {
        }
        &'gix;no-repo;help;pack;multi-index;info'= {
        }
        &'gix;no-repo;help;pack;multi-index;verify'= {
        }
        &'gix;no-repo;help;pack;multi-index;create'= {
        }
        &'gix;no-repo;help;pack;create'= {
        }
        &'gix;no-repo;help;pack;receive'= {
        }
        &'gix;no-repo;help;pack;explode'= {
        }
        &'gix;no-repo;help;pack;verify'= {
        }
        &'gix;no-repo;help;index'= {
            cand from-list 'Create an index from a list of empty files, one per line of the input'
            cand verify 'Validate constraints and assumptions of an index along with its integrity'
            cand info 'Print information about the index structure'
            cand checkout-exclusive 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
        }
        &'gix;no-repo;help;index;from-list'= {
        }
        &'gix;no-repo;help;index;verify'= {
        }
        &'gix;no-repo;help;index;info'= {
        }
        &'gix;no-repo;help;index;checkout-exclusive'= {
        }
        &'gix;no-repo;help;discover'= {
        }
        &'gix;no-repo;help;help'= {
        }
        &'gix;blame'= {
            cand -L 'Only blame lines in the given 1-based inclusive range ''<start>,<end>'', e.g. ''20,40'''
            cand -s 'Print additional statistics to help understanding performance'
            cand --statistics 'Print additional statistics to help understanding performance'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;completions'= {
            cand -s 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand --shell 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;generate-completions'= {
            cand -s 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand --shell 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;shell-completions'= {
            cand -s 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand --shell 'The shell to generate completions for. Otherwise it''s derived from the environment'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'gix;help'= {
            cand archive 'Subcommands for creating worktree archives'
            cand clean 'Remove untracked files from the working tree'
            cand commit-graph 'Subcommands for interacting with commit-graph files'
            cand odb 'Interact with the object database'
            cand fsck 'Check for missing objects'
            cand tree 'Interact with tree objects'
            cand commit 'Interact with commit objects'
            cand verify 'Verify the integrity of the entire repository'
            cand revision 'Query and obtain information about revisions'
            cand credential 'A program just like `git credential`'
            cand fetch 'Fetch data from remotes and store it in the repository'
            cand clone 'Clone a repository into a new directory'
            cand mailmap 'Interact with the mailmap'
            cand remote 'Interact with the remote hosts'
            cand attributes 'Interact with the attribute files like .gitattributes'
            cand exclude 'Interact with the exclude files like .gitignore'
            cand index 'Interact with a worktree index like .git/index'
            cand submodule 'Interact with submodules'
            cand cat 'Show whatever object is at the given spec'
            cand is-clean 'is-clean'
            cand is-changed 'is-changed'
            cand config-tree 'Show which git configuration values are used or planned'
            cand status 'compute repository status similar to `git status`'
            cand config 'Print all entries in a configuration file or access other sub-commands'
            cand merge-base 'A command for calculating all merge-bases'
            cand merge 'perform merges of various kinds'
            cand env 'env'
            cand diff 'Print all changes between two objects'
            cand log 'List all commits in a repository, optionally limited to those that change a given path'
            cand worktree 'Commands for handling worktrees'
            cand free 'Subcommands that need no git repository to run'
            cand blame 'Blame lines in a file'
            cand completions 'Generate shell completions to stdout or a directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'gix;help;archive'= {
        }
        &'gix;help;clean'= {
        }
        &'gix;help;commit-graph'= {
            cand verify 'Verify the integrity of a commit graph file'
            cand list 'List all entries in the commit-graph file as reachable by starting from `HEAD`'
        }
        &'gix;help;commit-graph;verify'= {
        }
        &'gix;help;commit-graph;list'= {
        }
        &'gix;help;odb'= {
            cand entries 'Print all object names'
            cand info 'Provide general information about the object database'
            cand stats 'Count and obtain information on all, possibly duplicate, objects in the database'
        }
        &'gix;help;odb;entries'= {
        }
        &'gix;help;odb;info'= {
        }
        &'gix;help;odb;stats'= {
        }
        &'gix;help;fsck'= {
        }
        &'gix;help;tree'= {
            cand entries 'Print entries in a given tree'
            cand info 'Provide information about a tree'
        }
        &'gix;help;tree;entries'= {
        }
        &'gix;help;tree;info'= {
        }
        &'gix;help;commit'= {
            cand verify 'Verify the signature of a commit'
            cand describe 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
        }
        &'gix;help;commit;verify'= {
        }
        &'gix;help;commit;describe'= {
        }
        &'gix;help;verify'= {
        }
        &'gix;help;revision'= {
            cand list 'List all commits reachable from the given rev-spec'
            cand explain 'Provide the revision specification like `@~1` to explain'
            cand resolve 'Try to resolve the given revspec and print the object names'
            cand previous-branches 'Return the names and hashes of all previously checked-out branches'
        }
        &'gix;help;revision;list'= {
        }
        &'gix;help;revision;explain'= {
        }
        &'gix;help;revision;resolve'= {
        }
        &'gix;help;revision;previous-branches'= {
        }
        &'gix;help;credential'= {
            cand fill 'Get the credentials fed for `url=<url>` via STDIN'
            cand approve 'Approve the information piped via STDIN as obtained with last call to `fill`'
            cand reject 'Try to resolve the given revspec and print the object names'
        }
        &'gix;help;credential;fill'= {
        }
        &'gix;help;credential;approve'= {
        }
        &'gix;help;credential;reject'= {
        }
        &'gix;help;fetch'= {
        }
        &'gix;help;clone'= {
        }
        &'gix;help;mailmap'= {
            cand entries 'Print all entries in configured mailmaps, inform about errors as well'
            cand check 'Print the canonical form of contacts according to the configured mailmaps'
        }
        &'gix;help;mailmap;entries'= {
        }
        &'gix;help;mailmap;check'= {
        }
        &'gix;help;remote'= {
            cand refs 'Print all references available on the remote'
            cand ref-map 'Print all references available on the remote as filtered through ref-specs'
        }
        &'gix;help;remote;refs'= {
        }
        &'gix;help;remote;ref-map'= {
        }
        &'gix;help;attributes'= {
            cand validate-baseline 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
            cand query 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
        }
        &'gix;help;attributes;validate-baseline'= {
        }
        &'gix;help;attributes;query'= {
        }
        &'gix;help;exclude'= {
            cand query 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
        }
        &'gix;help;exclude;query'= {
        }
        &'gix;help;index'= {
            cand entries 'Print all entries to standard output'
            cand from-tree 'Create an index from a tree-ish'
        }
        &'gix;help;index;entries'= {
        }
        &'gix;help;index;from-tree'= {
        }
        &'gix;help;submodule'= {
            cand list 'Print all direct submodules to standard output'
        }
        &'gix;help;submodule;list'= {
        }
        &'gix;help;cat'= {
        }
        &'gix;help;is-clean'= {
        }
        &'gix;help;is-changed'= {
        }
        &'gix;help;config-tree'= {
        }
        &'gix;help;status'= {
        }
        &'gix;help;config'= {
        }
        &'gix;help;merge-base'= {
        }
        &'gix;help;merge'= {
            cand file 'Merge a file by specifying ours, base and theirs'
            cand tree 'Merge a tree by specifying ours, base and theirs, writing it to the object database'
            cand commit 'Merge a commits by specifying ours, and theirs, writing the tree to the object database'
        }
        &'gix;help;merge;file'= {
        }
        &'gix;help;merge;tree'= {
        }
        &'gix;help;merge;commit'= {
        }
        &'gix;help;env'= {
        }
        &'gix;help;diff'= {
            cand tree 'Diff two trees'
        }
        &'gix;help;diff;tree'= {
        }
        &'gix;help;log'= {
        }
        &'gix;help;worktree'= {
            cand list 'List all worktrees, along with some accompanying information'
        }
        &'gix;help;worktree;list'= {
        }
        &'gix;help;free'= {
            cand commit-graph 'Subcommands for interacting with commit-graphs'
            cand mailmap 'Subcommands for interacting with mailmaps'
            cand pack 'Subcommands for interacting with pack files and indices'
            cand index 'Subcommands for interacting with a worktree index, typically at .git/index'
            cand discover 'Show information about repository discovery and when opening a repository at the current path'
        }
        &'gix;help;free;commit-graph'= {
            cand verify 'Verify the integrity of a commit graph'
        }
        &'gix;help;free;commit-graph;verify'= {
        }
        &'gix;help;free;mailmap'= {
            cand verify 'Parse all entries in the mailmap and report malformed lines or collisions'
        }
        &'gix;help;free;mailmap;verify'= {
        }
        &'gix;help;free;pack'= {
            cand index 'Subcommands for interacting with pack indices (.idx)'
            cand multi-index 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
            cand create 'Create a new pack with a set of objects'
            cand receive 'Use the gix-protocol to receive a pack, emulating a clone'
            cand explode 'Dissolve a pack into its loose objects'
            cand verify 'Verify the integrity of a pack, index or multi-index file'
        }
        &'gix;help;free;pack;index'= {
            cand create 'create a pack index from a pack data file'
        }
        &'gix;help;free;pack;index;create'= {
        }
        &'gix;help;free;pack;multi-index'= {
            cand entries 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
            cand info 'Print general information about a multi-index file'
            cand verify 'Verify a multi-index quickly without inspecting objects themselves'
            cand create 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
        }
        &'gix;help;free;pack;multi-index;entries'= {
        }
        &'gix;help;free;pack;multi-index;info'= {
        }
        &'gix;help;free;pack;multi-index;verify'= {
        }
        &'gix;help;free;pack;multi-index;create'= {
        }
        &'gix;help;free;pack;create'= {
        }
        &'gix;help;free;pack;receive'= {
        }
        &'gix;help;free;pack;explode'= {
        }
        &'gix;help;free;pack;verify'= {
        }
        &'gix;help;free;index'= {
            cand from-list 'Create an index from a list of empty files, one per line of the input'
            cand verify 'Validate constraints and assumptions of an index along with its integrity'
            cand info 'Print information about the index structure'
            cand checkout-exclusive 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
        }
        &'gix;help;free;index;from-list'= {
        }
        &'gix;help;free;index;verify'= {
        }
        &'gix;help;free;index;info'= {
        }
        &'gix;help;free;index;checkout-exclusive'= {
        }
        &'gix;help;free;discover'= {
        }
        &'gix;help;blame'= {
        }
        &'gix;help;completions'= {
        }
        &'gix;help;help'= {
        }
    ]
    $completions[$command]
}
