/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class TextDecorationManager
extends AbstractValueManager {
    protected static final StringMap values = new StringMap();

    public boolean isInheritedProperty() {
        return false;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return false;
    }

    public int getPropertyType() {
        return 18;
    }

    public String getPropertyName() {
        return "text-decoration";
    }

    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                ListValue listValue = new ListValue(' ');
                do {
                    Object object;
                    if (lexicalUnit.getLexicalUnitType() == 35) {
                        String string = lexicalUnit.getStringValue().toLowerCase().intern();
                        object = values.get(string);
                        if (object == null) {
                            throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
                        }
                    } else {
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    }
                    listValue.append((Value)object);
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                } while (lexicalUnit != null);
                return listValue;
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s != 21) {
            throw this.createInvalidStringTypeDOMException(s);
        }
        if (!string.equalsIgnoreCase("none")) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return ValueConstants.NONE_VALUE;
    }

    static {
        values.put("blink", ValueConstants.BLINK_VALUE);
        values.put("line-through", ValueConstants.LINE_THROUGH_VALUE);
        values.put("overline", ValueConstants.OVERLINE_VALUE);
        values.put("underline", ValueConstants.UNDERLINE_VALUE);
    }
}

