/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class ShardRequestCacheRcaConfig {
    public static final String CONFIG_NAME = "shard-request-cache-rca-config";
    private Double shardRequestCacheSizeThreshold;
    private Integer shardRequestCollectorTimePeriodInSec;
    public static final double DEFAULT_SHARD_REQUEST_CACHE_SIZE_THRESHOLD = 0.9;
    public static final int DEFAULT_SHARD_REQUEST_COLLECTOR_TIME_PERIOD_IN_SEC = 300;

    public ShardRequestCacheRcaConfig(RcaConf rcaConf) {
        this.shardRequestCacheSizeThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "shard-request-cache-threshold", 0.9, s -> s > 0.0, Double.class);
        this.shardRequestCollectorTimePeriodInSec = rcaConf.readRcaConfig(CONFIG_NAME, "shard-request-collector-time-period-in-sec", 300, s -> s > 0, Integer.class);
    }

    public double getShardRequestCacheSizeThreshold() {
        return this.shardRequestCacheSizeThreshold;
    }

    public int getShardRequestCollectorTimePeriodInSec() {
        return this.shardRequestCollectorTimePeriodInSec;
    }

    public static class RCA_CONF_KEY_CONSTANTS {
        public static final String SHARD_REQUEST_CACHE_SIZE_THRESHOLD = "shard-request-cache-threshold";
        public static final String SHARD_REQUEST_COLLECTOR_TIME_PERIOD_IN_SEC = "shard-request-collector-time-period-in-sec";
    }
}

