/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.session;

import com.google.common.collect.ImmutableMap;
import lombok.Generated;
import org.opensearch.sql.spark.execution.session.SessionState;
import org.opensearch.sql.spark.execution.session.SessionType;
import org.opensearch.sql.spark.execution.statestore.StateModel;

public class SessionModel
extends StateModel {
    public static final String UNKNOWN = "unknown";
    private final String version;
    private final SessionType sessionType;
    private final String sessionId;
    private final SessionState sessionState;
    private final String accountId;
    private final String applicationId;
    private final String jobId;
    private final String datasourceName;
    private final String error;
    private final long lastUpdateTime;

    public static SessionModel of(SessionModel copy, ImmutableMap<String, Object> metadata) {
        return ((SessionModelBuilder)((StateModel.StateModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)SessionModel.builder().version(copy.version)).sessionType(copy.sessionType)).sessionId(copy.sessionId)).sessionState(copy.sessionState)).datasourceName(copy.datasourceName)).accountId(copy.accountId)).applicationId(copy.getApplicationId())).jobId(copy.jobId)).error(UNKNOWN)).lastUpdateTime(copy.getLastUpdateTime())).metadata(metadata)).build();
    }

    public static SessionModel copyWithState(SessionModel copy, SessionState state, ImmutableMap<String, Object> metadata) {
        return ((SessionModelBuilder)((StateModel.StateModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)SessionModel.builder().version(copy.version)).sessionType(copy.sessionType)).sessionId(copy.sessionId)).sessionState(state)).datasourceName(copy.datasourceName)).accountId(copy.getAccountId())).applicationId(copy.getApplicationId())).jobId(copy.jobId)).error(UNKNOWN)).lastUpdateTime(copy.getLastUpdateTime())).metadata(metadata)).build();
    }

    public static SessionModel initInteractiveSession(String accountId, String applicationId, String jobId, String sessionId, String datasourceName) {
        return ((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)((SessionModelBuilder)SessionModel.builder().version("1.0")).sessionType(SessionType.INTERACTIVE)).sessionId(sessionId)).sessionState(SessionState.NOT_STARTED)).datasourceName(datasourceName)).accountId(accountId)).applicationId(applicationId)).jobId(jobId)).error(UNKNOWN)).lastUpdateTime(System.currentTimeMillis())).build();
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Generated
    protected SessionModel(SessionModelBuilder<?, ?> b) {
        super(b);
        this.version = b.version;
        this.sessionType = b.sessionType;
        this.sessionId = b.sessionId;
        this.sessionState = b.sessionState;
        this.accountId = b.accountId;
        this.applicationId = b.applicationId;
        this.jobId = b.jobId;
        this.datasourceName = b.datasourceName;
        this.error = b.error;
        this.lastUpdateTime = b.lastUpdateTime;
    }

    @Generated
    public static SessionModelBuilder<?, ?> builder() {
        return new SessionModelBuilderImpl();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionModel)) {
            return false;
        }
        SessionModel other = (SessionModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastUpdateTime() != other.getLastUpdateTime()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        SessionType this$sessionType = this.getSessionType();
        SessionType other$sessionType = other.getSessionType();
        if (this$sessionType == null ? other$sessionType != null : !((Object)((Object)this$sessionType)).equals((Object)other$sessionType)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        SessionState this$sessionState = this.getSessionState();
        SessionState other$sessionState = other.getSessionState();
        if (this$sessionState == null ? other$sessionState != null : !((Object)((Object)this$sessionState)).equals((Object)other$sessionState)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$datasourceName = this.getDatasourceName();
        String other$datasourceName = other.getDatasourceName();
        if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SessionModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + (int)($lastUpdateTime >>> 32 ^ $lastUpdateTime);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        SessionType $sessionType = this.getSessionType();
        result = result * 59 + ($sessionType == null ? 43 : ((Object)((Object)$sessionType)).hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        SessionState $sessionState = this.getSessionState();
        result = result * 59 + ($sessionState == null ? 43 : ((Object)((Object)$sessionState)).hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $datasourceName = this.getDatasourceName();
        result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SessionModel(version=" + this.getVersion() + ", sessionType=" + this.getSessionType() + ", sessionId=" + this.getSessionId() + ", sessionState=" + this.getSessionState() + ", accountId=" + this.getAccountId() + ", applicationId=" + this.getApplicationId() + ", jobId=" + this.getJobId() + ", datasourceName=" + this.getDatasourceName() + ", error=" + this.getError() + ", lastUpdateTime=" + this.getLastUpdateTime() + ")";
    }

    @Generated
    private static final class SessionModelBuilderImpl
    extends SessionModelBuilder<SessionModel, SessionModelBuilderImpl> {
        @Generated
        private SessionModelBuilderImpl() {
        }

        @Override
        @Generated
        protected SessionModelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SessionModel build() {
            return new SessionModel(this);
        }
    }

    @Generated
    public static abstract class SessionModelBuilder<C extends SessionModel, B extends SessionModelBuilder<C, B>>
    extends StateModel.StateModelBuilder<C, B> {
        @Generated
        private String version;
        @Generated
        private SessionType sessionType;
        @Generated
        private String sessionId;
        @Generated
        private SessionState sessionState;
        @Generated
        private String accountId;
        @Generated
        private String applicationId;
        @Generated
        private String jobId;
        @Generated
        private String datasourceName;
        @Generated
        private String error;
        @Generated
        private long lastUpdateTime;

        @Generated
        public B version(String version) {
            this.version = version;
            return (B)this.self();
        }

        @Generated
        public B sessionType(SessionType sessionType) {
            this.sessionType = sessionType;
            return (B)this.self();
        }

        @Generated
        public B sessionId(String sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        @Generated
        public B sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return (B)this.self();
        }

        @Generated
        public B accountId(String accountId) {
            this.accountId = accountId;
            return (B)this.self();
        }

        @Generated
        public B applicationId(String applicationId) {
            this.applicationId = applicationId;
            return (B)this.self();
        }

        @Generated
        public B jobId(String jobId) {
            this.jobId = jobId;
            return (B)this.self();
        }

        @Generated
        public B datasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return (B)this.self();
        }

        @Generated
        public B error(String error) {
            this.error = error;
            return (B)this.self();
        }

        @Generated
        public B lastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SessionModel.SessionModelBuilder(super=" + super.toString() + ", version=" + this.version + ", sessionType=" + this.sessionType + ", sessionId=" + this.sessionId + ", sessionState=" + this.sessionState + ", accountId=" + this.accountId + ", applicationId=" + this.applicationId + ", jobId=" + this.jobId + ", datasourceName=" + this.datasourceName + ", error=" + this.error + ", lastUpdateTime=" + this.lastUpdateTime + ")";
        }
    }
}

