// api-header.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#ifndef OAI_OAIUserAppRoleAssignmentApi_H
#define OAI_OAIUserAppRoleAssignmentApi_H

#include "OAIHelpers.h"
#include "OAIHttpRequest.h"
#include "OAIServerConfiguration.h"
#include "OAIOauth.h"

#include "OAIAppRoleAssignment.h"
#include "OAICollection_of_appRoleAssignments.h"
#include "OAIOdata_error.h"
#include <QString>

#include <QObject>
#include <QByteArray>
#include <QStringList>
#include <QList>
#include <QNetworkAccessManager>

namespace OpenAPI {

class OAIUserAppRoleAssignmentApi : public QObject {
    Q_OBJECT

public:
    OAIUserAppRoleAssignmentApi(const int timeOut = 0);
    ~OAIUserAppRoleAssignmentApi();

    void initializeServerConfigs();
    int setDefaultServerValue(int serverIndex,const QString &operation, const QString &variable,const QString &val);
    void setServerIndex(const QString &operation, int serverIndex);
    void setApiKey(const QString &apiKeyName, const QString &apiKey);
    void setBearerToken(const QString &token);
    void setUsername(const QString &username);
    void setPassword(const QString &password);
    void setTimeOut(const int timeOut);
    void setWorkingDirectory(const QString &path);
    void setNetworkAccessManager(QNetworkAccessManager* manager);
    int addServerConfiguration(const QString &operation, const QUrl &url, const QString &description = "", const QMap<QString, OAIServerVariable> &variables = QMap<QString, OAIServerVariable>());
    void setNewServerForAllOperations(const QUrl &url, const QString &description = "", const QMap<QString, OAIServerVariable> &variables =  QMap<QString, OAIServerVariable>());
    void setNewServer(const QString &operation, const QUrl &url, const QString &description = "", const QMap<QString, OAIServerVariable> &variables =  QMap<QString, OAIServerVariable>());
    void addHeaders(const QString &key, const QString &value);
    void enableRequestCompression();
    void enableResponseCompression();
    void abortRequests();
    QString getParamStylePrefix(const QString &style);
    QString getParamStyleSuffix(const QString &style);
    QString getParamStyleDelimiter(const QString &style, const QString &name, bool isExplode);

    /**
    * @param[in]  user_id QString [required]
    * @param[in]  oai_app_role_assignment OAIAppRoleAssignment [required]
    */
    void user_CreateAppRoleAssignments(const QString &user_id, const OAIAppRoleAssignment &oai_app_role_assignment);

    /**
    * @param[in]  user_id QString [required]
    * @param[in]  app_role_assignment_id QString [required]
    * @param[in]  if_match QString [optional]
    */
    void user_DeleteAppRoleAssignments(const QString &user_id, const QString &app_role_assignment_id, const ::OpenAPI::OptionalParam<QString> &if_match = ::OpenAPI::OptionalParam<QString>());

    /**
    * @param[in]  user_id QString [required]
    */
    void user_ListAppRoleAssignments(const QString &user_id);


private:
    QMap<QString,int> _serverIndices;
    QMap<QString,QList<OAIServerConfiguration>> _serverConfigs;
    QMap<QString, QString> _apiKeys;
    QString _bearerToken;
    QString _username;
    QString _password;
    int _timeOut;
    QString _workingDirectory;
    QNetworkAccessManager* _manager;
    QMap<QString, QString> _defaultHeaders;
    bool _isResponseCompressionEnabled;
    bool _isRequestCompressionEnabled;
    OAIHttpRequestInput _latestInput;
    OAIHttpRequestWorker *_latestWorker;
    QStringList _latestScope;
    OauthCode _authFlow;
    OauthImplicit _implicitFlow;
    OauthCredentials _credentialFlow;
    OauthPassword _passwordFlow;
    int _OauthMethod = 0;

    void user_CreateAppRoleAssignmentsCallback(OAIHttpRequestWorker *worker);
    void user_DeleteAppRoleAssignmentsCallback(OAIHttpRequestWorker *worker);
    void user_ListAppRoleAssignmentsCallback(OAIHttpRequestWorker *worker);

signals:

    void user_CreateAppRoleAssignmentsSignal(OAIAppRoleAssignment summary);
    void user_DeleteAppRoleAssignmentsSignal();
    void user_ListAppRoleAssignmentsSignal(OAICollection_of_appRoleAssignments summary);

    void user_CreateAppRoleAssignmentsSignalFull(OAIHttpRequestWorker *worker, OAIAppRoleAssignment summary);
    void user_DeleteAppRoleAssignmentsSignalFull(OAIHttpRequestWorker *worker);
    void user_ListAppRoleAssignmentsSignalFull(OAIHttpRequestWorker *worker, OAICollection_of_appRoleAssignments summary);

    void user_CreateAppRoleAssignmentsSignalE(OAIAppRoleAssignment summary, QNetworkReply::NetworkError error_type, QString error_str);
    void user_DeleteAppRoleAssignmentsSignalE(QNetworkReply::NetworkError error_type, QString error_str);
    void user_ListAppRoleAssignmentsSignalE(OAICollection_of_appRoleAssignments summary, QNetworkReply::NetworkError error_type, QString error_str);

    void user_CreateAppRoleAssignmentsSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void user_DeleteAppRoleAssignmentsSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void user_ListAppRoleAssignmentsSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);

    void abortRequestsSignal();
    void allPendingRequestsCompleted();

public slots:
    void tokenAvailable();
    
};

} // namespace OpenAPI
#endif
